<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2022 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>
<c:choose>
  <c:when test="${level == 0}">
    <c:set var="fontStyle" value="color:black"/>
    <c:set var="headerClass" value="headercell4"/>
    <c:set var="datacell" value="headercell4"/>
  </c:when>
  <c:when test="${level == 1}">
    <c:set var="fontStyle" value="color:white"/>
    <c:set var="headerClass" value="headercell3-b-l"/>
    <c:set var="datacell" value="headercell4"/>
  </c:when>
  <c:otherwise>
    <c:set var="fontStyle" value=""/>
    <c:set var="headerClass" value="thnormal"/>
    <c:set var="datacell" value="datacell"/>
  </c:otherwise>
</c:choose>
<tr>
    <td align="center" align="right" class="<c:out value="${headerClass}"/>">
        <c:if test="${level == 0 || !empty actionRequest.childrenRequests }">
            <button
                type="button"
                class="btn btn-default"
                title="show"
                alt="show"
                onclick="rend(this, false)"
                id="F<c:out value="${index}" />"
            >
                Show
            </button>
        </c:if>
        &nbsp;
    </td>
    <td align="center" class="<c:out value="${headerClass}"/>" nowrap="nowrap">
        <b>
            <c:out value="${actionRequest.displayStatus}" />
            <c:if test="${actionRequest.displayStatus != null}">
                <br>
            </c:if>
            <c:out value="${actionRequest.actionRequestedLabel}" />
        </b>
    </td>
    <kul:actionRequestIdentityCell actionRequest="${actionRequest}" headerClass="${headerClass}" />
    <td align="center" class="<c:out value="${headerClass}"/>" nowrap="nowrap">
       <b>&nbsp;<fmt:formatDate value="${actionRequest.createDate}" pattern="${KFSConstants.DEFAULT_DATE_FORMAT_PATTERN}" /></b>
    </td>
    <td align="left" class="<c:out value="${headerClass}"/>">
        &nbsp;<c:out value="${actionRequest.annotation}" />
        <%-- If we are dealing with a primary delegate, display the annotations for the primary delegates at top level --%>
        <c:if test="${actionRequest.roleRequest}">
          <c:forEach var="roleRequest" items="${actionRequest.childrenRequests}" varStatus="arStatus">
              <c:if test="${roleRequest.primaryDelegator}">
                  <c:forEach var="primDelegateRoleRequest" items="${roleRequest.childrenRequests}">
                      <c:if test="${!empty primDelegateRoleRequest.annotation}">
                          <br />
                          <c:out value="${primDelegateRoleRequest.annotation}"/>
                      </c:if>
                  </c:forEach>
              </c:if>
          </c:forEach>
        </c:if>
        <%-- ${actionRequest} --%>
    </td>
</tr>
<c:if test="${level == 0 || !empty actionRequest.childrenRequests }">
<tr id="G<c:out value="${index}" />" style="display: none;">
    <td align="right" class="thnormal">
       <img src="static/images/pixel_clear.gif" width="60" height="20">
    </td>
    <td colspan="4" style="padding: 0; border: 0;">
       <jsp:include page="ActionRequests.jsp" flush="true" />
    </td>
</tr>
</c:if>
