<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2025 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<%@ attribute name="rows" required="true" type="java.util.List"
              description="The rows of fields that we'll iterate to display." %>
<%@ attribute name="numberOfColumns" required="false"
              description="The # of fields in this row." %>
<%@ attribute name="skipTheOldNewBar" required="false"
              description="boolean that indicates whether the old and new bar should be skipped" %>
<%@ attribute name="depth" required="false"
              description="the recursion depth number" %>
<%@ attribute name="rowsHidden" required="false"
              description="boolean that indicates whether the rows should be hidden or all fields are hidden" %>
<%@ attribute name="rowsReadOnly" required="false"
              description="boolean that indicates whether the rows should be rendered as read-only (note that rows will automatically be rendered as readonly if it is an inquiry or if it is a maintenance document in readOnly mode" %>
<%@ attribute name="sessionDocument" required="false"
              description="boolean that indicates whether the sessionDocument declared in DD" %>

<c:if test="${empty depth}">
    <c:set var="depth" value="0" />
</c:if>

<%-- Is the screen a lookup? --%>
<c:set var="isLookup" value="${false}" />

<%-- Is the form read-only? --%>
<c:set var="isFormReadOnly" value="${rowsReadOnly}" />

<%-- What's the user trying to do? --%>
<c:set var="requestedAction" value="${KualiForm.methodToCall}" />

<c:set var="isHeaderDisplayed" value="false" />
<c:set var="rowCount" value="${rows.size()}"/>
<thead>
    <tr>
        <c:set var="isSubSection" value="false" />
        <c:forEach items="${rows[0].fields[0].containerRows}" var="subRowLabels">
            <c:if test="${subRowLabels.fields[0].fieldType eq subRowLabels.fields[0].SUB_SECTION_SEPARATOR}">
                <c:set var="isSubSection" value="true" />
            </c:if>
            <c:if test="${!isSubSection}">
                <th class="collapsed-header"><c:out value="${subRowLabels.fields[0].fieldLabel}" /></th>
            </c:if>
        </c:forEach>
    </tr>
</thead>
<c:forEach items="${rows}" var="row" varStatus="rowVarStatus">

    <c:set var="rowHidden" value="${rowsHidden || row.hidden}" />

    <c:forEach items="${row.fields}" var="field" varStatus="fieldVarStatus">
        <c:set var="isFieldAContainer" value="${field.fieldType eq field.CONTAINER}" />
        <c:set var="isFieldAddingToACollection" value="${fn:contains(field.propertyName, 'add.')}" />

        <c:set var="headerColspan" value="${numberOfColumns * 2}" />
        <c:set var="dataCellWidth" value="${100 / (numberOfColumns * ((requestedAction eq 'addLine') ? 4 : 2))}" />

        <c:set var="tabIndex" value="0"/>
        <c:set var="dummyIncrementVar" value="${kfunc:incrementTabIndex(KualiForm, tabIndex)}" />

        <%--
            ###################################################################
            # GATHER SOME INFORMATION ABOUT THE FIELD AND STORE IT IN VARIABLES
            ################################################################### --%>
        <%-- isFieldSecure determines whether or not the encrypted value should be shown for
        non-collections and a similar function for collections --%>
        <c:set var="isFieldSecure" value="${field.secure}" />

        <%-- isFieldReadOnly determines whether or not a field is readOnly --%>
        <%-- NOTE: The part about "fieldVarStatus.count mod 2" will work for any even number
        of columns assuming that all columns alternate between read-only and not-read-only. --%>
        <c:set var="isFieldReadOnly" value="${isFieldSecure || field.readOnly || isFormReadOnly}" />

        <%-- textStyle is used to store the style of the field value. i.e. whether or not it
        should display as red text. --%>
        <c:set var="textStyle" value="" />

        <%-- fieldValue should be used to store the appropriate value for a field, i.e. handle
        showing the encrypted value if a field is secure, etc. --%>
        <c:set var="fieldValue" value="${field.propertyValue}" />

        <%--
            #######################################################
            # PojoForm saves request input that the Formatter framework
            # could not convert to the type of a given field,
            # so that it can be redisplayed here for correction.
            #
            # (jdb) KualiRequestProcessor.processPopulate() puts this
            # in the request too (UnconvertedHash and UnconvertedValues),
            # but is that necessary?  Also, the non-maintenance
            # docs get this automatically by using the Struts tags
            # (e.g., html:text), because Struts is using PojoPropertyUtilsBean.
            # Should the maintenance framework use the Struts html tags too?
            ####################################################### --%>
        <c:set var="unconvertedValue" value="${KualiForm.unconvertedValues[field.propertyName]}"/>
        <c:if test="${not empty unconvertedValue}">
            <c:set var="textStyle" value="border-color: red" />
            <c:set var="fieldValue" value="${unconvertedValue}" />
        </c:if>

        <%--
            #######################################################
            # If the field has errors, highlight its display in red.
            ####################################################### --%>
        <kul:checkErrors keyMatch="${field.propertyName}" />

        <%--
            #######################################################
            # Set the onBlur handlers for the field.
            ####################################################### --%>
        <c:set var="onblur" value="" />
        <c:set var="onblurcall" value="" />

        <c:if test="${!(empty field.webOnBlurHandler)}">
            <c:set var="onblurParameters" value="" />
            <c:choose>
                <c:when test="${!(empty field.webOnBlurHandlerCallback)}">
                    <c:set var="onblurParameters" value="this, ${field.webOnBlurHandlerCallback}" />
                </c:when>
                <c:otherwise>
                    <c:set var="onblurParameters" value="this" />
                </c:otherwise>
            </c:choose>
            <c:if test="${!(empty field.webUILeaveFieldFunctionParameters)}">
                <c:set var="onblurParameters" value="${onblurParameters},${field.webUILeaveFieldFunctionParametersString}" />
            </c:if>

            <c:set var="onblur" value="${field.webOnBlurHandler}( ${onblurParameters} );" />
            <c:set var="onblurcall" value='onblur="${onblur}"' />
        </c:if>

        <%-- Set onchange to submit form if field configured to trigger on change --%>
        <c:set var="onchange" value="" />
        <c:set var="onchangecall" value="" />

        <c:if test="${field.triggerOnChange}">
            <c:set var="onchange" value="setFieldToFocusAndSubmit(this);" />
            <c:set var="onchangecall" value='onchange="${onchange}"' />
        </c:if>
        <c:choose>
            <c:when test="${isFieldAContainer}">
                <tr class="${rowHidden ? 'hidden-row' : 'tab-subhead'}">
                    <kul:checkTabHighlight rows="${field.containerRows}" addHighlighting="${addHighlighting}" />

                    <c:set var="isSubSectionField" value="false" />
                    <c:forEach items="${field.containerRows}" var="subRows" varStatus="subRowVarStatus">
                        <c:forEach items="${subRows.fields}" var="subField" varStatus="subFieldVarStatus">
                            <c:if test="${subField.fieldType eq subField.SUB_SECTION_SEPARATOR}">
                                <c:set var="isSubSectionField" value="true" />
                            </c:if>
                            <c:if test="${!isSubSectionField}">
                                <td class="grid">
                                    <kul:fieldShowReadOnly field="${subField}" addHighlighting="${addHighlighting}" isLookup="${isLookup}" />
                                </td>
                            </c:if>
                        </c:forEach>
                    </c:forEach>
                </tr>
                <tr class="${rowHidden ? 'hidden-row' : ''}">
                    <td colspan="10">
                        <table>
                            <tr class="sub-section">
                                <c:set var="hasSeparator" value="false" />
                                <c:forEach items="${field.containerRows}" var="subRows" varStatus="subRowVarStatus">
                                    <c:forEach items="${subRows.fields}" var="subField" varStatus="subFieldVarStatus">
                                        <c:if test="${hasSeparator}">
                                            <td>
                                                ${subField.fieldLabel}: <kul:fieldShowReadOnly field="${subField}" addHighlighting="${addHighlighting}" isLookup="${isLookup}" />
                                                <c:if test="${empty subField.propertyValue}">
                                                    [empty]
                                                </c:if>
                                            </td>
                                        </c:if>
                                        <c:if test="${subField.fieldType eq subField.SUB_SECTION_SEPARATOR}">
                                            <c:set var="hasSeparator" value="true" />
                                            <td class="spacer"></td>
                                            <td>
                                                ${subField.fieldLabel}:
                                            </td>
                                        </c:if>
                                    <!-- render sub table if CONTAINER -->

                                        <c:if test="${subField.fieldType eq subField.CONTAINER and subField.fieldType ne subField.SUB_SECTION_SEPARATOR}">
                                            <c:set var="isFieldAddingToACollection" value="${fn:contains(subField.propertyName, 'add.')}" />
                                            <td class="spacer"></td>
                                            <td>
                                                <kul:containerElementSubTabTitle containerField="${subField}" isFieldAddingToACollection="${isFieldAddingToACollection}"/>:
                                            </td>
                                            <c:forEach items="${subField.containerRows}" var="nestedRows">
                                                <c:forEach items="${nestedRows.fields}" var="nestedField">
                                                    <td>
                                                        ${nestedField.fieldLabel}: <kul:fieldShowReadOnly field="${nestedField}" addHighlighting="${addHighlighting}" isLookup="${isLookup}" />
                                                        <c:if test="${empty nestedField.propertyValue}">
                                                            [empty]
                                                        </c:if>
                                                    </td>
                                                </c:forEach>
                                            </c:forEach>
                                        </c:if>
                                    </c:forEach>
                                </c:forEach>
                            </tr>
                        </table>
                    </td>
                </tr>
            </c:when>
        </c:choose>

    </c:forEach>

    <c:if test="${numberOfColumns > 1 && rowVarStatus.index == rowCount - 1 && rowCount % 2 != 0}">
        <th></th><td></td>
    </c:if>


</c:forEach>
