/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2024 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// eslint-disable-next-line
function onblur_subAccountTypeCode(subAccountTypeCodeField) {
  // need to call findElPrefix twice to strip off the a21SubAccount prefix
  var subAccountTypeCodeFieldName = subAccountTypeCodeField.name
  var fieldPrefix = findElPrefix(findElPrefix(subAccountTypeCodeFieldName))
  var chartCodeFieldName = fieldPrefix + '.chartOfAccountsCode'
  var accountNumberFieldName = fieldPrefix + '.accountNumber'

  // alert("chartCodeFieldName = " + chartCodeFieldName + ", accountNumberFieldName = " + accountNumberFieldName + ", subAccountTypeCodeFieldName = " + subAccountTypeCodeFieldName);
  updateCgIcrAccount(
    chartCodeFieldName,
    accountNumberFieldName,
    subAccountTypeCodeFieldName
  )
}

/* This function is for the primary key account number in SubAccount BO. */
// eslint-disable-next-line
function onblur_accountNumberPK(accountNumberField) {
  var accountNumberFieldName = accountNumberField.name
  var fieldPrefix = findElPrefix(accountNumberFieldName)
  var chartCodeFieldName = fieldPrefix + '.chartOfAccountsCode'
  var subAccountTypeCodeFieldName =
    fieldPrefix + '.a21SubAccount.subAccountTypeCode'
  // alert("chartCodeFieldName = " + chartCodeFieldName + ", accountNumberFieldName = " + accountNumberFieldName + ", subAccountTypeCodeFieldName = " + subAccountTypeCodeFieldName);

  var dwrReply = {
    callback: function (param) {
      if (typeof param === 'boolean' && param === false) {
        loadChartCode(
          chartCodeFieldName,
          accountNumberFieldName,
          subAccountTypeCodeFieldName,
          true
        )
      } else {
        updateCgIcrAccount(
          chartCodeFieldName,
          accountNumberFieldName,
          subAccountTypeCodeFieldName
        )
      }
    },
    errorHandler: function (errorMessage) {
      window.status = errorMessage
    }
  }
  AccountService.accountsCanCrossCharts(dwrReply) // eslint-disable-line no-undef
}

function updateCgIcrAccount (
  chartCodeFieldName,
  accountNumberFieldName,
  subAccountTypeCodeFieldName
) {
  var prefix = 'document.newMaintainableObject.a21SubAccount'

  // check if the current user has permissions to the ICR fields
  var kualiElement = kualiElements[prefix + '.financialIcrSeriesIdentifier']
  if (kualiElement.type.toLowerCase() === 'hidden') {
    return
  }

  var chartCode = getElementValue(chartCodeFieldName)
  var accountNumber = getElementValue(accountNumberFieldName)
  var subAccountTypeCode = getElementValue(subAccountTypeCodeFieldName)
  // alert("chartCode = " + chartCode + ", accountNumber = " + accountNumber + ", subAccountTypeCode = " + subAccountTypeCode);

  if (chartCode === '' || accountNumber === '' || subAccountTypeCode === '') {
    setElementValue(prefix + '.financialIcrSeriesIdentifier', '')
    setElementValue(prefix + '.offCampusCode', '')
    setElementValue(prefix + '.indirectCostRecoveryTypeCode', '')
  } else {
    var dwrReply = {
      callback: updateCgIcrAccount_Callback,
      errorHandler: function (errorMessage) {
        window.status = errorMessage
      }
    }

    // eslint-disable-next-line no-undef
    A21SubAccountService.buildCgIcrAccount(
      chartCode,
      accountNumber,
      null,
      subAccountTypeCode,
      dwrReply
    )
  }
}

// eslint-disable-next-line
function updateCgIcrAccount_Callback(data) {
  var prefix = 'document.newMaintainableObject.a21SubAccount'

  if (data != null) {
    setElementValue(
      prefix + '.financialIcrSeriesIdentifier',
      data.financialIcrSeriesIdentifier
    )
    setElementValue(prefix + '.offCampusCode', data.offCampusCode)
    setElementValue(
      prefix + '.indirectCostRecoveryTypeCode',
      data.indirectCostRecoveryTypeCode
    )
  } else {
    setElementValue(prefix + '.financialIcrSeriesIdentifier', '')
    setElementValue(prefix + '.offCampusCode', '')
    setElementValue(prefix + '.indirectCostRecoveryTypeCode', '')
  }
}

/* This function is for the a21SubAccount account numbers in SubAccount BO. */
// eslint-disable-next-line
function onblur_accountNumberA21Sub(accountNumberField, chartCodePropertyName) {
  // need to call findElPrefix twice to strip off the a21SubAccount prefix
  var accountNumberFieldName = accountNumberField.name
  var fieldPrefix = findElPrefix(findElPrefix(accountNumberFieldName))
  var chartCodeFieldName = fieldPrefix + '.' + chartCodePropertyName
  // alert("chartCodeFieldName = " + chartCodeFieldName + ", accountNumberFieldName = " + accountNumberFieldName);

  var dwrReply = {
    callback: function (param) {
      if (typeof param === 'boolean' && param === false) {
        loadChartCode(chartCodeFieldName, accountNumberFieldName, null, false)
      }
    },
    errorHandler: function (errorMessage) {
      window.status = errorMessage
    }
  }
  AccountService.accountsCanCrossCharts(dwrReply) // eslint-disable-line no-undef
}

function loadChartCode (
  chartCodeFieldName,
  accountNumberFieldName,
  subAccountTypeCodeFieldName,
  shouldUpdateCgIcr
) {
  var accountNumber = getElementValue(accountNumberFieldName)

  if (accountNumber === '') {
    clearRecipients(chartCodeFieldName)
  } else {
    var dwrReply = {
      callback: function (data) {
        // alert("chartCode = " + data.chartOfAccountsCode + ", accountNumber = " + accountNumber);
        if (data != null && typeof data === 'object') {
          setRecipientValue(chartCodeFieldName, data.chartOfAccountsCode)
        } else {
          clearRecipients(chartCodeFieldName)
        }
        // call updateCgIcrAccount here instead of in onblur_accountNumberPK, because DWR calls are asynchronized,
        // so need to make sure to wait till chartCodeField is set before calling updateCgIcrAccount
        if (shouldUpdateCgIcr === true) {
          updateCgIcrAccount(
            chartCodeFieldName,
            accountNumberFieldName,
            subAccountTypeCodeFieldName
          )
        }
      },
      errorHandler: function (errorMessage) {
        clearRecipients(chartCodeFieldName)
        window.status = errorMessage
      }
    }
    AccountService.getUniqueAccountForAccountNumber(accountNumber, dwrReply) // eslint-disable-line no-undef
  }
}
