/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2024 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Java script to fetch the Letter of Credit Fund Group for the appropriate Letter of Credit Fund
 */
// eslint-disable-next-line
function onblur_letterOfCreditFundCode(letterOfCreditFundCodeField) {
  // eslint-disable-next-line no-undef
  singleKeyLookup(
    LetterOfCreditFundService.getByPrimaryId, // eslint-disable-line no-undef
    letterOfCreditFundCodeField,
    'letterOfCreditFund.letterOfCreditFundGroup',
    'letterOfCreditFundGroupDescription'
  )
}

/*
  If the billing frequency code changes to Milestone or Predetermined Billing, we want to update the
  Invoicing Option to Invoicing by Schedule and disable it so the user can't change it. If the billing frequency
  code changes to a non-schedule frequency, we re-enable the Invoicing Option select and clear the value so the
  user has to select something.
 */
var onchange_billingFrequencyCode = function (billingFrequencyCodeSelect) {
    var billingFrequencyCode = billingFrequencyCodeSelect.options[billingFrequencyCodeSelect.selectedIndex];
    var invoicingOptionSelect = document.getElementById('document.newMaintainableObject.invoicingOptionCode');
    if (billingFrequencyCode.value === 'MILE' || billingFrequencyCode.value === 'PDBS') {
        invoicingOptionSelect.disabled = true;
        invoicingOptionSelect.selectedIndex = 4;
    } else if (invoicingOptionSelect.selectedIndex === 4) {
        invoicingOptionSelect.disabled = false;
        invoicingOptionSelect.selectedIndex = 0;
    }
}

/*
  Setup an event listener to handle changes to the billing frequency code and call it now so that if the value was
  changed by the lookup we can process the change appropriately.
 */
document.addEventListener('DOMContentLoaded', function() {
  var billingFrequencyCodeSelect = document.getElementById('document.newMaintainableObject.billingFrequencyCode');
  if (billingFrequencyCodeSelect) {
      billingFrequencyCodeSelect.addEventListener('change', function(e) {
          onchange_billingFrequencyCode(e.currentTarget);
      });
      onchange_billingFrequencyCode(billingFrequencyCodeSelect);
  }
});
