<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2023 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<c:if test="${ documentTypeStruct.shouldDisplay }" >
  <c:set var="documentType" value="${documentTypeStruct.documentType}" />
  <c:if test="${documentType.currentInd == true && documentType.active == true}">
    <c:choose>
      <c:when test="${excludeDocId != documentType.documentTypeId}">
        <table style="background-color: #EEEEEE; margin: 0 16px; width: 97%;">
          <tbody>
            <tr style="line-height: 0">
              <td>
                <h6 style="margin: 0 0 0 5px;">
                  <kul:inquiry
                      keyValues="documentTypeId=${documentType.documentTypeId}"
                      boClassName="org.kuali.kfs.kew.doctype.bo.DocumentType"
                      render="true"
                      noExternalWindow="true"
                  >
                    <c:choose>
                      <c:when test="${documentType.label != documentType.name}">
                        <c:out value="${documentType.label} (${documentType.name})" />
                      </c:when>
                      <c:otherwise>
                        <c:out value="${documentType.label}" />
                      </c:otherwise>
                    </c:choose>
                  </kul:inquiry>
                </h6>
              </td>
              <td align="right" style="position: relative;">
                <c:if test="${KualiForm.canInitiateDocumentTypeDocument}">
                <input type="button" class="document-edit-view" onclick="handleValueClick('${documentType.name}')" value="..."/>
                <div id="document-dropdown-${documentType.name}" class="document-edit-menu">
                  <a style="margin-top: 8px;" href="<c:url value="${ConfigProperties.application.url}/${KRADConstants.MAINTENANCE_ACTION}">
                          <c:param name="methodToCall" value="edit" />
                          <c:param name="businessObjectClassName" value="org.kuali.kfs.kew.doctype.bo.DocumentType"/>
                          <c:param name="documentTypeId" value="${documentType.documentTypeId}"/>
                          <c:param name="name" value="${documentType.name}"/>
                        </c:url>" target="_blank">
                    Edit Document Type
                  </a>
                  </c:if>
                  <a href="<c:url value="DocumentConfigurationView.do">
                    <c:param name="methodToCall" value="start" />
                    <c:param name="documentTypeName" value="${documentType.name}"/>
                    </c:url>" target="_blank">
                    View Document Configuration
                  </a>
                </div>
              </td>
            </tr>
          </tbody>
        </table>
        <table>
          <c:forEach items="${documentTypeStruct.flattenedNodes}" var="routeLevel">
            <c:if test="${routeLevel.roleNode}">
              <tr>
                <kul:htmlAttributeHeaderCell style="padding: 8px 0 0 3em;" nowrap="nowrap" width="50%"  scope="col" align="left" colspan="2">
                  <c:out value="${routeLevel.routeNodeName}" />
                </kul:htmlAttributeHeaderCell>
              </tr>
            </c:if>
          </c:forEach>
        </table>
        <c:if test="${! empty documentTypeStruct.childrenDocumentTypes}">
          <div class="tab-container" style="margin-left: 3em;">
            <c:forEach items="${documentTypeStruct.childrenDocumentTypes}" var="childDocumentTypeStruct">
              <c:set var="documentTypeStruct" value="${childDocumentTypeStruct}" scope="request"/>
              <c:import url="RuleQuickLinksDocumentTypeLinks.jsp" />
            </c:forEach>
          </div>
        </c:if>
      </c:when>
      <%-- have for the "excluded" document type - really the header one --%>
      <c:otherwise>
        <table>
          <c:forEach items="${documentTypeStruct.flattenedNodes}" var="routeLevel">
            <c:if test="${routeLevel.routeMethodName != KRADConstants.EXCEPTION_ROUTE_MODULE_NAME &&
                routeLevel.routeMethodName != KRADConstants.ADHOC_ROUTE_MODULE_NAME}">
              <c:if test="${routeLevel.roleNode}">
                <tr>
                  <kul:htmlAttributeHeaderCell width="50%"  scope="col" align="left" colspan="2" nowrap="nowrap">
                    <c:out value="${routeLevel.routeNodeName}" />
                  </kul:htmlAttributeHeaderCell>
                </tr>
              </c:if>
            </c:if>
          </c:forEach>
        </table>
        <c:if test="${! empty documentTypeStruct.childrenDocumentTypes}">
          <c:forEach items="${documentTypeStruct.childrenDocumentTypes}" var="childDocumentTypeStruct">
            <c:set var="documentTypeStruct" value="${childDocumentTypeStruct}" scope="request"/>
            <c:import url="RuleQuickLinksDocumentTypeLinks.jsp" />
          </c:forEach>
        </c:if>
      </c:otherwise>
    </c:choose>
    <c:if test="${! empty documentTypeStruct.childrenDocumentTypes}">
      <c:forEach items="${documentTypeStruct.childrenDocumentTypes}" var="childDocumentTypeStruct">
        <c:set var="documentTypeStruct" value="${childDocumentTypeStruct}" scope="request"/>
        <c:import url="RuleQuickLinksDocumentTypeLinks.jsp" />
      </c:forEach>
    </c:if>
  </c:if>
</c:if>
