/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ant.AbstractArtifactWithRepositoryTask;
import org.apache.maven.artifact.ant.AttachedArtifact;
import org.apache.maven.artifact.ant.POMPropertyEvaluator;
import org.apache.maven.artifact.ant.POMPropertyHelper;
import org.apache.maven.artifact.ant.Profile;
import org.apache.maven.artifact.ant.RemoteRepository;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Build;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Scm;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pom
extends AbstractArtifactWithRepositoryTask {
    private String refid;
    String antId;
    private MavenProject mavenProject;
    private File file;
    private List<Profile> profiles = new ArrayList<Profile>();
    private boolean inheritAllProperties = true;
    private final POMPropertyHelper helper = new POMPropertyHelper(this);

    public String getRefid() {
        return this.refid;
    }

    public void setRefid(String refid) {
        this.refid = refid;
    }

    public void setId(String id) {
        this.antId = id;
    }

    protected void getPomFromAntProject(String refid) {
        if (refid == null) {
            throw new BuildException("POM refid is null.");
        }
        if (this.getProject().getReference(refid) == null) {
            throw new BuildException("Unable to locate POM reference: '" + refid + "'");
        }
        Pom thePom = (Pom)((Object)this.getProject().getReference(refid));
        this.mavenProject = thePom.getMavenProject();
        this.file = thePom.getFile();
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public List<Profile> getProfiles() {
        return this.profiles;
    }

    public void addProfile(Profile activeProfile) {
        this.profiles.add(activeProfile);
    }

    public Artifact getArtifact() {
        return this.getMavenProject().getArtifact();
    }

    public void attach(AttachedArtifact attached) {
        MavenProjectHelper helper = (MavenProjectHelper)this.lookup(MavenProjectHelper.ROLE);
        MavenProject project = this.getMavenProject();
        if (attached.getClassifier() != null) {
            helper.attachArtifact(project, attached.getType(), attached.getClassifier(), attached.getFile());
        } else {
            helper.attachArtifact(project, attached.getType(), attached.getFile());
        }
    }

    public List<Artifact> getAttachedArtifacts() {
        return this.getMavenProject().getAttachedArtifacts();
    }

    public void initialiseMavenProject(MavenProjectBuilder builder, ArtifactRepository localRepository) {
        if (this.file != null) {
            this.addAntRepositoriesToProfileManager();
            ProjectBuilderConfiguration builderConfig = this.createProjectBuilderConfig(localRepository);
            try {
                this.mavenProject = builder.build(this.file, builderConfig);
                builder.calculateConcreteState(this.mavenProject, builderConfig, false);
            }
            catch (ProjectBuildingException pbe) {
                throw new BuildException("Unable to initialize POM " + this.file.getName() + ": " + pbe.getMessage(), (Throwable)pbe);
            }
            catch (ModelInterpolationException mie) {
                throw new BuildException("Unable to interpolate POM " + this.file.getName() + ": " + mie.getMessage(), (Throwable)mie);
            }
        } else if (this.refid != null) {
            this.getPomFromAntProject(this.refid);
        }
    }

    protected MavenProject getMavenProject() {
        if (this.mavenProject == null) {
            this.mavenProject = this.createMinimalProject(this.createLocalArtifactRepository());
        }
        return this.mavenProject;
    }

    public String getArtifactId() {
        return this.getMavenProject().getArtifactId();
    }

    public Build getBuild() {
        return this.getMavenProject().getBuild();
    }

    public CiManagement getCiManagement() {
        return this.getMavenProject().getCiManagement();
    }

    public List getContributors() {
        return this.getMavenProject().getContributors();
    }

    public List<Dependency> getDependencies() {
        return this.getMavenProject().getDependencies();
    }

    public DependencyManagement getDependencyManagement() {
        return this.getMavenProject().getDependencyManagement();
    }

    public String getDescription() {
        return this.getMavenProject().getDescription();
    }

    public List getDevelopers() {
        return this.getMavenProject().getDevelopers();
    }

    public DistributionManagement getDistributionManagement() {
        return this.getMavenProject().getDistributionManagement();
    }

    public String getGroupId() {
        return this.getMavenProject().getGroupId();
    }

    public String getInceptionYear() {
        return this.getMavenProject().getInceptionYear();
    }

    public IssueManagement getIssueManagement() {
        return this.getMavenProject().getIssueManagement();
    }

    public List getLicenses() {
        return this.getMavenProject().getLicenses();
    }

    public List getMailingLists() {
        return this.getMavenProject().getMailingLists();
    }

    public String getModelVersion() {
        return this.getMavenProject().getModelVersion();
    }

    public List getModules() {
        return this.getMavenProject().getModules();
    }

    public String getName() {
        return this.getMavenProject().getName();
    }

    public Organization getOrganization() {
        return this.getMavenProject().getOrganization();
    }

    public String getPackaging() {
        return this.getMavenProject().getPackaging();
    }

    public List getPluginRepositories() {
        return this.getMavenProject().getPluginRepositories();
    }

    public Reporting getReporting() {
        return this.getMavenProject().getReporting();
    }

    public List<Repository> getRepositories() {
        return this.getMavenProject().getRepositories();
    }

    public Scm getScm() {
        return this.getMavenProject().getScm();
    }

    public String getUrl() {
        return this.getMavenProject().getUrl();
    }

    public String getVersion() {
        return this.getMavenProject().getVersion();
    }

    public String getId() {
        return this.getMavenProject().getId();
    }

    @Override
    protected void doExecute() {
        if (this.getId() == null) {
            throw new BuildException("id required for pom task");
        }
        ArtifactRepository localRepo = this.createLocalArtifactRepository();
        MavenProjectBuilder projectBuilder = (MavenProjectBuilder)this.lookup(MavenProjectBuilder.ROLE);
        this.initialiseMavenProject(projectBuilder, localRepo);
        Project antProject = this.getProject();
        antProject.addReference(this.antId, (Object)this);
        PropertyHelper phelper = PropertyHelper.getPropertyHelper((Project)antProject);
        try {
            POMPropertyEvaluator.register(this, phelper);
        }
        catch (LinkageError e) {
            this.helper.setNext(phelper.getNext());
            this.helper.setProject(antProject);
            phelper.setNext((PropertyHelper)this.helper);
        }
    }

    private void addAntRepositoriesToProfileManager() {
        List<RemoteRepository> remoteRepositories = this.getRemoteRepositories();
        if (remoteRepositories == null || remoteRepositories.isEmpty()) {
            return;
        }
        org.apache.maven.model.Profile repositoriesProfile = new org.apache.maven.model.Profile();
        repositoriesProfile.setId("maven-ant-tasks-repo-profile");
        for (RemoteRepository antRepo : remoteRepositories) {
            Repository mavenRepo = new Repository();
            mavenRepo.setId(antRepo.getId());
            mavenRepo.setUrl(antRepo.getUrl());
            repositoriesProfile.addRepository(mavenRepo);
        }
        this.getProfileManager().addProfile(repositoriesProfile);
        this.getProfileManager().explicitlyActivate(repositoriesProfile.getId());
    }

    private ProfileManager getActivatedProfiles() {
        ProfileManager profileManager = this.getProfileManager();
        for (Profile profile : this.getProfiles()) {
            if (profile.getId() == null) {
                throw new BuildException("Attribute \"id\" is required for profile in pom type.");
            }
            if (profile.getActive() == null || Boolean.valueOf(profile.getActive()).booleanValue()) {
                profileManager.explicitlyActivate(profile.getId());
                continue;
            }
            profileManager.explicitlyDeactivate(profile.getId());
        }
        return profileManager;
    }

    private ProjectBuilderConfiguration createProjectBuilderConfig(ArtifactRepository localArtifactRepository) {
        DefaultProjectBuilderConfiguration builderConfig = new DefaultProjectBuilderConfiguration();
        builderConfig.setLocalRepository(localArtifactRepository);
        builderConfig.setGlobalProfileManager(this.getActivatedProfiles());
        builderConfig.setUserProperties(this.getAntProjectProperties());
        builderConfig.setExecutionProperties(this.getAntProjectProperties());
        return builderConfig;
    }

    public Properties getAntProjectProperties() {
        Properties properties = new Properties();
        Hashtable propsTable = null;
        propsTable = this.isInheritAllProperties() ? this.getProject().getProperties() : this.getProject().getUserProperties();
        for (String key : propsTable.keySet()) {
            String value = (String)propsTable.get(key);
            properties.setProperty(key, value);
        }
        return properties;
    }

    public void setInheritAllProperties(boolean inheritAllProperties) {
        this.inheritAllProperties = inheritAllProperties;
    }

    public boolean isInheritAllProperties() {
        return this.inheritAllProperties;
    }

    public Model getModel() {
        return this.getMavenProject().getModel();
    }

    public void setGroupId(String groupId) {
        this.getMavenProject().setGroupId(groupId);
    }

    public void setArtifactId(String artifactId) {
        this.getMavenProject().setArtifactId(artifactId);
    }

    public void setVersion(String version) {
        this.getMavenProject().setVersion(version);
    }

    public void addConfiguredCiManagement(CiManagement ciManagement) {
        this.getMavenProject().setCiManagement(ciManagement);
    }

    public void addConfiguredContributor(Contributor contributor) {
        this.getMavenProject().addContributor(contributor);
    }

    public void addConfiguredDependency(Dependency dependency) {
        this.getMavenProject().getDependencies().add(dependency);
    }

    public void addConfiguredDependencyManagement(DependencyManagement dependencyManagement) {
        this.getMavenProject().getDependencyManagement().setDependencies(dependencyManagement.getDependencies());
    }

    public void setDescription(String description) {
        this.getMavenProject().setDescription(description);
    }

    public void addConfiguredDeveloper(Developer developer) {
        this.getMavenProject().addDeveloper(developer);
    }

    public void setInceptionYear(String inceptionYear) {
        this.getMavenProject().setInceptionYear(inceptionYear);
    }

    public void addConfiguredIssueManagement(IssueManagement issueManagement) {
        this.getMavenProject().setIssueManagement(issueManagement);
    }

    public void addConfiguredLicense(License license) {
        this.getMavenProject().addLicense(license);
    }

    public void addConfiguredMailingLists(MailingList mailingList) {
        this.getMavenProject().addMailingList(mailingList);
    }

    public void setName(String name) {
        this.getMavenProject().setName(name);
    }

    public void addConfiguredOrganization(Organization organization) {
        this.getMavenProject().setOrganization(organization);
    }

    public void setPackaging(String packaging) {
        this.getMavenProject().setPackaging(packaging);
    }

    public void addConfiguredScm(Scm scm) {
        this.getMavenProject().setScm(scm);
    }

    public void setUrl(String url) {
        this.getMavenProject().setUrl(url);
    }
}

