/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.ant.AbstractArtifactTask;
import org.apache.maven.artifact.ant.RemoteRepository;
import org.apache.maven.artifact.ant.RepositoryPolicy;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Repository;
import org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractArtifactWithRepositoryTask
extends AbstractArtifactTask {
    private List<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
    public final String MD5_ALGO_NAME = "MD5";
    public final String UTF_ENC_NAME = "UTF-8";

    private static RemoteRepository getDefaultRemoteRepository() {
        RemoteRepository remoteRepository = new RemoteRepository();
        remoteRepository.setId("central");
        remoteRepository.setUrl("http://repo1.maven.org/maven2");
        RepositoryPolicy snapshots = new RepositoryPolicy();
        snapshots.setEnabled(false);
        remoteRepository.addSnapshots(snapshots);
        return remoteRepository;
    }

    private static String statusAsString(RepositoryPolicy policy) {
        return policy == null || policy.isEnabled() ? "enabled" : "disabled";
    }

    protected List<ArtifactRepository> createRemoteArtifactRepositories() {
        return this.createRemoteArtifactRepositories(null);
    }

    protected List<ArtifactRepository> createRemoteArtifactRepositories(List<Repository> pomRepositories) {
        ArrayList<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
        remoteRepositories.addAll(this.getRemoteRepositories());
        if (this.getRemoteRepositories().isEmpty()) {
            remoteRepositories.add(AbstractArtifactWithRepositoryTask.getDefaultRemoteRepository());
        }
        if (pomRepositories != null) {
            for (Repository pomRepository : pomRepositories) {
                remoteRepositories.add(this.createAntRemoteRepository(pomRepository));
            }
        }
        this.log("Using remote repositories:", 3);
        ArrayList<ArtifactRepository> list = new ArrayList<ArtifactRepository>();
        HashSet<String> ids = new HashSet<String>();
        for (RemoteRepository remoteRepository : remoteRepositories) {
            if (!ids.add(remoteRepository.getId())) continue;
            this.updateRepositoryWithSettings(remoteRepository);
            StringBuffer msg = new StringBuffer();
            msg.append("  - id=" + remoteRepository.getId());
            msg.append(", url=" + remoteRepository.getUrl());
            msg.append(", releases=" + AbstractArtifactWithRepositoryTask.statusAsString(remoteRepository.getReleases()));
            msg.append(", snapshots=" + AbstractArtifactWithRepositoryTask.statusAsString(remoteRepository.getSnapshots()));
            if (remoteRepository.getAuthentication() != null) {
                msg.append(", authentication=" + remoteRepository.getAuthentication().getUserName());
            }
            if (remoteRepository.getProxy() != null) {
                msg.append(", proxy=" + remoteRepository.getProxy().getHost());
            }
            this.getProject().log(msg.toString(), 3);
            list.add(this.createRemoteArtifactRepository(remoteRepository));
        }
        return list;
    }

    public List<RemoteRepository> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public void addConfiguredRemoteRepository(RemoteRepository remoteRepository) {
        if (remoteRepository.getRefid() != null) {
            String refid = remoteRepository.getRefid();
            if (this.getProject().getReference(refid) == null) {
                throw new BuildException("Unknown remote repository refid='" + refid + "'.");
            }
        }
        if (remoteRepository.getUrl() == null) {
            throw new BuildException("Each remote repository must specify a url.");
        }
        if (remoteRepository.getId() == null || remoteRepository.getId().equals(remoteRepository.getUrl())) {
            this.log("Each remote repository must specify a unique id. For backward-compatibility, a default id will be used. In future releases, a missing repository id will raise an error.", 1);
            remoteRepository.setId(this.generateDefaultRepositoryId(remoteRepository));
        }
        this.remoteRepositories.add(remoteRepository);
    }

    public String generateDefaultRepositoryId(RemoteRepository repository) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(repository.getUrl().getBytes("UTF-8"));
            BigInteger digest = new BigInteger(md.digest());
            return digest.toString(16);
        }
        catch (Exception e) {
            this.log("Unable to generate unique repository Id: " + e, 1);
            return "default";
        }
    }
}

