/**
 * Copyright 2005-2013 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.rice.kew.impl;

import org.kuali.rice.kim.api.KimApiConstants;

/**
 * Stores constants values and inner classes with constants values which are used by the KEW implementation.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public final class KewImplConstants {

    public static final String KEW_DISTRIBUTED_CACHE_MANAGER = "kewDistributedCacheManager";

    public static final class PropertyConstants {

        public static final String NAMESPACE_CODE = "namespaceCode";
        public static final String NAME = "name";

    }

}
