/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.xml.export;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.impex.ExportDataSet;
import org.kuali.rice.edl.impl.bo.EDocLiteAssociation;
import org.kuali.rice.edl.impl.xml.export.EdlExportDataSet;
import org.kuali.rice.krad.bo.Exporter;
import org.kuali.rice.krad.exception.ExportNotSupportedException;

public class EdlDataExporter
implements Exporter {
    private List<String> supportedFormats = new ArrayList<String>();

    public EdlDataExporter() {
        this.supportedFormats.add("xml");
    }

    public List<String> getSupportedFormats(Class<?> dataObjectClass) {
        return this.supportedFormats;
    }

    protected ExportDataSet buildExportDataSet(Class<?> dataObjectClass, List<? extends Object> dataObjects) {
        EdlExportDataSet dataSet = new EdlExportDataSet();
        for (Object object : dataObjects) {
            if (!dataObjectClass.equals(EDocLiteAssociation.class)) continue;
            dataSet.getEdocLites().add((EDocLiteAssociation)object);
        }
        return dataSet.createExportDataSet();
    }

    public void export(Class<?> dataObjectClass, List<? extends Object> dataObjects, String exportFormat, OutputStream outputStream) throws IOException, ExportNotSupportedException {
        if (!"xml".equals(exportFormat)) {
            throw new ExportNotSupportedException("The given export format of " + exportFormat + " is not supported by the EDocLite XML Exporter!");
        }
        ExportDataSet dataSet = this.buildExportDataSet(dataObjectClass, dataObjects);
        outputStream.write(CoreApiServiceLocator.getXmlExporterService().export(dataSet));
        outputStream.flush();
    }
}

