/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.components;

import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.kuali.rice.core.api.uif.RemotableAttributeErrorContract;
import org.kuali.rice.edl.impl.EDLContext;
import org.kuali.rice.edl.impl.EDLModelComponent;
import org.kuali.rice.edl.impl.RequestParser;
import org.kuali.rice.edl.impl.components.SimpleWorkflowEDLConfigComponent;
import org.kuali.rice.edl.impl.service.EdlServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.document.PropertyDefinition;
import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GlobalAttributeComponent
extends SimpleWorkflowEDLConfigComponent
implements EDLModelComponent {
    @Override
    public void updateDOM(Document dom, Element configElement, EDLContext edlContext) {
        if (!edlContext.getUserAction().isLoadAction()) {
            RequestParser requestParser = edlContext.getRequestParser();
            try {
                WorkflowDocument document = (WorkflowDocument)requestParser.getAttribute("workflowDocument");
                document.clearAttributeContent();
                Document edlDef = EdlServiceLocator.getEDocLiteService().getDefinitionXml(edlContext.getEdocLiteAssociation());
                XPath xpath = XPathHelper.newXPath((Node)edlDef);
                NodeList attributeNodes = (NodeList)xpath.evaluate("/edl/attributes/attribute", edlDef, XPathConstants.NODESET);
                for (int index = 0; index < attributeNodes.getLength(); ++index) {
                    Element attributeElem = (Element)attributeNodes.item(index);
                    String attributeName = attributeElem.getAttribute("name");
                    WorkflowAttributeDefinition.Builder attributeDefBuilder = this.getWorkflowAttributeDefinitionVO(attributeName, document);
                    NodeList fieldNodes = (NodeList)xpath.evaluate("./field", attributeElem, XPathConstants.NODESET);
                    for (int fIndex = 0; fIndex < fieldNodes.getLength(); ++fIndex) {
                        Element fieldElem = (Element)fieldNodes.item(fIndex);
                        String edlField = fieldElem.getAttribute("edlField");
                        String attributeField = fieldElem.getAttribute("attributeField");
                        PropertyDefinition property = attributeDefBuilder.getPropertyDefinition(attributeField);
                        String value = requestParser.getParameterValue(edlField);
                        if (property == null) {
                            property = PropertyDefinition.create((String)attributeField, (String)value);
                        } else {
                            attributeDefBuilder.getPropertyDefinitions().remove(property);
                            property = PropertyDefinition.create((String)property.getName(), (String)value);
                        }
                        attributeDefBuilder.addPropertyDefinition(property);
                    }
                    boolean curAttrValid = true;
                    if (edlContext.getUserAction().isValidatableAction()) {
                        List errors = document.validateAttributeDefinition(attributeDefBuilder.build());
                        if (!errors.isEmpty()) {
                            edlContext.setInError(true);
                            curAttrValid = false;
                        }
                        Map fieldErrors = (Map)edlContext.getRequestParser().getAttribute("org.kuali.rice.edl.impl.GlobalFieldErrors");
                        for (RemotableAttributeErrorContract error : errors) {
                            fieldErrors.put(error.getAttributeName(), error.getMessage());
                        }
                    }
                    if (!curAttrValid || !edlContext.getUserAction().isValidatableAction()) continue;
                    for (int fIndex = 0; fIndex < fieldNodes.getLength(); ++fIndex) {
                        Element fieldElem = (Element)fieldNodes.item(fIndex);
                        String edlField = fieldElem.getAttribute("edlField");
                        String attributeField = fieldElem.getAttribute("attributeField");
                        PropertyDefinition property = attributeDefBuilder.getPropertyDefinition(attributeField);
                        String value = requestParser.getParameterValue(edlField);
                        if (property == null) {
                            property = PropertyDefinition.create((String)attributeField, (String)value);
                        } else {
                            attributeDefBuilder.getPropertyDefinitions().remove(property);
                            property = PropertyDefinition.create((String)property.getName(), (String)value);
                        }
                        attributeDefBuilder.addPropertyDefinition(property);
                    }
                    WorkflowAttributeDefinition attributeDef = attributeDefBuilder.build();
                    document.addAttributeDefinition(attributeDef);
                }
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new WorkflowRuntimeException("Failed to process attribute.", (Throwable)e);
            }
        }
    }

    private WorkflowAttributeDefinition.Builder getWorkflowAttributeDefinitionVO(String attributeName, WorkflowDocument document) {
        for (WorkflowAttributeDefinition attributeDefinition : document.getAttributeDefinitions()) {
            if (!attributeDefinition.getAttributeName().equals(attributeName)) continue;
            return WorkflowAttributeDefinition.Builder.create((WorkflowAttributeDefinition)attributeDefinition);
        }
        return WorkflowAttributeDefinition.Builder.create((String)attributeName);
    }
}

