/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.extract.dao.impl;

import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.edl.impl.extract.Dump;
import org.kuali.rice.edl.impl.extract.Fields;
import org.kuali.rice.edl.impl.extract.dao.ExtractDAO;
import org.kuali.rice.kew.notes.Note;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;

public class ExtractDAOJpaImpl
implements ExtractDAO {
    private static final Logger LOG = Logger.getLogger(ExtractDAOJpaImpl.class);
    private DataObjectService dataObjectService;

    @Override
    public Dump getDumpByDocumentId(String docId) {
        LOG.debug((Object)("finding Document Extract by documentId " + docId));
        return (Dump)this.dataObjectService.find(Dump.class, (Object)docId);
    }

    @Override
    public List<Fields> getFieldsByDocumentId(String docId) {
        LOG.debug((Object)("finding Extract Fileds by documentId " + docId));
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"documentId", (Object)docId)}).setOrderByAscending(new String[]{"docId"});
        return this.dataObjectService.findMatching(Fields.class, criteria.build()).getResults();
    }

    @Override
    public Dump saveDump(Dump dump) {
        LOG.debug((Object)"check for null values in Extract document");
        this.checkNull(dump.getDocId(), "Document ID");
        this.checkNull(dump.getDocCreationDate(), "Creation Date");
        this.checkNull(dump.getDocCurrentNodeName(), "Current Node Name");
        this.checkNull(dump.getDocModificationDate(), "Modification Date");
        this.checkNull(dump.getDocRouteStatusCode(), "Route Status Code");
        this.checkNull(dump.getDocInitiatorId(), "Initiator ID");
        this.checkNull(dump.getDocTypeName(), "Doc Type Name");
        LOG.debug((Object)("saving EDocLite document: routeHeader " + dump.getDocId()));
        return (Dump)this.dataObjectService.save((Object)dump, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    @Override
    public Fields saveField(Fields field) {
        LOG.debug((Object)"saving EDocLite Extract fields");
        this.checkNull(field.getDocId(), "Document ID");
        this.checkNull(field.getFieldValue(), "Field Value");
        this.checkNull(field.getFieldName(), "Field Name");
        LOG.debug((Object)("saving Fields: routeHeader " + field.getFieldId()));
        return (Fields)this.dataObjectService.save((Object)field, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    private void checkNull(Object value, String valueName) throws RuntimeException {
        if (value == null) {
            throw new RuntimeException("Null value for " + valueName);
        }
    }

    @Override
    public void deleteDump(String documentId) {
        LOG.debug((Object)"deleting record form Extract Dump table");
        this.dataObjectService.delete(this.dataObjectService.find(Note.class, (Object)documentId));
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

