/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.edl.impl.components;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.edl.impl.EDLContext;
import org.kuali.rice.edl.impl.EDLModelComponent;
import org.kuali.rice.edl.impl.EDLXmlUtils;
import org.kuali.rice.edl.impl.RequestParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BrowserHandler
implements EDLModelComponent {
    private static final Log LOG = LogFactory.getLog(BrowserHandler.class);
    public static final String BROWSER_EL = "requestBrowser";

    @Override
    public void updateDOM(Document dom, Element configElement, EDLContext edlContext) {
        String userAgent = this.browserString(edlContext.getRequestParser());
        this.setBrowser(dom, this.uaConvert(userAgent));
    }

    private String browserString(RequestParser requestParser) {
        return requestParser.getRequest().getHeader("User-Agent");
    }

    private void setBrowser(Document dom, String bStr) {
        if (!StringUtils.isBlank((String)bStr)) {
            Element currentPageElement = EDLXmlUtils.getOrCreateChildElement(dom.getDocumentElement(), BROWSER_EL, true);
            currentPageElement.appendChild(dom.createTextNode(bStr));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Appended" + bStr + " to XML field " + currentPageElement.getNodeName()));
            }
        }
    }

    private String uaConvert(String userAgent) {
        String res = userAgent;
        int ie = userAgent.indexOf("MSIE");
        int ff = userAgent.indexOf("Firefox/");
        int saf = userAgent.indexOf("Safari/");
        int chr = userAgent.indexOf("Chrome/");
        res = ie > 0 ? "InternetExplorer" : (ff > 0 ? "Firefox" : (saf > 0 && chr < 0 ? "Safari" : (saf > 0 && chr > 0 ? "Chrome" : "Other")));
        return res;
    }
}

