/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.util;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.kuali.rice.ken.util.ClassLoaderResourceResolver;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class ClassLoaderLSResourceResolver
extends ClassLoaderResourceResolver
implements LSResourceResolver {
    public ClassLoaderLSResourceResolver(String base, String prefix) {
        super(base, prefix);
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        if (!type.equals("http://www.w3.org/2001/XMLSchema")) {
            return null;
        }
        this.LOG.error((Object)type);
        this.LOG.error((Object)namespaceURI);
        this.LOG.error((Object)publicId);
        this.LOG.error((Object)systemId);
        this.LOG.error((Object)baseURI);
        String path = this.resolveSystemId(systemId);
        if (path == null) {
            return null;
        }
        this.LOG.debug((Object)("Looking up resource '" + path + "' for system id '" + systemId + "'"));
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(path);
        if (is == null) {
            String message = "Unable to find schema (" + path + ") for: " + systemId;
            this.LOG.error((Object)message);
            throw new RuntimeException(message);
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation domImpl = builder.getDOMImplementation();
            DOMImplementationLS dils = (DOMImplementationLS)((Object)domImpl);
            LSInput input = dils.createLSInput();
            input.setByteStream(is);
            return input;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

