/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionitem;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.actionlist.DisplayParameters;
import org.kuali.rice.kew.api.preferences.Preferences;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValueActionListExtension;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.web.RowStyleable;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.principal.EntityNamePrincipalName;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

@MappedSuperclass
public class ActionItemActionListExtension
extends ActionItem
implements RowStyleable {
    private static final long serialVersionUID = -8801104028828059623L;
    @Transient
    private Timestamp lastApprovedDate;
    @Transient
    private Map<String, String> customActions = new HashMap<String, String>();
    @Transient
    private String rowStyleClass;
    @Transient
    private Integer actionListIndex;
    @Transient
    private String delegatorName = "";
    @Transient
    private String groupName = "";
    @Transient
    private DisplayParameters displayParameters;
    @Transient
    private boolean isInitialized = false;
    @Transient
    private DocumentRouteHeaderValueActionListExtension routeHeader;
    @Transient
    private boolean lastApprovedDateInitialized = false;
    @Transient
    private boolean delegatorNameInitialized = false;
    @Transient
    private boolean groupNameInitialized = false;

    public Integer getActionListIndex() {
        return this.actionListIndex;
    }

    public void setActionListIndex(Integer actionListIndex) {
        this.actionListIndex = actionListIndex;
    }

    public Timestamp getLastApprovedDate() {
        this.initializeLastApprovedDate();
        return this.lastApprovedDate;
    }

    public Map<String, String> getCustomActions() {
        return this.customActions;
    }

    public void setCustomActions(Map<String, String> customActions) {
        this.customActions = customActions;
    }

    @Override
    public String getRowStyleClass() {
        return this.rowStyleClass;
    }

    @Override
    public void setRowStyleClass(String rowStyleClass) {
        this.rowStyleClass = rowStyleClass;
    }

    public String getDelegatorName() {
        this.initializeDelegatorName();
        return this.delegatorName;
    }

    public String getGroupName() {
        this.initializeGroupName();
        return this.groupName;
    }

    public void initialize(Preferences preferences) {
        this.initializeRowStyleClass(preferences);
        if (this.isInitialized) {
            return;
        }
        if ("yes".equals(preferences.getShowWorkgroupRequest())) {
            this.initializeGroupName();
        }
        if ("yes".equals(preferences.getShowDelegator())) {
            this.initializeDelegatorName();
        }
        if ("yes".equals(preferences.getShowDateApproved())) {
            this.initializeLastApprovedDate();
        }
        this.routeHeader.initialize(preferences);
        this.isInitialized = true;
    }

    private void initializeRowStyleClass(Preferences preferences) {
        if ("X".equalsIgnoreCase(this.routeHeader.getDocRouteStatus())) {
            this.setRowStyleClass((String)KewApiConstants.ACTION_LIST_COLOR_PALETTE.get(preferences.getColorCanceled()));
        } else if ("D".equalsIgnoreCase(this.routeHeader.getDocRouteStatus())) {
            this.setRowStyleClass((String)KewApiConstants.ACTION_LIST_COLOR_PALETTE.get(preferences.getColorDisapproved()));
        } else if ("R".equalsIgnoreCase(this.routeHeader.getDocRouteStatus())) {
            this.setRowStyleClass((String)KewApiConstants.ACTION_LIST_COLOR_PALETTE.get(preferences.getColorEnroute()));
        } else if ("E".equalsIgnoreCase(this.routeHeader.getDocRouteStatus())) {
            this.setRowStyleClass((String)KewApiConstants.ACTION_LIST_COLOR_PALETTE.get(preferences.getColorException()));
        } else if ("F".equalsIgnoreCase(this.routeHeader.getDocRouteStatus())) {
            this.setRowStyleClass((String)KewApiConstants.ACTION_LIST_COLOR_PALETTE.get(preferences.getColorFinal()));
        } else if ("I".equalsIgnoreCase(this.routeHeader.getDocRouteStatus())) {
            this.setRowStyleClass((String)KewApiConstants.ACTION_LIST_COLOR_PALETTE.get(preferences.getColorInitiated()));
        } else if ("P".equalsIgnoreCase(this.routeHeader.getDocRouteStatus())) {
            this.setRowStyleClass((String)KewApiConstants.ACTION_LIST_COLOR_PALETTE.get(preferences.getColorProcessed()));
        } else if ("S".equalsIgnoreCase(this.routeHeader.getDocRouteStatus())) {
            this.setRowStyleClass((String)KewApiConstants.ACTION_LIST_COLOR_PALETTE.get(preferences.getColorSaved()));
        }
    }

    private void initializeGroupName() {
        if (!this.groupNameInitialized) {
            if (this.getGroupId() != null) {
                Group group = super.getGroup();
                this.groupName = group.getName();
            }
            this.groupNameInitialized = true;
        }
    }

    private void initializeDelegatorName() {
        if (!this.delegatorNameInitialized) {
            Group delegatorGroup;
            EntityNamePrincipalName name;
            if (this.getDelegatorPrincipalId() != null && (name = KimApiServiceLocator.getIdentityService().getDefaultNamesForPrincipalId(this.getDelegatorPrincipalId())) != null) {
                this.delegatorName = name.getDefaultName().getCompositeName();
            }
            if (this.getDelegatorGroupId() != null && (delegatorGroup = KimApiServiceLocator.getGroupService().getGroup(this.getDelegatorGroupId())) != null) {
                this.delegatorName = delegatorGroup.getName();
            }
            this.delegatorNameInitialized = true;
        }
    }

    private void initializeLastApprovedDate() {
        if (!this.lastApprovedDateInitialized) {
            this.lastApprovedDate = KEWServiceLocator.getActionTakenService().getLastApprovedDate(this.getDocumentId());
            this.lastApprovedDateInitialized = true;
        }
    }

    public DisplayParameters getDisplayParameters() {
        return this.displayParameters;
    }

    public void setDisplayParameters(DisplayParameters displayParameters) {
        this.displayParameters = displayParameters;
    }

    public DocumentRouteHeaderValueActionListExtension getRouteHeader() {
        return this.routeHeader;
    }

    public void setRouteHeader(DocumentRouteHeaderValueActionListExtension routeHeader) {
        this.routeHeader = routeHeader;
    }
}

