/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionlist.web;

import org.apache.log4j.Logger;
import org.displaytag.decorator.TableDecorator;
import org.kuali.rice.kew.actionitem.ActionItemActionListExtension;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.actionlist.DisplayParameters;

public class ActionListDecorator
extends TableDecorator {
    private static final Logger LOG = Logger.getLogger(ActionListDecorator.class);
    private int rowCounter = 0;

    public String startRow() {
        return "";
    }

    public String finishRow() {
        String returnRow;
        block5: {
            ActionItemActionListExtension actionItem = (ActionItemActionListExtension)this.getCurrentRowObject();
            returnRow = "";
            try {
                DisplayParameters displayParameters = actionItem.getDisplayParameters();
                if (displayParameters == null) break block5;
                Integer index = actionItem.getActionListIndex();
                Integer frameHeight = new Integer(290);
                try {
                    if (displayParameters.getFrameHeight() != null && displayParameters.getFrameHeight() > 0) {
                        frameHeight = displayParameters.getFrameHeight();
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error getting custom action list frame height.", (Throwable)ex);
                }
                StringBuffer newRow = new StringBuffer();
                newRow.append("<tr id='G");
                newRow.append(index.toString());
                newRow.append("' style='display: none;'>");
                newRow.append("<td class='white' height='0' colspan='11' >");
                newRow.append("<iframe name='iframeAL_");
                newRow.append(index.toString());
                newRow.append("' scrolling='yes' width=100% height=");
                newRow.append(frameHeight.toString());
                newRow.append(" hspace=0 vspace=0 frameborder=0></iframe>");
                newRow.append("</td></tr>");
                returnRow = returnRow + newRow.toString();
            }
            catch (Exception e) {
                LOG.error((Object)"Error with custom action list attribute.", (Throwable)e);
            }
        }
        return returnRow;
    }

    public String addRowClass() {
        ActionItemActionListExtension actionItem = (ActionItemActionListExtension)this.getCurrentRowObject();
        return "actionlist_" + (String)KewApiConstants.ACTION_LIST_COLOR_NAMES.get(actionItem.getRowStyleClass());
    }

    public String addRowId() {
        return "actionlist_tr_" + this.rowCounter++;
    }

    public void finish() {
        super.finish();
        this.rowCounter = 0;
    }
}

