/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.doctype.dao.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.core.framework.persistence.jpa.criteria.Criteria;
import org.kuali.rice.core.framework.persistence.jpa.criteria.QueryByCriteria;
import org.kuali.rice.kew.doctype.DocumentTypeAttributeBo;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.dao.DocumentTypeDAO;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.rule.bo.RuleAttribute;

public class DocumentTypeDAOJpaImpl
implements DocumentTypeDAO {
    public static final Logger LOG = Logger.getLogger(DocumentTypeDAOJpaImpl.class);
    @PersistenceContext(unitName="kew-unit")
    private EntityManager entityManager;

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void delete(DocumentType documentType) {
        DocumentType docType = this.findById(documentType.getDocumentTypeId());
        this.entityManager.remove((Object)documentType);
    }

    @Override
    public DocumentType findById(String docTypeId) {
        Criteria crit = new Criteria(DocumentType.class.getName());
        crit.eq("documentTypeId", (Object)docTypeId);
        return (DocumentType)new QueryByCriteria(this.entityManager, crit).toQuery().getSingleResult();
    }

    @Override
    public DocumentType findByName(String name) {
        return this.findByName(name, true);
    }

    @Override
    public DocumentType findByName(String name, boolean caseSensitive) {
        Criteria crit = new Criteria(DocumentType.class.getName());
        if (!caseSensitive) {
            crit.like("UPPER(__JPA_ALIAS[[0]]__.name)", (Object)("%" + name.trim() + "%").toUpperCase());
        } else {
            crit.eq("name", (Object)name);
        }
        crit.eq("currentInd", (Object)Boolean.TRUE);
        DocumentType docType = (DocumentType)new QueryByCriteria(this.entityManager, crit).toQuery().getSingleResult();
        return docType;
    }

    @Override
    public Integer getMaxVersionNumber(String docTypeName) {
        return this.getMostRecentDocType(docTypeName).getVersion();
    }

    @Override
    public List<String> getChildDocumentTypeIds(String parentDocumentTypeId) {
        ArrayList<String> childrenIds = new ArrayList<String>();
        try {
            String sql = "select DOC_TYP_ID from KREW_DOC_TYP_T where CUR_IND = 1 and PARNT_ID = " + parentDocumentTypeId;
            Query query = this.entityManager.createNativeQuery(sql);
            List resultIds = query.getResultList();
            for (Object id : resultIds) {
                childrenIds.add(id.toString());
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error occured fetching children document type ids for document type " + parentDocumentTypeId), (Throwable)e);
            throw new RuntimeException(e);
        }
        return childrenIds;
    }

    protected DocumentType getMostRecentDocType(String docTypeName) {
        Criteria crit = new Criteria(DocumentType.class.getName());
        crit.eq("name", (Object)docTypeName);
        crit.orderBy("version", false);
        Iterator docTypes = new QueryByCriteria(this.entityManager, crit).toQuery().getResultList().iterator();
        if (docTypes.hasNext()) {
            return (DocumentType)docTypes.next();
        }
        return null;
    }

    @Override
    public void save(DocumentType documentType) {
        if (documentType.getDocumentTypeId() == null) {
            this.entityManager.persist((Object)documentType);
        } else {
            OrmUtils.merge((EntityManager)this.entityManager, (Object)documentType);
        }
    }

    @Override
    public List findByDocumentId(String documentId) {
        Criteria crit = new Criteria(DocumentType.class.getName());
        crit.eq("documentId", (Object)documentId);
        return new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
    }

    @Override
    public Collection<DocumentType> find(DocumentType documentType, DocumentType docTypeParent, boolean climbHierarchy) {
        DocumentType searchDocumentType;
        LOG.debug((Object)("documentType: " + documentType));
        LOG.debug((Object)("docTypeParent: " + docTypeParent));
        LOG.debug((Object)("climbHierarchy: " + climbHierarchy));
        Criteria crit = new Criteria(DocumentType.class.getName());
        if (documentType != null && !StringUtils.isEmpty((String)documentType.getLabel())) {
            crit.like("UPPER(__JPA_ALIAS[[0]]__.label)", (Object)documentType.getLabel().trim().toUpperCase());
        }
        if (documentType != null && !StringUtils.isEmpty((String)documentType.getName())) {
            String docTypeName = documentType.getName();
            crit.like("UPPER(__JPA_ALIAS[[0]]__.name)", (Object)("%" + docTypeName.trim() + "%").toUpperCase());
        }
        if (documentType != null && documentType.getActive() != null) {
            crit.eq("active", (Object)documentType.getActive());
        }
        if (documentType != null && documentType.getDocumentTypeId() != null) {
            crit.eq("documentTypeId", (Object)documentType.getDocumentTypeId());
        }
        if (documentType != null && documentType.getActualApplicationId() != null) {
            crit.eq("applicationId", (Object)documentType.getActualApplicationId());
        }
        if (docTypeParent != null) {
            if (!"".equals(docTypeParent.getName()) && docTypeParent.getName() != null) {
                Criteria parentCrit = new Criteria(DocumentType.class.getName());
                this.addParentIdOrCriteria(docTypeParent.getDocumentTypeId(), parentCrit);
                if (climbHierarchy) {
                    this.assembleChildrenCriteria(docTypeParent.getChildrenDocTypes(), parentCrit);
                }
                parentCrit.eq("currentInd", (Object)Boolean.TRUE);
                crit.and(parentCrit);
            }
        } else if (documentType != null && !StringUtils.isEmpty((String)documentType.getName()) && (searchDocumentType = this.findByName(documentType.getName())) != null && climbHierarchy) {
            LOG.debug((Object)("searchDocumentType: " + searchDocumentType));
            Criteria criteria = new Criteria(DocumentType.class.getName());
            this.addParentIdOrCriteria(searchDocumentType.getDocumentTypeId(), criteria);
            this.assembleChildrenCriteria(searchDocumentType.getChildrenDocTypes(), criteria);
            criteria.eq("currentInd", (Object)Boolean.TRUE);
            crit.or(criteria);
        }
        crit.eq("currentInd", (Object)Boolean.TRUE);
        return new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
    }

    private void addParentIdOrCriteria(String parentId, Criteria mainCriteria) {
        Criteria parentCriteria = new Criteria(DocumentType.class.getName());
        parentCriteria.eq("docTypeParentId", (Object)parentId);
        mainCriteria.or(parentCriteria);
    }

    private void assembleChildrenCriteria(Collection childrenDocTypes, Criteria crit) {
        if (childrenDocTypes != null) {
            for (DocumentType child : childrenDocTypes) {
                this.addParentIdOrCriteria(child.getDocumentTypeId(), crit);
                this.assembleChildrenCriteria(child.getChildrenDocTypes(), crit);
            }
        }
    }

    @Override
    public List findAllCurrentRootDocuments() {
        Criteria crit = new Criteria(DocumentType.class.getName());
        crit.isNull("docTypeParentId");
        return this.findAllCurrent(crit);
    }

    @Override
    public List findAllCurrent() {
        return this.findAllCurrent(new Criteria(DocumentType.class.getName()));
    }

    @Override
    public List findAllCurrentByName(String name) {
        Criteria crit = new Criteria(DocumentType.class.getName());
        crit.eq("name", (Object)name);
        return this.findAllCurrent(crit);
    }

    @Override
    public List<DocumentType> findPreviousInstances(String name) {
        Criteria crit = new Criteria(DocumentType.class.getName());
        crit.eq("name", (Object)name);
        crit.eq("currentInd", (Object)Boolean.FALSE);
        return this.findAll(crit);
    }

    private List findAllCurrent(Criteria crit) {
        crit.eq("currentInd", (Object)Boolean.TRUE);
        return this.findAll(crit);
    }

    private List findAll(Criteria crit) {
        return new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
    }

    @Override
    public List findDocumentTypeAttributes(RuleAttribute ruleAttribute) {
        Criteria crit = new Criteria(DocumentTypeAttributeBo.class.getName());
        if (ruleAttribute.getId() != null) {
            crit.eq("ruleAttributeId", (Object)ruleAttribute.getId());
        }
        return new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
    }

    @Override
    public String findDocumentTypeIdByDocumentId(String documentId) {
        Criteria crit = new Criteria(DocumentRouteHeaderValue.class.getName());
        crit.eq("documentId", (Object)documentId);
        DocumentRouteHeaderValue docHeader = (DocumentRouteHeaderValue)new QueryByCriteria(this.entityManager, crit).toQuery().getSingleResult();
        return docHeader != null ? docHeader.getDocumentTypeId() : null;
    }

    @Override
    public String findDocumentTypeIdByName(String documentTypeName) {
        Criteria crit = new Criteria(DocumentType.class.getName());
        crit.eq("name", (Object)documentTypeName);
        crit.eq("currentInd", (Object)Boolean.TRUE);
        DocumentType documentType = (DocumentType)new QueryByCriteria(this.entityManager, crit).toQuery().getSingleResult();
        return documentType != null ? documentType.getDocumentTypeId() : null;
    }

    @Override
    public String findDocumentTypeNameById(String documentTypeId) {
        Criteria crit = new Criteria(DocumentType.class.getName());
        crit.eq("documentTypeId", (Object)documentTypeId);
        DocumentType documentType = (DocumentType)new QueryByCriteria(this.entityManager, crit).toQuery().getSingleResult();
        return documentType != null ? documentType.getName() : null;
    }
}

