/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.documentoperation.web;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.kew.documentoperation.web.DocumentContentOperationForm;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.web.KewKualiAction;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;

public class DocumentContentOperationAction
extends KewKualiAction {
    private static final String ALGORITHM = "DES/ECB/PKCS5Padding";
    private static final String CHARSET = "UTF-8";
    private static Logger LOG = Logger.getLogger(DocumentContentOperationAction.class);

    @Override
    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward encryptContent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.checkPermissions()) {
            DocumentContentOperationForm docContentOperationForm = (DocumentContentOperationForm)form;
            String formDocumentId = docContentOperationForm.getDocumentId();
            String[] documentIds = formDocumentId.split(",");
            String encryptionKey = docContentOperationForm.getKey();
            for (String documentId : documentIds) {
                String docContent = this.getDocumentContent(documentId);
                String encryptedDocContent = this.encrypt(encryptionKey, docContent);
                this.saveDocumentContent(documentId, encryptedDocContent);
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward decryptContent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.checkPermissions()) {
            DocumentContentOperationForm docContentOperationForm = (DocumentContentOperationForm)form;
            String formDocumentId = docContentOperationForm.getDocumentId();
            String[] documentIds = formDocumentId.split(",");
            String encryptionKey = docContentOperationForm.getKey();
            for (String documentId : documentIds) {
                String docContent = this.getDocumentContent(documentId);
                String decryptedDocContent = this.decrypt(encryptionKey, docContent);
                this.saveDocumentContent(documentId, decryptedDocContent);
            }
        }
        return mapping.findForward("basic");
    }

    private boolean checkPermissions() {
        String principalId = GlobalVariables.getUserSession().getPrincipalId();
        Map permissionDetails = KRADUtils.getNamespaceAndActionClass(((Object)((Object)this)).getClass());
        boolean canUseScreen = KimApiServiceLocator.getPermissionService().isAuthorizedByTemplate(principalId, "KR-NS", "Use Screen", permissionDetails, new HashMap());
        if (canUseScreen && !ConfigContext.getCurrentContextConfig().isProductionEnvironment()) {
            return true;
        }
        throw new AuthorizationException(GlobalVariables.getUserSession().getPrincipalName(), "encrypt or decrypt content", ((Object)((Object)this)).getClass().getSimpleName());
    }

    private String getDocumentContent(final String documentId) {
        DataSource dataSource = KEWServiceLocator.getDataSource();
        JdbcTemplate template = new JdbcTemplate(dataSource);
        String docContent = (String)template.execute(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                String sql = "SELECT doc_cntnt_txt FROM krew_doc_hdr_cntnt_t WHERE doc_hdr_id = ?";
                PreparedStatement statement = connection.prepareStatement(sql);
                return statement;
            }
        }, (PreparedStatementCallback)new PreparedStatementCallback<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String doInPreparedStatement(PreparedStatement statement) throws SQLException, DataAccessException {
                String docContent = "";
                statement.setString(1, documentId);
                ResultSet rs = statement.executeQuery();
                try {
                    while (rs.next()) {
                        docContent = rs.getString("doc_cntnt_txt");
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
                return docContent;
            }
        });
        return docContent;
    }

    private void saveDocumentContent(final String documentId, final String docContent) {
        if (StringUtils.isBlank((String)documentId) || StringUtils.isBlank((String)docContent)) {
            LOG.info((Object)"The document Id or the doc content was blank");
            return;
        }
        DataSource dataSource = KEWServiceLocator.getDataSource();
        JdbcTemplate template = new JdbcTemplate(dataSource);
        template.execute(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                String sql = "UPDATE krew_doc_hdr_cntnt_t SET doc_cntnt_txt = ? WHERE doc_hdr_id = ?";
                PreparedStatement statement = connection.prepareStatement(sql);
                return statement;
            }
        }, (PreparedStatementCallback)new PreparedStatementCallback<String>(){

            public String doInPreparedStatement(PreparedStatement statement) throws SQLException, DataAccessException {
                statement.setString(1, docContent);
                statement.setString(2, documentId);
                ResultSet rs = statement.executeQuery();
                if (rs != null) {
                    rs.close();
                }
                return "";
            }
        });
    }

    private SecretKey getSecretKey(String encryptionKey) throws Exception {
        KeyGenerator keygen = KeyGenerator.getInstance("DES");
        SecretKey desKey = keygen.generateKey();
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(4, desKey);
        byte[] bytes = Base64.decodeBase64((byte[])encryptionKey.getBytes());
        SecretKeyFactory desFactory = SecretKeyFactory.getInstance("DES");
        DESKeySpec keyspec = new DESKeySpec(bytes);
        desKey = desFactory.generateSecret(keyspec);
        cipher.init(3, desKey);
        return desKey;
    }

    private String encrypt(String encryptionKey, String value) throws Exception {
        if (StringUtils.isBlank((String)value)) {
            LOG.info((Object)"The value was was blank, returning an empty string");
            return "";
        }
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, this.getSecretKey(encryptionKey));
        try {
            byte[] cleartext = value.toString().getBytes(CHARSET);
            byte[] ciphertext = cipher.doFinal(cleartext);
            return new String(Base64.encodeBase64((byte[])ciphertext), CHARSET);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String decrypt(String encryptionKey, String value) throws Exception {
        if (StringUtils.isBlank((String)value)) {
            LOG.info((Object)"The value was was blank, returning an empty string");
            return "";
        }
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, this.getSecretKey(encryptionKey));
        byte[] encryptedData = Base64.decodeBase64((byte[])value.getBytes(CHARSET));
        byte[] cleartext1 = cipher.doFinal(encryptedData);
        return new String(cleartext1, CHARSET);
    }
}

