/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Version;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.kew.engine.node.BranchState;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.service.KEWServiceLocator;

@Entity
@Table(name="KREW_RTE_BRCH_T")
public class Branch
implements Serializable {
    private static final long serialVersionUID = 7164561979112939112L;
    @Id
    @GeneratedValue(generator="KREW_RTE_NODE_S")
    @GenericGenerator(name="KREW_RTE_NODE_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KREW_RTE_NODE_S"), @Parameter(name="value_column", value="id")})
    @Column(name="RTE_BRCH_ID")
    private String branchId;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    @JoinColumn(name="PARNT_ID")
    private Branch parentBranch;
    @Column(name="NM")
    private String name;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.MERGE}, mappedBy="branch", orphanRemoval=true)
    @Fetch(value=FetchMode.SELECT)
    private List<BranchState> branchState = new ArrayList<BranchState>();
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    @JoinColumn(name="INIT_RTE_NODE_INSTN_ID")
    private RouteNodeInstance initialNode;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    @JoinColumn(name="SPLT_RTE_NODE_INSTN_ID")
    private RouteNodeInstance splitNode;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="JOIN_RTE_NODE_INSTN_ID")
    private RouteNodeInstance joinNode;
    @Version
    @Column(name="VER_NBR")
    private Integer lockVerNbr;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RouteNodeInstance getSplitNode() {
        return this.splitNode;
    }

    public void setSplitNode(RouteNodeInstance splitNode) {
        this.splitNode = splitNode;
    }

    public RouteNodeInstance getInitialNode() {
        return this.initialNode;
    }

    public void setInitialNode(RouteNodeInstance activeNode) {
        this.initialNode = activeNode;
    }

    public String getBranchId() {
        return this.branchId;
    }

    public void setBranchId(String branchId) {
        this.branchId = branchId;
    }

    public RouteNodeInstance getJoinNode() {
        return this.joinNode;
    }

    public void setJoinNode(RouteNodeInstance joinNode) {
        this.joinNode = joinNode;
    }

    public Branch getParentBranch() {
        return this.parentBranch;
    }

    public void setParentBranch(Branch parentBranch) {
        this.parentBranch = parentBranch;
    }

    public BranchState getBranchState(String key) {
        for (BranchState branchState : this.branchState) {
            if (!branchState.getKey().equals(key)) continue;
            return branchState;
        }
        return null;
    }

    public void addBranchState(BranchState state) {
        this.branchState.add(state);
        state.setBranch(this);
    }

    public List<BranchState> getBranchState() {
        return this.branchState;
    }

    public void setBranchState(List<BranchState> branchState) {
        this.branchState.clear();
        this.branchState.addAll(branchState);
    }

    public BranchState getDocBranchState(int index) {
        while (this.branchState.size() <= index) {
            this.branchState.add(new BranchState());
        }
        return this.branchState.get(index);
    }

    public Integer getLockVerNbr() {
        return this.lockVerNbr;
    }

    public void setLockVerNbr(Integer lockVerNbr) {
        this.lockVerNbr = lockVerNbr;
    }

    public String toString() {
        return "[Branch: branchId=" + this.branchId + ", parentBranch=" + (this.parentBranch == null ? "null" : this.parentBranch.getBranchId()) + "]";
    }

    public void beforeInsert() {
        OrmUtils.populateAutoIncValue((Object)this, (EntityManager)KEWServiceLocator.getEntityManagerFactory().createEntityManager());
    }
}

