/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.actionrequest.ActionRequestFactory;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.api.rule.Rule;
import org.kuali.rice.kew.api.rule.RuleContract;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.IteratedRequestActivationNode;
import org.kuali.rice.kew.engine.node.NodeState;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.exception.RouteManagerException;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.rule.FlexRM;
import org.kuali.rice.kew.rule.KRAMetaRuleEngine;
import org.kuali.rice.kew.rule.RuleExpressionResult;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.util.Utilities;

public class KRAMetaRuleNode
extends IteratedRequestActivationNode {
    private static String SUPPRESS_POLICY_ERRORS_KEY = "_suppressPolicyErrorsRequestActivationNode";

    protected List<ActionRequestValue> generateUninitializedRequests(ActionRequestFactory arFactory, RouteContext context, RuleExpressionResult result) throws WorkflowException {
        FlexRM flexRM = new FlexRM();
        flexRM.makeActionRequests(arFactory, result.getResponsibilities(), context, Rule.Builder.create((RuleContract)result.getRule().getDefinition()).build(), context.getDocument(), null, null);
        return new ArrayList<ActionRequestValue>(arFactory.getRequestGraphs());
    }

    protected List<ActionRequestValue> initializeRequests(List<ActionRequestValue> requests, RouteContext context) {
        ArrayList<ActionRequestValue> newRequests = new ArrayList<ActionRequestValue>();
        for (ActionRequestValue actionRequest : requests) {
            actionRequest = KEWServiceLocator.getActionRequestService().initializeActionRequestGraph(actionRequest, context.getDocument(), context.getNodeInstance());
            this.saveActionRequest(context, actionRequest);
            newRequests.add(actionRequest);
        }
        return newRequests;
    }

    @Override
    protected boolean generateNewRequests(boolean initial, RouteContext context, RouteHelper routeHelper) throws WorkflowException, Exception {
        RouteNodeInstance nodeInstance = context.getNodeInstance();
        RouteNode nodeDef = nodeInstance.getRouteNode();
        Map<String, String> cfg = Utilities.getKeyValueCollectionAsMap(nodeDef.getConfigParams());
        String expression = cfg.get("expression");
        if (StringUtils.isEmpty((String)expression)) {
            throw new WorkflowException("No meta-rule expression supplied in node " + nodeDef);
        }
        KRAMetaRuleEngine engine = new KRAMetaRuleEngine(expression);
        int curStatement = KRAMetaRuleNode.getCurStatement(nodeInstance);
        engine.setCurStatement(curStatement);
        if (engine.isDone()) {
            return false;
        }
        RuleExpressionResult result = engine.processSingleStatement(context);
        if (!result.isSuccess()) {
            return false;
        }
        boolean suppressPolicyErrors = KRAMetaRuleNode.isSupressingPolicyErrors(context);
        boolean pastFinalApprover = this.isPastFinalApprover(context.getDocument(), nodeInstance);
        ActionRequestFactory arFactory = new ActionRequestFactory(context.getDocument(), context.getNodeInstance());
        List<ActionRequestValue> requests = this.generateUninitializedRequests(arFactory, context, result);
        if ((requests = this.initializeRequests(requests, context)).isEmpty() && nodeDef.getMandatoryRouteInd().booleanValue() && !suppressPolicyErrors) {
            this.LOG.warn((Object)("no requests generated for mandatory route - " + nodeDef.getRouteNodeName()));
            throw new RouteManagerException("No requests generated for mandatory route " + nodeDef.getRouteNodeName() + ":" + nodeDef.getRouteMethodName(), context);
        }
        boolean hasApproveRequest = false;
        for (ActionRequestValue actionRequest : requests) {
            hasApproveRequest = actionRequest.isApproveOrCompleteRequest() || hasApproveRequest;
        }
        if (nodeDef.getFinalApprovalInd().booleanValue()) {
            if (!hasApproveRequest && !suppressPolicyErrors) {
                throw new RuntimeException("No Approve Request generated after final approver");
            }
        } else if (pastFinalApprover && hasApproveRequest && !suppressPolicyErrors) {
            throw new RuntimeException("Approve Request generated after final approver");
        }
        nodeInstance.getNodeState("stmt").setValue(String.valueOf(curStatement + 1));
        return !requests.isEmpty();
    }

    protected static int getCurStatement(RouteNodeInstance nodeInstance) {
        int statement = 0;
        NodeState nodeState = nodeInstance.getNodeState("stmt");
        if (nodeState == null) {
            nodeState = new NodeState();
            nodeState.setKey("stmt");
            nodeState.setNodeInstance(nodeInstance);
            nodeInstance.addNodeState(nodeState);
        }
        if (StringUtils.isEmpty((String)nodeState.getValue())) {
            nodeState.setValue("0");
        } else {
            statement = Integer.parseInt(nodeState.getValue());
        }
        return statement;
    }

    @Override
    protected IteratedRequestActivationNode.RequestFulfillmentCriteria getRequestFulfillmentCriteria(RouteContext routeContext) {
        return super.getRequestFulfillmentCriteria(routeContext);
    }

    private Object getKey(RouteNodeInstance nodeInstance) {
        String id = nodeInstance.getRouteNodeInstanceId();
        return id != null ? id : nodeInstance;
    }

    private boolean isPastFinalApprover(DocumentRouteHeaderValue document, RouteNodeInstance nodeInstance) {
        FinalApproverContext context = new FinalApproverContext();
        List revokedNodeInstances = KEWServiceLocator.getRouteNodeService().getRevokedNodeInstances(document);
        HashSet<String> revokedNodeInstanceIds = new HashSet<String>();
        for (RouteNodeInstance revokedNodeInstance : revokedNodeInstances) {
            revokedNodeInstanceIds.add(revokedNodeInstance.getRouteNodeInstanceId());
        }
        this.isPastFinalApprover(nodeInstance.getPreviousNodeInstances(), context, revokedNodeInstanceIds);
        return context.isPast;
    }

    private void isPastFinalApprover(List previousNodeInstances, FinalApproverContext context, Set revokedNodeInstanceIds) {
        if (previousNodeInstances != null && !previousNodeInstances.isEmpty()) {
            Iterator iterator = previousNodeInstances.iterator();
            while (iterator.hasNext()) {
                if (context.isPast) {
                    return;
                }
                RouteNodeInstance nodeInstance = (RouteNodeInstance)iterator.next();
                if (context.inspected.contains(this.getKey(nodeInstance))) continue;
                context.inspected.add(this.getKey(nodeInstance));
                if (Boolean.TRUE.equals(nodeInstance.getRouteNode().getFinalApprovalInd())) {
                    if (!revokedNodeInstanceIds.contains(nodeInstance.getRouteNodeInstanceId())) {
                        context.isPast = true;
                    }
                    return;
                }
                this.isPastFinalApprover(nodeInstance.getPreviousNodeInstances(), context, revokedNodeInstanceIds);
            }
        }
    }

    public static boolean isSupressingPolicyErrors(RouteContext routeContext) {
        Boolean suppressPolicyErrors = (Boolean)routeContext.getParameters().get(SUPPRESS_POLICY_ERRORS_KEY);
        return suppressPolicyErrors != null && suppressPolicyErrors != false;
    }

    private class FinalApproverContext {
        public Set inspected = new HashSet();
        public boolean isPast = false;

        private FinalApproverContext() {
        }
    }
}

