/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.PropertiesUtil;
import org.kuali.rice.kew.engine.node.SimpleNode;
import org.kuali.rice.kew.engine.node.SimpleResult;
import org.kuali.rice.kew.engine.node.var.PropertyScheme;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class LogNode
implements SimpleNode {
    private static final Logger LOG = Logger.getLogger(LogNode.class);

    @Override
    public SimpleResult process(RouteContext context, RouteHelper helper) throws Exception {
        LOG.error((Object)"processing");
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        String contentFragment = context.getNodeInstance().getRouteNode().getContentFragment();
        LOG.error((Object)("contentFragment=" + contentFragment));
        Document d = db.parse(new InputSource(new StringReader(contentFragment)));
        Element e = d.getDocumentElement();
        String name = null;
        NodeList list = e.getElementsByTagName("log");
        if (list != null && list.getLength() > 0) {
            name = list.item(0).getTextContent();
        }
        list = e.getElementsByTagName("level");
        String level = "info";
        if (list != null && list.getLength() > 0) {
            level = list.item(0).getTextContent().toLowerCase();
        }
        LOG.error((Object)("doc content: " + context.getDocument().getDocContent()));
        String valueRef = e.getElementsByTagName("message").item(0).getTextContent();
        Object retrievedVal = PropertiesUtil.retrieveProperty(valueRef, PropertyScheme.LITERAL_SCHEME, context);
        LOG.error((Object)("retrieved value '" + retrievedVal + " for message '" + valueRef));
        Logger l = name == null ? LOG : Logger.getLogger((String)name);
        l.log((Priority)Level.toLevel((String)level), retrievedVal);
        return new SimpleResult(true);
    }
}

