/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.var.Property;
import org.kuali.rice.kew.engine.node.var.PropertyScheme;

public final class PropertiesUtil {
    private static final Logger LOG = Logger.getLogger(PropertiesUtil.class);

    private PropertiesUtil() {
        throw new UnsupportedOperationException("do not call");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readResource(InputStream stream) throws IOException {
        StringBuffer sb = new StringBuffer(2048);
        InputStreamReader reader = new InputStreamReader(stream);
        char[] buf = new char[1024];
        try {
            int read;
            while ((read = reader.read(buf)) != -1) {
                sb.append(buf, 0, read);
            }
        }
        finally {
            reader.close();
        }
        return sb.toString();
    }

    public static Object retrieveProperty(String name, RouteContext context) {
        return PropertiesUtil.retrieveProperty(new Property(name), context);
    }

    public static Object retrieveProperty(String name, PropertyScheme defaultScheme, RouteContext context) {
        return PropertiesUtil.retrieveProperty(new Property(name), defaultScheme, context);
    }

    public static Object retrieveProperty(Property prop, PropertyScheme defaultScheme, RouteContext context) {
        if (prop.scheme == null && defaultScheme != null) {
            prop.scheme = defaultScheme.getName();
        }
        return PropertiesUtil.retrieveProperty(prop, context);
    }

    public static Object retrieveProperty(Property prop, RouteContext context) {
        for (PropertyScheme scheme : PropertyScheme.SCHEMES) {
            if (!scheme.getName().equals(prop.scheme) && !scheme.getShortName().equals(prop.scheme)) continue;
            LOG.debug((Object)("Loading prop " + prop + " with scheme " + scheme));
            return scheme.load(prop, context);
        }
        String message = "Invalid property scheme: '" + prop.scheme + "'";
        LOG.error((Object)message);
        throw new RuntimeException(message);
    }
}

