/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.RequestsNode;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.exception.RouteManagerException;
import org.kuali.rice.kew.role.RoleRouteModule;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routemodule.RouteModule;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.util.ClassDumper;
import org.kuali.rice.kew.util.PerformanceLogger;
import org.kuali.rice.kim.api.responsibility.Responsibility;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class RoleNode
extends RequestsNode {
    private static final Logger LOG = Logger.getLogger(RoleNode.class);
    protected static final Comparator<ActionRequestValue> ROLE_REQUEST_SORTER = new RoleRequestSorter();

    @Override
    protected RouteModule getRouteModule(RouteContext context) throws Exception {
        return new RoleRouteModule();
    }

    @Override
    protected boolean processCustom(RouteContext routeContext, RouteHelper routeHelper) throws Exception {
        DocumentRouteHeaderValue document = routeContext.getDocument();
        RouteNodeInstance nodeInstance = routeContext.getNodeInstance();
        RouteNode node = nodeInstance.getRouteNode();
        if (nodeInstance.isInitial()) {
            Responsibility resp;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RouteHeader info inside routing loop\n" + ClassDumper.dumpFields(routeContext.getDocument())));
                LOG.debug((Object)("Looking for new actionRequests - routeLevel: " + node.getRouteNodeName()));
            }
            boolean suppressPolicyErrors = RoleNode.isSupressingPolicyErrors(routeContext);
            List<ActionRequestValue> requests = this.getNewActionRequests(routeContext);
            if (requests.isEmpty() && !suppressPolicyErrors && (resp = this.getFirstResponsibilityWithMandatoryRouteFlag(document, node)) != null) {
                throw new RouteManagerException("No requests generated for KIM Responsibility-based mandatory route.\nDocument Id:    " + document.getDocumentId() + "\n" + "DocumentType:   " + document.getDocumentType().getName() + "\n" + "Route Node:     " + node.getRouteNodeName() + "\n" + "Responsibility: " + resp, routeContext);
            }
            if (!suppressPolicyErrors) {
                this.verifyFinalApprovalRequest(document, requests, nodeInstance, routeContext);
            }
        }
        return true;
    }

    protected Responsibility getFirstResponsibilityWithMandatoryRouteFlag(DocumentRouteHeaderValue document, RouteNode node) {
        Predicate p = PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.equal((String)"template.namespaceCode", (Object)"KR-WKFLW"), PredicateFactory.equal((String)"template.name", (Object)"Review"), PredicateFactory.equal((String)"active", (Object)"Y"), PredicateFactory.equal((String)"attributes[routeNodeName]", (Object)node.getRouteNodeName())});
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{p});
        List responsibilities = KimApiServiceLocator.getResponsibilityService().findResponsibilities(builder.build()).getResults();
        for (DocumentType docType = document.getDocumentType(); docType != null; docType = docType.getParentDocType()) {
            if (responsibilities.isEmpty()) continue;
            for (Responsibility resp : responsibilities) {
                String documentTypeName = (String)resp.getAttributes().get("documentTypeName");
                if (!StringUtils.isNotEmpty((String)documentTypeName) || !StringUtils.equals((String)documentTypeName, (String)docType.getName()) || !Boolean.parseBoolean((String)resp.getAttributes().get("required"))) continue;
                return resp;
            }
        }
        return null;
    }

    @Override
    public boolean activateRequests(RouteContext context, DocumentRouteHeaderValue document, RouteNodeInstance nodeInstance) throws WorkflowException {
        MDC.put((String)"docId", (Object)document.getDocumentId());
        PerformanceLogger performanceLogger = new PerformanceLogger(document.getDocumentId());
        ArrayList<ActionItem> generatedActionItems = new ArrayList<ActionItem>();
        List<Object> requests = new ArrayList();
        if (context.isSimulation()) {
            for (ActionRequestValue ar : context.getDocument().getActionRequests()) {
                if (!ar.getCurrentIndicator().booleanValue() || !ActionRequestStatus.INITIALIZED.getCode().equals(ar.getStatus()) && !ActionRequestStatus.ACTIVATED.getCode().equals(ar.getStatus()) || !ar.getNodeInstance().getRouteNodeInstanceId().equals(nodeInstance.getRouteNodeInstanceId()) || ar.getParentActionRequest() != null) continue;
                requests.add(ar);
            }
            requests.addAll(context.getEngineState().getGeneratedRequests());
        } else {
            requests = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocIdAtRouteNode(document.getDocumentId(), nodeInstance.getRouteNodeInstanceId());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Pending Root Requests " + requests.size()));
        }
        boolean requestActivated = this.activateRequestsCustom(context, requests, generatedActionItems, document, nodeInstance);
        this.notify(context, generatedActionItems, nodeInstance);
        performanceLogger.log("Time to activate requests.");
        return requestActivated;
    }

    @Override
    protected boolean activateRequestsCustom(RouteContext context, List<ActionRequestValue> requests, List<ActionItem> generatedActionItems, DocumentRouteHeaderValue document, RouteNodeInstance nodeInstance) throws WorkflowException {
        Collections.sort(requests, ROLE_REQUEST_SORTER);
        String activationType = nodeInstance.getRouteNode().getActivationType();
        boolean isParallel = "P".equals(activationType);
        boolean requestActivated = false;
        String groupToActivate = null;
        Integer priorityToActivate = null;
        for (ActionRequestValue request : requests) {
            if (requestActivated && !isParallel && (!context.isSimulation() || !context.getActivationContext().isActivateRequests())) break;
            if (request.getParentActionRequest() != null || request.getNodeInstance() == null) continue;
            if (request.isApproveOrCompleteRequest()) {
                boolean thisRequestActivated = false;
                if (priorityToActivate == null) {
                    priorityToActivate = request.getPriority();
                }
                if (groupToActivate == null) {
                    groupToActivate = request.getResponsibilityDesc();
                }
                if (StringUtils.equals((String)groupToActivate, (String)request.getResponsibilityDesc()) && (priorityToActivate != null && request.getPriority() != null && priorityToActivate.equals(request.getPriority()) || priorityToActivate == null && request.getPriority() == null)) {
                    if (request.isActive()) {
                        requestActivated = true;
                        continue;
                    }
                    this.logProcessingMessage(request);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Activating request: " + request));
                    }
                    thisRequestActivated = this.activateRequest(context, request, nodeInstance, generatedActionItems);
                    requestActivated |= thisRequestActivated;
                }
                if (thisRequestActivated || requestActivated) continue;
                priorityToActivate = null;
                groupToActivate = null;
                continue;
            }
            this.logProcessingMessage(request);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Activating request: " + request));
            }
            requestActivated = this.activateRequest(context, request, nodeInstance, generatedActionItems) || requestActivated;
        }
        return requestActivated;
    }

    protected static class RoleRequestSorter
    implements Comparator<ActionRequestValue> {
        protected RoleRequestSorter() {
        }

        @Override
        public int compare(ActionRequestValue ar1, ActionRequestValue ar2) {
            int result = 0;
            if (ar1.getResponsibilityDesc() != null && ar2.getResponsibilityDesc() != null) {
                result = ar1.getResponsibilityDesc().compareTo(ar2.getResponsibilityDesc());
            }
            if (result != 0) {
                return result;
            }
            result = ar1.getPriority().compareTo(ar2.getPriority());
            if (result != 0) {
                return result;
            }
            result = ActionRequestValue.compareActionCode(ar1.getActionRequested(), ar2.getActionRequested(), true);
            if (result != 0) {
                return result;
            }
            result = ar1.getActionRequestId() != null && ar2.getActionRequestId() != null ? ar1.getActionRequestId().compareTo(ar2.getActionRequestId()) : 0;
            return result;
        }
    }
}

