/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.simulation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.KimGroupRecipient;
import org.kuali.rice.kew.actionrequest.KimPrincipalRecipient;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.actionrequest.service.ActionRequestService;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.exception.DocumentSimulatedRouteException;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.api.exception.ResourceUnavailableException;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.ActivationContext;
import org.kuali.rice.kew.engine.EngineState;
import org.kuali.rice.kew.engine.OrchestrationConfig;
import org.kuali.rice.kew.engine.ProcessContext;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.StandardWorkflowEngine;
import org.kuali.rice.kew.engine.node.Branch;
import org.kuali.rice.kew.engine.node.NoOpNode;
import org.kuali.rice.kew.engine.node.NodeJotter;
import org.kuali.rice.kew.engine.node.NodeType;
import org.kuali.rice.kew.engine.node.ProcessDefinitionBo;
import org.kuali.rice.kew.engine.node.RequestsNode;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.node.SimpleNode;
import org.kuali.rice.kew.engine.node.service.RouteNodeService;
import org.kuali.rice.kew.engine.simulation.SimulationActionToTake;
import org.kuali.rice.kew.engine.simulation.SimulationCriteria;
import org.kuali.rice.kew.engine.simulation.SimulationResults;
import org.kuali.rice.kew.engine.simulation.SimulationWorkflowEngine;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.util.PerformanceLogger;
import org.kuali.rice.kew.util.Utilities;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.Person;

public class SimulationEngine
extends StandardWorkflowEngine
implements SimulationWorkflowEngine {
    private static final Logger LOG = Logger.getLogger(SimulationEngine.class);
    private SimulationCriteria criteria;
    private SimulationResults results;

    public SimulationEngine() {
    }

    public SimulationEngine(RouteNodeService routeNodeService, RouteHeaderService routeHeaderService, ParameterService parameterService, OrchestrationConfig config) {
        super(routeNodeService, routeHeaderService, parameterService, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimulationResults runSimulation(SimulationCriteria criteria) throws Exception {
        try {
            this.criteria = criteria;
            this.results = new SimulationResults();
            this.validateCriteria(criteria);
            this.process(criteria.getDocumentId(), null);
            SimulationResults simulationResults = this.results;
            return simulationResults;
        }
        finally {
            this.criteria = null;
            this.results = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(String documentId, String nodeInstanceId) throws InvalidActionTakenException, DocumentSimulatedRouteException {
        RouteContext context = RouteContext.createNewRouteContext();
        try {
            boolean mdcHadDocId;
            ActivationContext activationContext = new ActivationContext(true);
            if (this.criteria.isActivateRequests() == null) {
                activationContext.setActivateRequests(!this.criteria.getActionsToTake().isEmpty());
            } else {
                activationContext.setActivateRequests(this.criteria.isActivateRequests());
            }
            context.setActivationContext(activationContext);
            context.setEngineState(new EngineState());
            RequestsNode.setSupressPolicyErrors(context);
            DocumentRouteHeaderValue document = this.createSimulationDocument(documentId, this.criteria, context);
            document.setInitiatorWorkflowId("simulation");
            if (this.criteria.isDocumentSimulation() && (document.isProcessed() || document.isFinal())) {
                this.results.setDocument(document);
                return;
            }
            this.routeDocumentIfNecessary(document, this.criteria, context);
            this.results.setDocument(document);
            documentId = document.getDocumentId();
            boolean bl = mdcHadDocId = MDC.get((String)"docId") != null;
            if (!mdcHadDocId) {
                MDC.put((String)"docId", (Object)documentId);
            }
            PerformanceLogger perfLog = new PerformanceLogger(documentId);
            try {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Processing document for Simulation: " + documentId));
                }
                List<RouteNodeInstance> activeNodeInstances = this.getRouteNodeService().getActiveNodeInstances(document);
                List<RouteNodeInstance> nodeInstancesToProcess = this.determineNodeInstancesToProcess(activeNodeInstances, this.criteria.getDestinationNodeName());
                context.setDocument(document);
                context.setEngineState(new EngineState());
                ProcessContext processContext = new ProcessContext(true, nodeInstancesToProcess);
                while (!nodeInstancesToProcess.isEmpty()) {
                    RouteNodeInstance nodeInstance = nodeInstancesToProcess.remove(0);
                    if (!nodeInstance.isActive()) continue;
                    NodeJotter.jotNodeInstance(context.getDocument(), nodeInstance);
                    context.setNodeInstance(nodeInstance);
                    processContext = this.processNodeInstance(context, this.helper);
                    if (!this.hasReachedCompletion(processContext, context.getEngineState().getGeneratedRequests(), nodeInstance, this.criteria)) {
                        if (!processContext.isComplete()) continue;
                        if (!processContext.getNextNodeInstances().isEmpty()) {
                            nodeInstancesToProcess.addAll(processContext.getNextNodeInstances());
                        }
                        context.getActivationContext().getSimulatedActionsTaken().addAll(this.processPotentialActionsTaken(context, document, nodeInstance, this.criteria));
                        continue;
                    }
                    context.getActivationContext().getSimulatedActionsTaken().addAll(this.processPotentialActionsTaken(context, document, nodeInstance, this.criteria));
                }
                List simulatedActionRequests = context.getEngineState().getGeneratedRequests();
                Collections.sort(simulatedActionRequests, new Utilities.RouteLogActionRequestSorter());
                this.results.setSimulatedActionRequests(simulatedActionRequests);
                this.results.setSimulatedActionsTaken(context.getActivationContext().getSimulatedActionsTaken());
            }
            catch (InvalidActionTakenException e) {
                throw e;
            }
            catch (Exception e) {
                String errorMsg = "Error running simulation for document " + (this.criteria.isDocumentSimulation() ? "id " + documentId.toString() : "type " + this.criteria.getDocumentTypeName());
                LOG.error((Object)errorMsg, (Throwable)e);
                throw new DocumentSimulatedRouteException(errorMsg, (Throwable)e);
            }
            finally {
                perfLog.log("Time to run simulation.");
                RouteContext.clearCurrentRouteContext();
                if (!mdcHadDocId) {
                    MDC.remove((String)"docID");
                }
            }
        }
        finally {
            RouteContext.releaseCurrentRouteContext();
        }
    }

    private List<RouteNodeInstance> determineNodeInstancesToProcess(List<RouteNodeInstance> activeNodeInstances, String nodeName) throws InvalidActionTakenException {
        if (StringUtils.isEmpty((String)nodeName)) {
            return activeNodeInstances;
        }
        ArrayList<RouteNodeInstance> nodeInstancesToProcess = new ArrayList<RouteNodeInstance>();
        for (RouteNodeInstance nodeInstance : activeNodeInstances) {
            if (nodeName.equals(nodeInstance.getName())) {
                return new ArrayList<RouteNodeInstance>();
            }
            if (!this.isNodeNameInPath(nodeName, nodeInstance)) continue;
            nodeInstancesToProcess.add(nodeInstance);
        }
        if (nodeInstancesToProcess.size() == 0) {
            throw new InvalidActionTakenException("Could not locate a node with the given name in the blanket approval path '" + nodeName + "'.  " + "The document is probably already passed the specified node or does not contain the node.");
        }
        return nodeInstancesToProcess;
    }

    private boolean isNodeNameInPath(String nodeName, RouteNodeInstance nodeInstance) {
        boolean isInPath = false;
        for (RouteNode nextNode : nodeInstance.getRouteNode().getNextNodes()) {
            isInPath = isInPath || this.isNodeNameInPath(nodeName, nextNode, new HashSet<String>());
        }
        return isInPath;
    }

    private boolean isNodeNameInPath(String nodeName, RouteNode node, Set<String> inspected) {
        ProcessDefinitionBo subProcess;
        RouteNode subNode;
        boolean isInPath = !inspected.contains(node.getRouteNodeId()) && node.getRouteNodeName().equals(nodeName);
        inspected.add(node.getRouteNodeId());
        if (this.helper.isSubProcessNode(node) && (subNode = (subProcess = node.getDocumentType().getNamedProcess(node.getRouteNodeName())).getInitialRouteNode()) != null) {
            isInPath = isInPath || this.isNodeNameInPath(nodeName, subNode, inspected);
        }
        for (RouteNode nextNode : node.getNextNodes()) {
            isInPath = isInPath || this.isNodeNameInPath(nodeName, nextNode, inspected);
        }
        return isInPath;
    }

    private boolean hasReachedCompletion(ProcessContext processContext, List actionRequests, RouteNodeInstance nodeInstance, SimulationCriteria criteria) {
        if (!criteria.getDestinationRecipients().isEmpty()) {
            for (ActionRequestValue request : actionRequests) {
                for (Recipient recipient : criteria.getDestinationRecipients()) {
                    if (!request.isRecipientRoutedRequest(recipient) || !StringUtils.isEmpty((String)criteria.getDestinationNodeName()) && !criteria.getDestinationNodeName().equals(request.getNodeInstance().getName())) continue;
                    return true;
                }
            }
        }
        return StringUtils.isEmpty((String)criteria.getDestinationNodeName()) && processContext.isComplete() && processContext.getNextNodeInstances().isEmpty() || nodeInstance.getRouteNode().getRouteNodeName().equals(criteria.getDestinationNodeName());
    }

    private List<ActionTakenValue> processPotentialActionsTaken(RouteContext routeContext, DocumentRouteHeaderValue routeHeader, RouteNodeInstance justProcessedNode, SimulationCriteria criteria) {
        ArrayList<ActionTakenValue> actionsTaken = new ArrayList<ActionTakenValue>();
        ArrayList<ActionRequestValue> requestsToCheck = new ArrayList<ActionRequestValue>();
        requestsToCheck.addAll(routeContext.getEngineState().getGeneratedRequests());
        requestsToCheck.addAll(routeHeader.getActionRequests());
        List<ActionRequestValue> pendingActionRequestValues = this.getCriteriaActionsToDoByNodeName(requestsToCheck, justProcessedNode.getName());
        List<ActionTakenValue> actionsToTakeForNode = this.generateActionsToTakeForNode(justProcessedNode.getName(), routeHeader, criteria, pendingActionRequestValues);
        for (ActionTakenValue actionTaken : actionsToTakeForNode) {
            KEWServiceLocator.getActionRequestService().deactivateRequests(actionTaken, pendingActionRequestValues, routeContext.getActivationContext());
            actionsTaken.add(actionTaken);
        }
        return actionsTaken;
    }

    private List<ActionTakenValue> generateActionsToTakeForNode(String nodeName, DocumentRouteHeaderValue routeHeader, SimulationCriteria criteria, List<ActionRequestValue> pendingActionRequests) {
        ArrayList<ActionTakenValue> actions = new ArrayList<ActionTakenValue>();
        if (criteria.getActionsToTake() != null && !criteria.getActionsToTake().isEmpty()) {
            for (SimulationActionToTake simAction : criteria.getActionsToTake()) {
                if (!nodeName.equals(simAction.getNodeName())) continue;
                actions.add(this.createDummyActionTaken(routeHeader, simAction.getUser(), simAction.getActionToPerform(), this.findDelegatorForActionRequests(pendingActionRequests)));
            }
        }
        return actions;
    }

    private List<ActionRequestValue> getCriteriaActionsToDoByNodeName(List generatedRequests, String nodeName) {
        ArrayList<ActionRequestValue> requests = new ArrayList<ActionRequestValue>();
        for (ActionRequestValue request : generatedRequests) {
            if (!request.isPending() || request.getNodeInstance() == null || !nodeName.equals(request.getNodeInstance().getName())) continue;
            requests.add(request);
        }
        return requests;
    }

    private void validateCriteria(SimulationCriteria criteria) {
        if (criteria.getDocumentId() == null && StringUtils.isEmpty((String)criteria.getDocumentTypeName())) {
            throw new IllegalArgumentException("No document type name or document id given, cannot simulate a document without a document type name or a document id.");
        }
        if (criteria.getXmlContent() == null) {
            criteria.setXmlContent("");
        }
    }

    private DocumentRouteHeaderValue createSimulationDocument(String documentId, SimulationCriteria criteria, RouteContext context) {
        DocumentRouteHeaderValue document = null;
        if (criteria.isDocumentSimulation()) {
            document = this.getDocumentForSimulation(documentId);
            if (!StringUtils.isEmpty((String)criteria.getXmlContent())) {
                document.setDocContent(criteria.getXmlContent());
            }
        } else if (criteria.isDocumentTypeSimulation()) {
            DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByName(criteria.getDocumentTypeName());
            if (documentType == null) {
                throw new IllegalArgumentException("Specified document type could not be found for name '" + criteria.getDocumentTypeName() + "'");
            }
            documentId = context.getEngineState().getNextSimulationId().toString();
            document = new DocumentRouteHeaderValue();
            context.setDocument(document);
            document.setDocumentId(documentId);
            document.setCreateDate(new Timestamp(System.currentTimeMillis()));
            document.setDocContent(criteria.getXmlContent());
            document.setDocRouteLevel(new Integer(0));
            document.setDocumentTypeId(documentType.getDocumentTypeId());
            document.setDocRouteStatus("I");
            this.initializeDocument(document);
        }
        if (document == null) {
            throw new IllegalArgumentException("Workflow simulation engine could not locate document with id " + documentId);
        }
        for (ActionRequestValue actionRequest : document.getActionRequests()) {
            actionRequest = (ActionRequestValue)this.deepCopy(actionRequest);
            document.getSimulatedActionRequests().add(actionRequest);
            for (ActionItem actionItem : actionRequest.getActionItems()) {
                actionRequest.getSimulatedActionItems().add((ActionItem)this.deepCopy(actionItem));
            }
        }
        context.setDocument(document);
        this.installSimulationNodeInstances(context, criteria);
        return document;
    }

    private DocumentRouteHeaderValue getDocumentForSimulation(String documentId) {
        DocumentRouteHeaderValue document = this.getRouteHeaderService().getRouteHeader(documentId);
        return (DocumentRouteHeaderValue)((Object)this.deepCopy((Serializable)((Object)document)));
    }

    private Serializable deepCopy(Serializable src) {
        Serializable obj = null;
        if (src != null) {
            ObjectOutputStream oos = null;
            ObjectInputStream ois = null;
            try {
                ByteArrayOutputStream serializer = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(serializer);
                oos.writeObject(src);
                ByteArrayInputStream deserializer = new ByteArrayInputStream(serializer.toByteArray());
                ois = new ObjectInputStream(deserializer);
                obj = (Serializable)ois.readObject();
            }
            catch (IOException e) {
                throw new RuntimeException("unable to complete deepCopy from src '" + src.toString() + "'", e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("unable to complete deepCopy from src '" + src.toString() + "'", e);
            }
            finally {
                try {
                    if (oos != null) {
                        oos.close();
                    }
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return obj;
    }

    private void routeDocumentIfNecessary(DocumentRouteHeaderValue document, SimulationCriteria criteria, RouteContext routeContext) throws InvalidActionTakenException {
        if (criteria.getRoutingUser() != null) {
            ActionTakenValue action = this.createDummyActionTaken(document, criteria.getRoutingUser(), "O", null);
            routeContext.getActivationContext().getSimulatedActionsTaken().add(action);
            this.simulateDocumentRoute(action, document, criteria.getRoutingUser(), routeContext);
        }
    }

    private void installSimulationNodeInstances(RouteContext context, SimulationCriteria criteria) {
        List<RouteNode> nodes;
        DocumentRouteHeaderValue document = context.getDocument();
        ArrayList<RouteNode> simulationNodes = new ArrayList<RouteNode>();
        if (!criteria.getNodeNames().isEmpty()) {
            for (String nodeName : criteria.getNodeNames()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Installing simulation starting node '" + nodeName + "'"));
                }
                List<RouteNode> nodes2 = KEWServiceLocator.getRouteNodeService().getFlattenedNodes(document.getDocumentType(), true);
                boolean foundNode = false;
                for (RouteNode node : nodes2) {
                    if (!node.getRouteNodeName().equals(nodeName)) continue;
                    simulationNodes.add(node);
                    foundNode = true;
                    break;
                }
                if (foundNode) continue;
                throw new IllegalArgumentException("Could not find node on the document type for the given name '" + nodeName + "'");
            }
        } else if (!criteria.getRuleTemplateNames().isEmpty()) {
            nodes = KEWServiceLocator.getRouteNodeService().getFlattenedNodes(document.getDocumentType(), true);
            for (String ruleTemplateName : criteria.getRuleTemplateNames()) {
                boolean foundNode = false;
                for (RouteNode node : nodes) {
                    String routeMethodName = node.getRouteMethodName();
                    if (!node.isFlexRM() || !ruleTemplateName.equals(routeMethodName)) continue;
                    simulationNodes.add(node);
                    foundNode = true;
                    break;
                }
                if (foundNode) continue;
                throw new IllegalArgumentException("Could not find node on the document type with the given rule template name '" + ruleTemplateName + "'");
            }
        } else if (criteria.isFlattenNodes()) {
            nodes = KEWServiceLocator.getRouteNodeService().getFlattenedNodes(document.getDocumentType(), true);
            for (RouteNode node : nodes) {
                try {
                    if (!NodeType.fromNode(node).isTypeOf(SimpleNode.class) || NodeType.fromNode(node).isTypeOf(NoOpNode.class)) continue;
                    simulationNodes.add(node);
                }
                catch (ResourceUnavailableException ex) {
                    LOG.warn((Object)("Unable to determine node type in simulator: " + ex.getMessage()));
                }
            }
        } else {
            return;
        }
        Branch defaultBranch = document.getInitialRouteNodeInstances().get(0).getBranch();
        document.getInitialRouteNodeInstances().clear();
        RouteNodeInstance currentNodeInstance = null;
        for (RouteNode simulationNode : simulationNodes) {
            RouteNodeInstance nodeInstance = this.helper.getNodeFactory().createRouteNodeInstance(document.getDocumentId(), simulationNode);
            nodeInstance.setBranch(defaultBranch);
            if (currentNodeInstance == null) {
                document.getInitialRouteNodeInstances().add(nodeInstance);
                nodeInstance.setActive(true);
                this.saveNode(context, nodeInstance);
            } else {
                currentNodeInstance.addNextNodeInstance(nodeInstance);
                this.saveNode(context, currentNodeInstance);
            }
            currentNodeInstance = nodeInstance;
        }
        this.installSimulationTerminationNode(context, document.getDocumentType(), currentNodeInstance);
    }

    private void installSimulationTerminationNode(RouteContext context, DocumentType documentType, RouteNodeInstance lastNodeInstance) {
        RouteNode terminationNode = new RouteNode();
        terminationNode.setDocumentType(documentType);
        terminationNode.setDocumentTypeId(documentType.getDocumentTypeId());
        terminationNode.setNodeType(NoOpNode.class.getName());
        terminationNode.setRouteNodeName("SIMULATION_TERMINATION_NODE");
        RouteNodeInstance terminationNodeInstance = this.helper.getNodeFactory().createRouteNodeInstance(lastNodeInstance.getDocumentId(), terminationNode);
        terminationNodeInstance.setBranch(lastNodeInstance.getBranch());
        lastNodeInstance.addNextNodeInstance(terminationNodeInstance);
        this.saveNode(context, lastNodeInstance);
    }

    private void simulateDocumentRoute(ActionTakenValue actionTaken, DocumentRouteHeaderValue document, Person user, RouteContext routeContext) throws InvalidActionTakenException {
        if (document.isRouted()) {
            throw new WorkflowRuntimeException("Document can not simulate a route if it has already been routed");
        }
        ActionRequestService actionRequestService = KEWServiceLocator.getActionRequestService();
        ArrayList<ActionRequestValue> actionRequests = new ArrayList<ActionRequestValue>();
        Iterator<ActionRequestValue> iter = actionRequestService.findPendingByDoc(document.getDocumentId()).iterator();
        while (iter.hasNext()) {
            ActionRequestValue arv = (ActionRequestValue)this.deepCopy(iter.next());
            for (ActionItem actionItem : arv.getActionItems()) {
                arv.getSimulatedActionItems().add((ActionItem)this.deepCopy(actionItem));
            }
            actionRequests.add(arv);
        }
        LOG.debug((Object)"Simulate Deactivating all pending action requests");
        for (ActionRequestValue actionRequest : actionRequests) {
            if (user.getPrincipalId().equals(actionRequest.getPrincipalId()) && actionRequest.isActive()) {
                actionRequestService.deactivateRequest(actionTaken, actionRequest, routeContext.getActivationContext());
                continue;
            }
            if (!"-3".equals(actionRequest.getResponsibilityId())) continue;
            actionRequestService.deactivateRequest(actionTaken, actionRequest, routeContext.getActivationContext());
        }
        document.markDocumentEnroute();
    }

    private ActionTakenValue createDummyActionTaken(DocumentRouteHeaderValue routeHeader, Person userToPerformAction, String actionToPerform, Recipient delegator) {
        ActionTakenValue val = new ActionTakenValue();
        val.setActionTaken(actionToPerform);
        if ("O".equals(actionToPerform)) {
            val.setActionTaken("C");
        }
        val.setAnnotation("");
        val.setDocVersion(routeHeader.getDocVersion());
        val.setDocumentId(routeHeader.getDocumentId());
        val.setPrincipalId(userToPerformAction.getPrincipalId());
        if (delegator != null) {
            if (delegator instanceof KimPrincipalRecipient) {
                val.setDelegatorPrincipalId(((KimPrincipalRecipient)delegator).getPrincipalId());
            } else if (delegator instanceof KimGroupRecipient) {
                Group group = ((KimGroupRecipient)delegator).getGroup();
                val.setDelegatorGroupId(group.getId());
            } else {
                throw new IllegalArgumentException("Invalid Recipient type received: " + delegator.getClass().getName());
            }
        }
        val.setCurrentIndicator(Boolean.TRUE);
        return val;
    }

    private Recipient findDelegatorForActionRequests(List<ActionRequestValue> actionRequests) {
        return KEWServiceLocator.getActionRequestService().findDelegator(actionRequests);
    }

    @Override
    protected void saveNode(RouteContext context, RouteNodeInstance nodeInstance) {
        if (nodeInstance.getRouteNodeInstanceId() == null) {
            nodeInstance.setRouteNodeInstanceId(context.getEngineState().getNextSimulationId());
        }
        for (RouteNodeInstance routeNodeInstance : nodeInstance.getNextNodeInstances()) {
            if (routeNodeInstance.getRouteNodeInstanceId() != null) continue;
            routeNodeInstance.setRouteNodeInstanceId(context.getEngineState().getNextSimulationId());
        }
        if (nodeInstance.getProcess() != null && nodeInstance.getProcess().getRouteNodeInstanceId() == null) {
            nodeInstance.getProcess().setRouteNodeInstanceId(context.getEngineState().getNextSimulationId());
        }
        if (nodeInstance.getBranch() != null && nodeInstance.getBranch().getBranchId() == null) {
            nodeInstance.getBranch().setBranchId(context.getEngineState().getNextSimulationId());
        }
    }
}

