/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.group;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionlist.service.ActionListService;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.service.ActionRequestService;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.group.GroupMembershipChangeQueue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class GroupMembershipChangeQueueImpl
implements GroupMembershipChangeQueue {
    public void notifyMembershipChange(String operation, String groupId, String principalId) {
        if (StringUtils.isBlank((String)operation)) {
            throw new RiceIllegalArgumentException("operation was blank or null");
        }
        if (StringUtils.isBlank((String)groupId)) {
            throw new RiceIllegalArgumentException("groupId was blank or null");
        }
        if (StringUtils.isBlank((String)principalId)) {
            throw new RiceIllegalArgumentException("principalId was blank or null");
        }
        Principal principal = KimApiServiceLocator.getIdentityService().getPrincipal(principalId);
        if (principal == null) {
            throw new RiceRuntimeException("Could not locate the user for the given principal id '" + principalId + "'");
        }
        Group group = KimApiServiceLocator.getGroupService().getGroup(groupId);
        if (group == null) {
            throw new RiceRuntimeException("Could not locate the group with the given id '" + groupId + "'");
        }
        if ("ADDED".equalsIgnoreCase(operation)) {
            this.updateActionListForUserAddedToGroup(principalId, groupId);
        } else if ("REMOVED".equalsIgnoreCase(operation)) {
            this.updateActionListForUserRemovedFromGroup(principalId, groupId);
        } else {
            throw new WorkflowRuntimeException("Did not understand requested group membership change operation '" + operation + "'");
        }
    }

    private void updateActionListForUserAddedToGroup(String principalId, String groupId) {
        ArrayList actionRequests = new ArrayList();
        List parentGroupIds = KimApiServiceLocator.getGroupService().getParentGroupIds(groupId);
        ArrayList<String> allGroupsToCheck = new ArrayList<String>();
        allGroupsToCheck.add(0, groupId);
        allGroupsToCheck.addAll(parentGroupIds);
        for (String groupToCheckId : allGroupsToCheck) {
            actionRequests.addAll(this.getActionRequestService().findActivatedByGroup(groupToCheckId));
        }
        for (ActionRequestValue request : actionRequests) {
            ActionItem item = this.getActionListService().createActionItemForActionRequest(request);
            item.setPrincipalId(principalId);
            this.getActionListService().saveActionItem(item);
        }
    }

    private void updateActionListForUserRemovedFromGroup(String principalId, String groupId) {
        List parentGroupIds = KimApiServiceLocator.getGroupService().getParentGroupIds(groupId);
        ArrayList<String> allGroupsToCheck = new ArrayList<String>();
        allGroupsToCheck.add(0, groupId);
        allGroupsToCheck.addAll(parentGroupIds);
        Collection<ActionItem> actionItems = this.getActionListService().findByPrincipalId(principalId);
        for (ActionItem item : actionItems) {
            if (!item.isWorkgroupItem()) continue;
            for (String groupIdToCheck : allGroupsToCheck) {
                if (!item.getGroupId().equals(groupIdToCheck)) continue;
                this.getActionListService().deleteActionItem(item);
            }
        }
    }

    public ActionRequestService getActionRequestService() {
        return KEWServiceLocator.getActionRequestService();
    }

    public ActionListService getActionListService() {
        return KEWServiceLocator.getActionListService();
    }
}

