/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.peopleflow;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kew.actionrequest.ActionRequestFactory;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.KimGroupRecipient;
import org.kuali.rice.kew.actionrequest.KimPrincipalRecipient;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.DocumentContent;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowDefinition;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowDelegate;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowMember;
import org.kuali.rice.kew.api.repository.type.KewTypeDefinition;
import org.kuali.rice.kew.api.repository.type.KewTypeRepositoryService;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.framework.peopleflow.PeopleFlowTypeService;
import org.kuali.rice.kew.impl.peopleflow.PeopleFlowRequestGenerator;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValueContent;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleService;

public class PeopleFlowRequestGeneratorImpl
implements PeopleFlowRequestGenerator {
    private KewTypeRepositoryService typeRepositoryService;
    private RoleService roleService;

    @Override
    public List<ActionRequestValue> generateRequests(RouteContext routeContext, PeopleFlowDefinition peopleFlow, ActionRequestType actionRequested) {
        Context context = new Context(routeContext, peopleFlow, actionRequested);
        for (PeopleFlowMember member : peopleFlow.getMembers()) {
            this.generateRequestForMember(context, member);
        }
        return context.getActionRequestFactory().getRequestGraphs();
    }

    protected void generateRequestForMember(Context context, PeopleFlowMember member) {
        String actionRequestPolicyCode = null;
        if (member.getActionRequestPolicy() != null) {
            actionRequestPolicyCode = member.getActionRequestPolicy().getCode();
        }
        if (MemberType.ROLE == member.getMemberType()) {
            this.generateRequestForRoleMember(context, member, actionRequestPolicyCode);
        } else {
            ActionRequestValue actionRequest = context.getActionRequestFactory().addRootActionRequest(context.getActionRequested().getCode(), member.getPriority(), this.toRecipient(member), "", member.getResponsibilityId(), Boolean.TRUE, actionRequestPolicyCode, null);
            if (CollectionUtils.isNotEmpty((Collection)member.getDelegates())) {
                for (PeopleFlowDelegate delegate : member.getDelegates()) {
                    context.getActionRequestFactory().addDelegationRequest(actionRequest, this.toRecipient(delegate), delegate.getResponsibilityId(), Boolean.TRUE, delegate.getDelegationType(), "", null);
                }
            }
        }
    }

    protected void generateRequestForRoleMember(Context context, PeopleFlowMember member, String actionRequestPolicyCode) {
        Map<String, String> roleQualifiers = this.loadRoleQualifiers(context, member);
        Role role = this.getRoleService().getRole(member.getMemberId());
        if (role == null) {
            throw new IllegalStateException("Failed to locate a role with the given role id of '" + member.getMemberId() + "'");
        }
        List memberships = this.getRoleService().getRoleMembers(Collections.singletonList(member.getMemberId()), roleQualifiers);
        if (!CollectionUtils.isEmpty((Collection)memberships)) {
            context.getActionRequestFactory().addKimRoleRequest(context.getActionRequested().getCode(), member.getPriority(), role, memberships, null, member.getResponsibilityId(), true, actionRequestPolicyCode, null);
        }
    }

    protected Map<String, String> loadRoleQualifiers(Context context, PeopleFlowMember member) {
        PeopleFlowTypeService peopleFlowTypeService = context.getPeopleFlowTypeService();
        if (peopleFlowTypeService != null) {
            Document document = DocumentRouteHeaderValue.to(context.getRouteContext().getDocument());
            DocumentRouteHeaderValueContent content = new DocumentRouteHeaderValueContent(document.getDocumentId());
            content.setDocumentContent(context.getRouteContext().getDocumentContent().getDocContent());
            DocumentContent documentContent = DocumentRouteHeaderValueContent.to(content);
            Map roleQualifiers = peopleFlowTypeService.resolveRoleQualifiers(context.getPeopleFlow().getTypeId(), member.getMemberId(), document, documentContent);
            if (roleQualifiers != null) {
                return roleQualifiers;
            }
        }
        return Collections.emptyMap();
    }

    private Recipient toRecipient(PeopleFlowMember member) {
        Recipient recipient;
        if (MemberType.PRINCIPAL == member.getMemberType()) {
            recipient = new KimPrincipalRecipient(member.getMemberId());
        } else if (MemberType.GROUP == member.getMemberType()) {
            recipient = new KimGroupRecipient(member.getMemberId());
        } else {
            throw new IllegalStateException("encountered a member type which I did not understand: " + member.getMemberType());
        }
        return recipient;
    }

    private Recipient toRecipient(PeopleFlowDelegate delegate) {
        Recipient recipient;
        if (MemberType.PRINCIPAL == delegate.getMemberType()) {
            recipient = new KimPrincipalRecipient(delegate.getMemberId());
        } else if (MemberType.GROUP == delegate.getMemberType()) {
            recipient = new KimGroupRecipient(delegate.getMemberId());
        } else {
            throw new IllegalStateException("encountered a delegate member type which I did not understand: " + delegate.getMemberType());
        }
        return recipient;
    }

    public KewTypeRepositoryService getTypeRepositoryService() {
        return this.typeRepositoryService;
    }

    public void setTypeRepositoryService(KewTypeRepositoryService typeRepositoryService) {
        this.typeRepositoryService = typeRepositoryService;
    }

    public RoleService getRoleService() {
        return this.roleService;
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }

    final class Context {
        private final RouteContext routeContext;
        private final PeopleFlowDefinition peopleFlow;
        private final ActionRequestType actionRequested;
        private final ActionRequestFactory actionRequestFactory;
        private PeopleFlowTypeService peopleFlowTypeService;
        private boolean peopleFlowTypeServiceLoaded = false;

        Context(RouteContext routeContext, PeopleFlowDefinition peopleFlow, ActionRequestType actionRequested) {
            if (routeContext == null) {
                throw new IllegalArgumentException("routeContext was null");
            }
            if (peopleFlow == null) {
                throw new IllegalArgumentException("peopleFlow was null");
            }
            if (!peopleFlow.isActive()) {
                throw new ConfigurationException("Attempted to route to a PeopleFlow that is not active! " + peopleFlow);
            }
            if (actionRequested == null) {
                actionRequested = ActionRequestType.APPROVE;
            }
            this.routeContext = routeContext;
            this.peopleFlow = peopleFlow;
            this.actionRequested = actionRequested;
            this.actionRequestFactory = new ActionRequestFactory(routeContext);
        }

        RouteContext getRouteContext() {
            return this.routeContext;
        }

        PeopleFlowDefinition getPeopleFlow() {
            return this.peopleFlow;
        }

        ActionRequestType getActionRequested() {
            return this.actionRequested;
        }

        ActionRequestFactory getActionRequestFactory() {
            return this.actionRequestFactory;
        }

        PeopleFlowTypeService getPeopleFlowTypeService() {
            if (this.peopleFlowTypeServiceLoaded) {
                return this.peopleFlowTypeService;
            }
            if (this.getPeopleFlow().getTypeId() != null) {
                KewTypeDefinition typeDefinition = PeopleFlowRequestGeneratorImpl.this.getTypeRepositoryService().getTypeById(this.getPeopleFlow().getTypeId());
                if (typeDefinition == null) {
                    throw new IllegalStateException("Failed to locate a PeopleFlow type for the given type id of '" + this.getPeopleFlow().getTypeId() + "'");
                }
                if (StringUtils.isNotBlank((String)typeDefinition.getServiceName())) {
                    this.peopleFlowTypeService = (PeopleFlowTypeService)GlobalResourceLoader.getService((QName)QName.valueOf(typeDefinition.getServiceName()));
                    if (this.peopleFlowTypeService == null) {
                        throw new IllegalStateException("Failed to load the PeopleFlowTypeService with the name '" + typeDefinition.getServiceName() + "'");
                    }
                }
            }
            this.peopleFlowTypeServiceLoaded = true;
            return this.peopleFlowTypeService;
        }
    }
}

