/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.peopleflow;

import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowDefinition;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowDelegate;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowMember;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowService;
import org.kuali.rice.kew.api.repository.type.KewTypeDefinition;
import org.kuali.rice.kew.api.repository.type.KewTypeRepositoryService;
import org.kuali.rice.kew.impl.peopleflow.PeopleFlowBo;
import org.kuali.rice.kew.impl.peopleflow.PeopleFlowDelegateBo;
import org.kuali.rice.kew.impl.peopleflow.PeopleFlowMemberBo;
import org.kuali.rice.kew.responsibility.service.ResponsibilityIdService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class PeopleFlowServiceImpl
implements PeopleFlowService {
    private BusinessObjectService businessObjectService;
    private KewTypeRepositoryService kewTypeRepositoryService;
    private ResponsibilityIdService responsibilityIdService;

    public PeopleFlowDefinition getPeopleFlow(String peopleFlowId) {
        if (StringUtils.isBlank((String)peopleFlowId)) {
            throw new RiceIllegalArgumentException("peopleFlowId is null or blank");
        }
        return PeopleFlowBo.to((PeopleFlowBo)this.getPeopleFlowBo(peopleFlowId));
    }

    public PeopleFlowDefinition getPeopleFlowByName(String namespaceCode, String name) {
        if (StringUtils.isBlank((String)namespaceCode)) {
            throw new RiceIllegalArgumentException("namespaceCode is null or blank");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new RiceIllegalArgumentException("name is null or blank");
        }
        return PeopleFlowBo.to((PeopleFlowBo)this.getPeopleFlowBoByName(namespaceCode, name));
    }

    public PeopleFlowDefinition createPeopleFlow(PeopleFlowDefinition peopleFlow) {
        this.validateForCreate(peopleFlow);
        KewTypeDefinition kewTypeDefinition = this.loadKewTypeDefinition(peopleFlow);
        PeopleFlowBo peopleFlowBo = PeopleFlowBo.from((PeopleFlowDefinition)peopleFlow, (KewTypeDefinition)kewTypeDefinition);
        peopleFlowBo = this.savePeopleFlow(peopleFlowBo);
        return PeopleFlowBo.to((PeopleFlowBo)peopleFlowBo);
    }

    public PeopleFlowDefinition updatePeopleFlow(PeopleFlowDefinition peopleFlow) {
        PeopleFlowBo existingBo = this.validateForUpdate(peopleFlow);
        KewTypeDefinition kewTypeDefinition = this.loadKewTypeDefinition(peopleFlow);
        PeopleFlowBo peopleFlowBo = PeopleFlowBo.fromAndUpdate((PeopleFlowDefinition)peopleFlow, (KewTypeDefinition)kewTypeDefinition, (PeopleFlowBo)existingBo);
        peopleFlowBo = this.savePeopleFlow(peopleFlowBo);
        return PeopleFlowBo.to((PeopleFlowBo)peopleFlowBo);
    }

    protected KewTypeDefinition loadKewTypeDefinition(PeopleFlowDefinition peopleFlow) {
        KewTypeDefinition kewTypeDefinition = null;
        if (peopleFlow.getTypeId() != null && (kewTypeDefinition = this.getKewTypeRepositoryService().getTypeById(peopleFlow.getTypeId())) == null) {
            throw new RiceIllegalArgumentException("Failed to locate a KewTypeDefinition for the given type id of '" + peopleFlow.getTypeId() + "'");
        }
        return kewTypeDefinition;
    }

    protected void validateForCreate(PeopleFlowDefinition peopleFlow) {
        if (peopleFlow == null) {
            throw new RiceIllegalArgumentException("peopleFlow is null");
        }
        if (StringUtils.isNotBlank((String)peopleFlow.getId())) {
            throw new RiceIllegalArgumentException("Attempted to create a new PeopleFlow definition with a specified peopleFlowId of '" + peopleFlow.getId() + "'.  This is not allowed, when creating a new PeopleFlow definition, id must be null.");
        }
        if (peopleFlow.getVersionNumber() != null) {
            throw new RiceIllegalArgumentException("The version number on the given PeopleFlow definition was not null, value was " + peopleFlow.getVersionNumber() + "  When creating a new PeopleFlow, the given version number must be null.");
        }
        this.validatePeopleFlowMembersForCreate(peopleFlow);
        if (this.getPeopleFlowBoByName(peopleFlow.getNamespaceCode(), peopleFlow.getName()) != null) {
            throw new RiceIllegalStateException("A PeopleFlow definition with the namespace code '" + peopleFlow.getNamespaceCode() + "' and name '" + peopleFlow.getName() + "' already exists.");
        }
    }

    protected void validatePeopleFlowMembersForCreate(PeopleFlowDefinition peopleFlowDefinition) {
        for (PeopleFlowMember member : peopleFlowDefinition.getMembers()) {
            if (StringUtils.isNotBlank((String)member.getResponsibilityId())) {
                throw new RiceIllegalArgumentException("Attempted to create a new PeopleFlow with a member that already had a responsibility id of '" + member.getResponsibilityId() + "' specified.  All members must have a null responsibility id upon creation.");
            }
            for (PeopleFlowDelegate delegate : member.getDelegates()) {
                if (!StringUtils.isNotBlank((String)delegate.getResponsibilityId())) continue;
                throw new RiceIllegalArgumentException("Attempted to create a new PeopleFlow with a delegate that already had a responsibility id of '" + delegate.getResponsibilityId() + "' specified.  All delegates must have a null responsibility id upon creation.");
            }
        }
    }

    protected PeopleFlowBo validateForUpdate(PeopleFlowDefinition peopleFlow) {
        if (peopleFlow == null) {
            throw new RiceIllegalArgumentException("peopleFlow is null");
        }
        if (StringUtils.isBlank((String)peopleFlow.getId())) {
            throw new RiceIllegalArgumentException("Attempted to update a PeopleFlow definition without a specified peopleFlowId, the id is required when performing an update.");
        }
        if (peopleFlow.getVersionNumber() == null) {
            throw new RiceIllegalArgumentException("The version number on the given PeopleFlow definition was null, a version number must be supplied when updating a PeopleFlow.");
        }
        PeopleFlowBo peopleFlowBo = this.getPeopleFlowBo(peopleFlow.getId());
        if (peopleFlowBo == null) {
            throw new RiceIllegalArgumentException("Failed to locate an existing PeopleFlow definition with the given id of '" + peopleFlow.getId() + "'");
        }
        return peopleFlowBo;
    }

    protected PeopleFlowBo getPeopleFlowBo(String peopleFlowId) {
        if (StringUtils.isBlank((String)peopleFlowId)) {
            throw new RiceIllegalArgumentException("peopleFlowId was a null or blank value");
        }
        return (PeopleFlowBo)this.businessObjectService.findBySinglePrimaryKey(PeopleFlowBo.class, (Object)peopleFlowId);
    }

    protected PeopleFlowBo getPeopleFlowBoByName(String namespaceCode, String name) {
        if (StringUtils.isBlank((String)namespaceCode)) {
            throw new RiceIllegalArgumentException("namespaceCode was a null or blank value");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new RiceIllegalArgumentException("name was a null or blank value");
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("namespaceCode", namespaceCode);
        criteria.put("name", name);
        Collection peopleFlows = this.businessObjectService.findMatching(PeopleFlowBo.class, criteria);
        if (CollectionUtils.isEmpty((Collection)peopleFlows)) {
            return null;
        }
        if (peopleFlows.size() > 1) {
            throw new RiceIllegalStateException("Found more than one PeopleFlow with the given namespace code '" + namespaceCode + "' and name '" + name + "'");
        }
        return (PeopleFlowBo)peopleFlows.iterator().next();
    }

    protected PeopleFlowBo savePeopleFlow(PeopleFlowBo peopleFlowBo) {
        if (peopleFlowBo == null) {
            return null;
        }
        this.assignResponsibilityIds(peopleFlowBo);
        return (PeopleFlowBo)this.businessObjectService.save((PersistableBusinessObject)peopleFlowBo);
    }

    protected void assignResponsibilityIds(PeopleFlowBo peopleFlowBo) {
        if (CollectionUtils.isNotEmpty((Collection)peopleFlowBo.getMembers())) {
            for (PeopleFlowMemberBo memberBo : peopleFlowBo.getMembers()) {
                if (StringUtils.isBlank((String)memberBo.getResponsibilityId())) {
                    memberBo.setResponsibilityId(this.responsibilityIdService.getNewResponsibilityId());
                }
                if (!CollectionUtils.isNotEmpty((Collection)memberBo.getDelegates())) continue;
                for (PeopleFlowDelegateBo delegateBo : memberBo.getDelegates()) {
                    if (!StringUtils.isBlank((String)delegateBo.getResponsibilityId())) continue;
                    delegateBo.setResponsibilityId(this.responsibilityIdService.getNewResponsibilityId());
                }
            }
        }
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public KewTypeRepositoryService getKewTypeRepositoryService() {
        return this.kewTypeRepositoryService;
    }

    public void setKewTypeRepositoryService(KewTypeRepositoryService kewTypeRepositoryService) {
        this.kewTypeRepositoryService = kewTypeRepositoryService;
    }

    public ResponsibilityIdService getResponsibilityIdService() {
        return this.responsibilityIdService;
    }

    public void setResponsibilityIdService(ResponsibilityIdService responsibilityIdService) {
        this.responsibilityIdService = responsibilityIdService;
    }
}

