/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jws.WebParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.criteria.CriteriaLookupService;
import org.kuali.rice.core.api.criteria.GenericQueryResults;
import org.kuali.rice.core.api.criteria.LookupCustomizer;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;
import org.kuali.rice.kew.api.rule.Rule;
import org.kuali.rice.kew.api.rule.RuleContract;
import org.kuali.rice.kew.api.rule.RuleDelegation;
import org.kuali.rice.kew.api.rule.RuleQueryResults;
import org.kuali.rice.kew.api.rule.RuleReportCriteria;
import org.kuali.rice.kew.api.rule.RuleResponsibility;
import org.kuali.rice.kew.api.rule.RuleService;
import org.kuali.rice.kew.api.rule.RuleTemplate;
import org.kuali.rice.kew.api.rule.RuleTemplateContract;
import org.kuali.rice.kew.api.rule.RuleTemplateQueryResults;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.impl.common.attribute.AttributeTransform;
import org.kuali.rice.krad.service.BusinessObjectService;

public class RuleServiceImpl
implements RuleService {
    private static final Logger LOG = Logger.getLogger(RuleServiceImpl.class);
    private BusinessObjectService businessObjectService;
    private CriteriaLookupService criteriaLookupService;

    public Rule getRule(String id) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck("id", id);
        Map<String, String> criteria = Collections.singletonMap("id", id);
        RuleBaseValues rbv = (RuleBaseValues)this.businessObjectService.findByPrimaryKey(RuleBaseValues.class, criteria);
        if (rbv == null) {
            throw new RiceIllegalStateException("Rule with specified id: " + id + " does not exist");
        }
        return RuleBaseValues.to(rbv);
    }

    public Rule getRuleByName(String name) {
        this.incomingParamCheck("name", name);
        HashMap<String, Object> criteria = new HashMap<String, Object>(2);
        criteria.put("name", name);
        criteria.put("currentInd", Boolean.TRUE);
        RuleBaseValues rbv = (RuleBaseValues)this.businessObjectService.findByPrimaryKey(RuleBaseValues.class, criteria);
        if (rbv == null) {
            throw new RiceIllegalStateException("Rule with specified name: " + name + " does not exist");
        }
        return RuleBaseValues.to(rbv);
    }

    public List<Rule> getRulesByTemplateId(@WebParam(name="templateId") String templateId) throws RiceIllegalArgumentException {
        this.incomingParamCheck("templateId", templateId);
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("ruleTemplateId", templateId);
        criteria.put("currentInd", Boolean.TRUE);
        Collection ruleValues = this.businessObjectService.findMatching(RuleBaseValues.class, criteria);
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (RuleBaseValues bo : ruleValues) {
            rules.add(Rule.Builder.create((RuleContract)bo).build());
        }
        return rules;
    }

    public List<Rule> getRulesByTemplateNameAndDocumentTypeName(String templateName, String documentTypeName) {
        return this.getRulesByTemplateNameAndDocumentTypeNameAndEffectiveDate(templateName, documentTypeName, null);
    }

    public List<Rule> getRulesByTemplateNameAndDocumentTypeNameAndEffectiveDate(String templateName, String documentTypeName, DateTime effectiveDate) throws RiceIllegalArgumentException {
        QueryByCriteria.Builder query = QueryByCriteria.Builder.create();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(PredicateFactory.equal((String)"ruleTemplate.name", (Object)templateName));
        DocumentTypeService documentTypeService = KewApiServiceLocator.getDocumentTypeService();
        DocumentType dt = documentTypeService.getDocumentTypeByName(documentTypeName);
        ArrayList<String> documentTypeAncestryNames = new ArrayList<String>();
        while (dt != null) {
            documentTypeAncestryNames.add(dt.getName());
            dt = dt.getParentId() == null ? null : documentTypeService.getDocumentTypeById(dt.getParentId());
        }
        predicates.add(PredicateFactory.in((String)"docTypeName", (Object[])documentTypeAncestryNames.toArray(new String[documentTypeAncestryNames.size()])));
        DateTime currentTime = new DateTime();
        predicates.add(PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.isNull((String)"fromDateValue"), PredicateFactory.lessThanOrEqual((String)"fromDateValue", (Object)currentTime)}), PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.isNull((String)"toDateValue"), PredicateFactory.greaterThan((String)"toDateValue", (Object)currentTime)})}));
        predicates.add(PredicateFactory.equal((String)"active", (Object)new Integer(1)));
        predicates.add(PredicateFactory.equal((String)"delegateRule", (Object)new Integer(0)));
        predicates.add(PredicateFactory.equal((String)"templateRuleInd", (Object)new Integer(0)));
        if (effectiveDate != null) {
            predicates.add(PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.isNull((String)"activationDate"), PredicateFactory.lessThanOrEqual((String)"activationDate", (Object)effectiveDate)}), PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.isNull((String)"deactivationDate"), PredicateFactory.greaterThan((String)"deactivationDate", (Object)effectiveDate)})}));
        } else {
            predicates.add(PredicateFactory.equal((String)"currentInd", (Object)new Integer(1)));
        }
        Predicate p = PredicateFactory.and((Predicate[])predicates.toArray(new Predicate[0]));
        query.setPredicates(new Predicate[]{p});
        return KewApiServiceLocator.getRuleService().findRules(query.build()).getResults();
    }

    public RuleQueryResults findRules(QueryByCriteria queryByCriteria) {
        if (queryByCriteria == null) {
            throw new RiceIllegalArgumentException("queryByCriteria is null");
        }
        LookupCustomizer.Builder lc = LookupCustomizer.Builder.create();
        lc.setPredicateTransform(AttributeTransform.getInstance());
        GenericQueryResults results = this.criteriaLookupService.lookup(RuleBaseValues.class, queryByCriteria, lc.build());
        RuleQueryResults.Builder builder = RuleQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<Rule.Builder> ims = new ArrayList<Rule.Builder>();
        for (RuleBaseValues bo : results.getResults()) {
            ims.add(Rule.Builder.create((RuleContract)RuleBaseValues.to(bo)));
        }
        builder.setResults(ims);
        return builder.build();
    }

    public List<Rule> ruleReport(RuleReportCriteria ruleReportCriteria) {
        this.incomingParamCheck(ruleReportCriteria, "ruleReportCriteria");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Executing rule report [responsibleUser=" + ruleReportCriteria.getResponsiblePrincipalId() + ", responsibleWorkgroup=" + ruleReportCriteria.getResponsibleGroupId() + "]"));
        }
        List<RuleBaseValues> rulesFound = KEWServiceLocator.getRuleService().searchByTemplate(ruleReportCriteria.getDocumentTypeName(), ruleReportCriteria.getRuleTemplateName(), ruleReportCriteria.getRuleDescription(), ruleReportCriteria.getResponsibleGroupId(), ruleReportCriteria.getResponsiblePrincipalId(), ruleReportCriteria.isConsiderGroupMembership(), ruleReportCriteria.isIncludeDelegations(), ruleReportCriteria.isActive(), ruleReportCriteria.getRuleExtensions(), ruleReportCriteria.getActionRequestCodes());
        ArrayList<Rule> returnableRules = new ArrayList<Rule>(rulesFound.size());
        for (RuleBaseValues rule : rulesFound) {
            returnableRules.add(RuleBaseValues.to(rule));
        }
        return returnableRules;
    }

    public RuleTemplate getRuleTemplate(@WebParam(name="id") String id) {
        this.incomingParamCheck("id", id);
        Map<String, String> criteria = Collections.singletonMap("id", id);
        RuleTemplateBo template = (RuleTemplateBo)this.businessObjectService.findByPrimaryKey(RuleTemplateBo.class, criteria);
        if (template == null) {
            throw new RiceIllegalStateException("RuleTemplate with specified id: " + id + " does not exist");
        }
        return RuleTemplateBo.to(template);
    }

    public RuleTemplate getRuleTemplateByName(@WebParam(name="name") String name) {
        this.incomingParamCheck("name", name);
        HashMap<String, String> criteria = new HashMap<String, String>(2);
        criteria.put("name", name);
        RuleTemplateBo template = (RuleTemplateBo)this.businessObjectService.findByPrimaryKey(RuleTemplateBo.class, criteria);
        if (template == null) {
            throw new RiceIllegalStateException("RuleTemplate with specified name: " + name + " does not exist");
        }
        return RuleTemplateBo.to(template);
    }

    public RuleTemplateQueryResults findRuleTemplates(@WebParam(name="query") QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        if (queryByCriteria == null) {
            throw new RiceIllegalArgumentException("queryByCriteria is null");
        }
        LookupCustomizer.Builder lc = LookupCustomizer.Builder.create();
        lc.setPredicateTransform(AttributeTransform.getInstance());
        GenericQueryResults results = this.criteriaLookupService.lookup(RuleTemplateBo.class, queryByCriteria, lc.build());
        RuleTemplateQueryResults.Builder builder = RuleTemplateQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<RuleTemplate.Builder> ims = new ArrayList<RuleTemplate.Builder>();
        for (RuleTemplateBo bo : results.getResults()) {
            ims.add(RuleTemplate.Builder.create((RuleTemplateContract)RuleTemplateBo.to(bo)));
        }
        builder.setResults(ims);
        return builder.build();
    }

    public RuleResponsibility getRuleResponsibility(String responsibilityId) {
        this.incomingParamCheck("responsibilityId", responsibilityId);
        Map<String, String> criteria = Collections.singletonMap("responsibilityId", responsibilityId);
        RuleResponsibilityBo responsibility = (RuleResponsibilityBo)this.businessObjectService.findByPrimaryKey(RuleResponsibilityBo.class, criteria);
        if (responsibility == null) {
            throw new RiceIllegalStateException("RuleResponsibility with specified id: " + responsibilityId + " does not exist");
        }
        return RuleResponsibilityBo.to(responsibility);
    }

    public List<RuleDelegation> getRuleDelegationsByResponsibiltityId(@WebParam(name="id") String id) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck("id", id);
        HashMap<String, Object> criteria = new HashMap<String, Object>(2);
        criteria.put("responsibilityId", id);
        criteria.put("delegationRule.currentInd", Boolean.TRUE);
        Collection delegations = this.businessObjectService.findMatching(RuleDelegationBo.class, criteria);
        ArrayList<RuleDelegation> ruleDelegations = new ArrayList<RuleDelegation>();
        if (CollectionUtils.isNotEmpty((Collection)delegations)) {
            for (RuleDelegationBo bo : delegations) {
                ruleDelegations.add(RuleDelegationBo.to(bo));
            }
        }
        return ruleDelegations;
    }

    private void incomingParamCheck(Object object, String name) {
        if (object == null) {
            throw new RiceIllegalArgumentException(name + " was null");
        }
        if (object instanceof String && StringUtils.isBlank((String)((String)object))) {
            throw new RiceIllegalArgumentException(name + " was blank");
        }
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public CriteriaLookupService getCriteriaLookupService() {
        return this.criteriaLookupService;
    }

    public void setCriteriaLookupService(CriteriaLookupService criteriaLookupService) {
        this.criteriaLookupService = criteriaLookupService;
    }
}

