/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.preferences.web;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kew.api.preferences.Preferences;
import org.kuali.rice.kew.preferences.web.PreferencesConstants;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.util.GlobalVariables;

public class PreferencesForm
extends KualiForm {
    private static final long serialVersionUID = 4536869031291955777L;
    private static final String ERR_KEY_REFRESH_RATE_WHOLE_NUM = "preferences.refreshRate";
    private static final String ERR_KEY_ACTION_LIST_PAGE_SIZE_WHOLE_NUM = "preferences.pageSize";
    private Preferences.Builder preferences = Preferences.Builder.create();
    private String methodToCall = "";
    private String returnMapping;
    private boolean showOutbox = true;
    private String documentTypePreferenceName;
    private String documentTypePreferenceValue;
    private String backLocation;

    public String getReturnMapping() {
        return this.returnMapping;
    }

    public void setReturnMapping(String returnMapping) {
        this.returnMapping = returnMapping;
    }

    public String getMethodToCall() {
        return this.methodToCall;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setMethodToCall(String methodToCall) {
        Pattern p = Pattern.compile("\\w");
        if (!StringUtils.isBlank((String)methodToCall)) {
            Matcher m = p.matcher(methodToCall);
            if (!m.find()) throw new RiceRuntimeException("invalid characters found in the parameter methodToCall");
            this.methodToCall = methodToCall;
            return;
        } else {
            this.methodToCall = methodToCall;
        }
    }

    public Preferences.Builder getPreferences() {
        return this.preferences;
    }

    public void setPreferences(Preferences.Builder preferences) {
        this.preferences = preferences;
    }

    public boolean isShowOutbox() {
        return this.showOutbox;
    }

    public void setShowOutbox(boolean showOutbox) {
        this.showOutbox = showOutbox;
    }

    public String getBackLocation() {
        return this.backLocation;
    }

    public void setBackLocation(String backLocation) {
        this.backLocation = backLocation;
    }

    public String getDocumentTypePreferenceName() {
        return this.documentTypePreferenceName;
    }

    public void setDocumentTypePreferenceName(String documentTypePreferenceName) {
        this.documentTypePreferenceName = documentTypePreferenceName;
    }

    public String getDocumentTypePreferenceValue() {
        return this.documentTypePreferenceValue;
    }

    public void setDocumentTypePreferenceValue(String documentTypePreferenceValue) {
        this.documentTypePreferenceValue = documentTypePreferenceValue;
    }

    public Object getDocumentTypeNotificationPreference(String documentType) {
        return this.preferences.getDocumentTypeNotificationPreference(documentType);
    }

    public void setDocumentTypeNotificationPreference(String documentType, String preferenceValue) {
        this.preferences.addDocumentTypeNotificationPreference(documentType, preferenceValue);
    }

    public void populate(HttpServletRequest request) {
        super.populate(request);
        if (this.getParameter(request, "returnLocation") != null) {
            String returnLocation = this.getParameter(request, "returnLocation");
            if (returnLocation.contains(">") || returnLocation.contains("<") || returnLocation.contains("\"")) {
                returnLocation = returnLocation.replaceAll("\"", "%22");
                returnLocation = returnLocation.replaceAll("<", "%3C");
                returnLocation = returnLocation.replaceAll(">", "%3E");
            }
            this.setBackLocation(returnLocation);
        }
    }

    public void validatePreferences() {
        if (!(PreferencesConstants.PreferencesDocumentRouteStatusColors.getPreferencesDocumentRouteStatusColors().contains(this.preferences.getColorSaved()) && PreferencesConstants.PreferencesDocumentRouteStatusColors.getPreferencesDocumentRouteStatusColors().contains(this.preferences.getColorInitiated()) && PreferencesConstants.PreferencesDocumentRouteStatusColors.getPreferencesDocumentRouteStatusColors().contains(this.preferences.getColorDisapproved()) && PreferencesConstants.PreferencesDocumentRouteStatusColors.getPreferencesDocumentRouteStatusColors().contains(this.preferences.getColorEnroute()) && PreferencesConstants.PreferencesDocumentRouteStatusColors.getPreferencesDocumentRouteStatusColors().contains(this.preferences.getColorApproved()) && PreferencesConstants.PreferencesDocumentRouteStatusColors.getPreferencesDocumentRouteStatusColors().contains(this.preferences.getColorFinal()) && PreferencesConstants.PreferencesDocumentRouteStatusColors.getPreferencesDocumentRouteStatusColors().contains(this.preferences.getColorProcessed()) && PreferencesConstants.PreferencesDocumentRouteStatusColors.getPreferencesDocumentRouteStatusColors().contains(this.preferences.getColorException()) && PreferencesConstants.PreferencesDocumentRouteStatusColors.getPreferencesDocumentRouteStatusColors().contains(this.preferences.getColorCanceled()))) {
            throw new RiceRuntimeException("Preferences cannot be saved since they have been tampered with. Please refresh the page and try again");
        }
        if (!PreferencesConstants.EmailNotificationPreferences.getEmailNotificationPreferences().contains(this.preferences.getEmailNotification())) {
            throw new RiceRuntimeException("Email notifications cannot be saved since they have been tampered with. Please refresh the page and try again");
        }
        if (!PreferencesConstants.DelegatorFilterValues.getDelegatorFilterValues().contains(this.preferences.getDelegatorFilter())) {
            throw new RiceRuntimeException("Delegator filter values cannot be saved since they have been tampered with. Please refresh the page and try again");
        }
        if (!PreferencesConstants.PrimaryDelegateFilterValues.getPrimaryDelegateFilterValues().contains(this.preferences.getPrimaryDelegateFilter())) {
            throw new RiceRuntimeException("Primary delegator filter values cannot be saved since they have been tampered with. Please refresh the page and try again");
        }
        if (!StringUtils.isBlank((String)this.preferences.getNotifyPrimaryDelegation()) && !PreferencesConstants.CheckBoxValues.getCheckBoxValues().contains(this.preferences.getNotifyPrimaryDelegation())) {
            throw new RiceRuntimeException("Invalid value found for checkbox \"Recieve Primary Delegate Email\"");
        }
        if (!StringUtils.isBlank((String)this.preferences.getNotifySecondaryDelegation()) && !PreferencesConstants.CheckBoxValues.getCheckBoxValues().contains(this.preferences.getNotifySecondaryDelegation())) {
            throw new RiceRuntimeException("Invalid value found for checkbox \"Recieve Secondary Delegate Email\"");
        }
        if (!StringUtils.isBlank((String)this.preferences.getShowDocType()) && !PreferencesConstants.CheckBoxValues.getCheckBoxValues().contains(this.preferences.getShowDocType()) || !StringUtils.isBlank((String)this.preferences.getShowDocTitle()) && !PreferencesConstants.CheckBoxValues.getCheckBoxValues().contains(this.preferences.getShowDocTitle()) || !StringUtils.isBlank((String)this.preferences.getShowActionRequested()) && !PreferencesConstants.CheckBoxValues.getCheckBoxValues().contains(this.preferences.getShowActionRequested()) || !StringUtils.isBlank((String)this.preferences.getShowInitiator()) && !PreferencesConstants.CheckBoxValues.getCheckBoxValues().contains(this.preferences.getShowInitiator()) || !StringUtils.isBlank((String)this.preferences.getShowDelegator()) && !PreferencesConstants.CheckBoxValues.getCheckBoxValues().contains(this.preferences.getShowDelegator()) || !StringUtils.isBlank((String)this.preferences.getShowDateCreated()) && !PreferencesConstants.CheckBoxValues.getCheckBoxValues().contains(this.preferences.getShowDateCreated()) || !StringUtils.isBlank((String)this.preferences.getShowDateApproved()) && !PreferencesConstants.CheckBoxValues.getCheckBoxValues().contains(this.preferences.getShowDateApproved()) || !StringUtils.isBlank((String)this.preferences.getShowCurrentNode()) && !PreferencesConstants.CheckBoxValues.getCheckBoxValues().contains(this.preferences.getShowCurrentNode()) || !StringUtils.isBlank((String)this.preferences.getShowWorkgroupRequest()) && !PreferencesConstants.CheckBoxValues.getCheckBoxValues().contains(this.preferences.getShowWorkgroupRequest()) || !StringUtils.isBlank((String)this.preferences.getShowDocumentStatus()) && !PreferencesConstants.CheckBoxValues.getCheckBoxValues().contains(this.preferences.getShowDocumentStatus()) || !StringUtils.isBlank((String)this.preferences.getShowClearFyi()) && !PreferencesConstants.CheckBoxValues.getCheckBoxValues().contains(this.preferences.getShowClearFyi()) || !StringUtils.isBlank((String)this.preferences.getUseOutbox()) && !PreferencesConstants.CheckBoxValues.getCheckBoxValues().contains(this.preferences.getUseOutbox())) {
            throw new RiceRuntimeException("Preferences for fields displayed in action list cannot be saved since they have in tampered with. Please refresh the page and try again");
        }
        try {
            new Integer(this.preferences.getRefreshRate().trim());
        }
        catch (NumberFormatException e) {
            GlobalVariables.getMessageMap().putError(ERR_KEY_REFRESH_RATE_WHOLE_NUM, "general.message", new String[]{"ActionList Refresh Rate must be in whole minutes"});
        }
        catch (NullPointerException e1) {
            GlobalVariables.getMessageMap().putError(ERR_KEY_REFRESH_RATE_WHOLE_NUM, "general.message", new String[]{"ActionList Refresh Rate must be in whole minutes"});
        }
        try {
            new Integer(this.preferences.getPageSize().trim());
            if (new Integer(this.preferences.getPageSize().trim()) <= 0 || new Integer(this.preferences.getPageSize().trim()) > 500) {
                GlobalVariables.getMessageMap().putError(ERR_KEY_ACTION_LIST_PAGE_SIZE_WHOLE_NUM, "general.message", new String[]{"ActionList Page Size must be between 1 and 500"});
            }
        }
        catch (NumberFormatException e) {
            GlobalVariables.getMessageMap().putError(ERR_KEY_ACTION_LIST_PAGE_SIZE_WHOLE_NUM, "general.message", new String[]{"ActionList Page Size must be in whole minutes"});
        }
        catch (NullPointerException e1) {
            GlobalVariables.getMessageMap().putError(ERR_KEY_ACTION_LIST_PAGE_SIZE_WHOLE_NUM, "general.message", new String[]{"ActionList Page Size must be in whole minutes"});
        }
        if (GlobalVariables.getMessageMap().hasErrors()) {
            throw new ValidationException("errors in preferences");
        }
    }
}

