/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.routeheader;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionlist.CustomActionListAttribute;
import org.kuali.rice.kew.actionlist.DefaultCustomActionListAttribute;
import org.kuali.rice.kew.actionrequest.ActionRequestFactory;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.DocumentContract;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.document.DocumentUpdate;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.api.util.CodeTranslator;
import org.kuali.rice.kew.docsearch.DocumentSearchCriteriaEbo;
import org.kuali.rice.kew.docsearch.SearchableAttributeValue;
import org.kuali.rice.kew.doctype.ApplicationDocumentStatus;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.CompatUtils;
import org.kuali.rice.kew.engine.node.Branch;
import org.kuali.rice.kew.engine.node.BranchState;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.mail.CustomEmailAttribute;
import org.kuali.rice.kew.mail.CustomEmailAttributeImpl;
import org.kuali.rice.kew.notes.CustomNoteAttribute;
import org.kuali.rice.kew.notes.CustomNoteAttributeImpl;
import org.kuali.rice.kew.notes.Note;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValueContent;
import org.kuali.rice.kew.routeheader.DocumentStatusTransition;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;

@Entity
@Table(name="KREW_DOC_HDR_T")
@NamedQueries(value={@NamedQuery(name="DocumentRouteHeaderValue.FindByDocumentId", query="select d from DocumentRouteHeaderValue as d where d.documentId = :documentId"), @NamedQuery(name="DocumentRouteHeaderValue.QuickLinks.FindWatchedDocumentsByInitiatorWorkflowId", query="SELECT NEW org.kuali.rice.kew.quicklinks.WatchedDocument(documentId, docRouteStatus, docTitle) FROM DocumentRouteHeaderValue WHERE initiatorWorkflowId = :initiatorWorkflowId AND docRouteStatus IN ('R','E') ORDER BY createDate DESC"), @NamedQuery(name="DocumentRouteHeaderValue.GetAppDocId", query="SELECT d.appDocId from DocumentRouteHeaderValue as d where d.documentId = :documentId"), @NamedQuery(name="DocumentRouteHeaderValue.GetAppDocStatus", query="SELECT d.appDocStatus from DocumentRouteHeaderValue as d where d.documentId = :documentId")})
public class DocumentRouteHeaderValue
extends PersistableBusinessObjectBase
implements DocumentContract,
DocumentSearchCriteriaEbo {
    private static final long serialVersionUID = -4700736340527913220L;
    private static final Logger LOG = Logger.getLogger(DocumentRouteHeaderValue.class);
    public static final String CURRENT_ROUTE_NODE_NAME_DELIMITER = ", ";
    @Column(name="DOC_TYP_ID")
    private String documentTypeId;
    @Column(name="DOC_HDR_STAT_CD")
    private String docRouteStatus;
    @Column(name="RTE_LVL")
    private Integer docRouteLevel;
    @Column(name="STAT_MDFN_DT")
    private Timestamp dateModified;
    @Column(name="CRTE_DT")
    private Timestamp createDate;
    @Column(name="APRV_DT")
    private Timestamp approvedDate;
    @Column(name="FNL_DT")
    private Timestamp finalizedDate;
    @Transient
    private DocumentRouteHeaderValueContent documentContent;
    @Column(name="TTL")
    private String docTitle;
    @Column(name="APP_DOC_ID")
    private String appDocId;
    @Column(name="DOC_VER_NBR")
    private Integer docVersion = new Integer(1);
    @Column(name="INITR_PRNCPL_ID")
    private String initiatorWorkflowId;
    @Column(name="RTE_PRNCPL_ID")
    private String routedByUserWorkflowId;
    @Column(name="RTE_STAT_MDFN_DT")
    private Timestamp routeStatusDate;
    @Column(name="APP_DOC_STAT")
    private String appDocStatus;
    @Column(name="APP_DOC_STAT_MDFN_DT")
    private Timestamp appDocStatusDate;
    @Id
    @GeneratedValue(generator="KREW_DOC_HDR_S")
    @GenericGenerator(name="KREW_DOC_HDR_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KREW_DOC_HDR_S"), @Parameter(name="value_column", value="id")})
    @Column(name="DOC_HDR_ID")
    private String documentId;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE}, mappedBy="documentId")
    @OrderBy(value="statusTransitionId ASC")
    @Fetch(value=FetchMode.SELECT)
    private List<DocumentStatusTransition> appDocStatusHistory = new ArrayList<DocumentStatusTransition>();
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.REMOVE})
    @JoinColumn(name="DOC_HDR_ID")
    @OrderBy(value="noteId ASC")
    private List<Note> notes = new ArrayList<Note>();
    @Transient
    private List<SearchableAttributeValue> searchableAttributeValues = new ArrayList<SearchableAttributeValue>();
    @Transient
    private Collection queueItems = new ArrayList();
    @Transient
    private boolean routingReport = false;
    @Transient
    private List<ActionRequestValue> simulatedActionRequests;
    private static final boolean FINAL_STATE = true;
    protected static final HashMap<String, String> legalActions;
    protected static final HashMap<String, String> stateTransitionMap;
    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.REMOVE})
    @JoinTable(name="KREW_INIT_RTE_NODE_INSTN_T", joinColumns={@JoinColumn(name="DOC_HDR_ID")}, inverseJoinColumns={@JoinColumn(name="RTE_NODE_INSTN_ID")})
    @Fetch(value=FetchMode.SELECT)
    private List<RouteNodeInstance> initialRouteNodeInstances = new ArrayList<RouteNodeInstance>();
    private static final String TERMINAL = "";

    public Principal getInitiatorPrincipal() {
        if (this.getInitiatorWorkflowId() == null) {
            return null;
        }
        return KEWServiceLocator.getIdentityHelperService().getPrincipal(this.getInitiatorWorkflowId());
    }

    public Principal getRoutedByPrincipal() {
        if (this.getRoutedByUserWorkflowId() == null) {
            return null;
        }
        return KEWServiceLocator.getIdentityHelperService().getPrincipal(this.getRoutedByUserWorkflowId());
    }

    public String getInitiatorDisplayName() {
        return KEWServiceLocator.getIdentityHelperService().getPerson(this.getInitiatorWorkflowId()).getName();
    }

    public String getRoutedByDisplayName() {
        return KEWServiceLocator.getIdentityHelperService().getPerson(this.getRoutedByUserWorkflowId()).getName();
    }

    public String getCurrentRouteLevelName() {
        String name = "Not Found";
        if (this.routingReport) {
            name = "Routing Report";
        } else if (CompatUtils.isRouteLevelDocument(this)) {
            int routeLevelInt = this.getDocRouteLevel();
            LOG.info((Object)("Getting current route level name for a Route level document: " + routeLevelInt + CURRENT_ROUTE_NODE_NAME_DELIMITER + this.documentId));
            List<RouteNode> routeLevelNodes = CompatUtils.getRouteLevelCompatibleNodeList(this.getDocumentType());
            LOG.info((Object)("Route level compatible node list has " + routeLevelNodes.size() + " nodes"));
            if (routeLevelInt < routeLevelNodes.size()) {
                name = routeLevelNodes.get(routeLevelInt).getRouteNodeName();
            }
        } else {
            List<String> currentNodeNames = this.getCurrentNodeNames();
            name = StringUtils.join(currentNodeNames, (String)CURRENT_ROUTE_NODE_NAME_DELIMITER);
        }
        return name;
    }

    public List<String> getCurrentNodeNames() {
        return KEWServiceLocator.getRouteNodeService().getCurrentRouteNodeNames(this.getDocumentId());
    }

    public String getRouteStatusLabel() {
        return CodeTranslator.getRouteStatusLabel((String)this.getDocRouteStatus());
    }

    public String getDocRouteStatusLabel() {
        return CodeTranslator.getRouteStatusLabel((String)this.getDocRouteStatus());
    }

    public String getDocStatusPolicy() {
        return this.getDocumentType().getDocumentStatusPolicy().getPolicyStringValue();
    }

    public Collection getQueueItems() {
        return this.queueItems;
    }

    public void setQueueItems(Collection queueItems) {
        this.queueItems = queueItems;
    }

    public List<ActionItem> getActionItems() {
        return (List)KEWServiceLocator.getActionListService().findByDocumentId(this.documentId);
    }

    public List<ActionTakenValue> getActionsTaken() {
        return KEWServiceLocator.getActionTakenService().findByDocumentIdIgnoreCurrentInd(this.documentId);
    }

    public List<ActionRequestValue> getActionRequests() {
        if (this.simulatedActionRequests == null || this.simulatedActionRequests.isEmpty()) {
            return KEWServiceLocator.getActionRequestService().findByDocumentIdIgnoreCurrentInd(this.documentId);
        }
        return this.simulatedActionRequests;
    }

    public List<ActionRequestValue> getSimulatedActionRequests() {
        if (this.simulatedActionRequests == null) {
            this.simulatedActionRequests = new ArrayList<ActionRequestValue>();
        }
        return this.simulatedActionRequests;
    }

    public void setSimulatedActionRequests(List<ActionRequestValue> simulatedActionRequests) {
        this.simulatedActionRequests = simulatedActionRequests;
    }

    public DocumentType getDocumentType() {
        return KEWServiceLocator.getDocumentTypeService().findById(this.getDocumentTypeId());
    }

    public String getAppDocId() {
        return this.appDocId;
    }

    public void setAppDocId(String appDocId) {
        this.appDocId = appDocId;
    }

    public Timestamp getApprovedDate() {
        return this.approvedDate;
    }

    public void setApprovedDate(Timestamp approvedDate) {
        this.approvedDate = approvedDate;
    }

    public Timestamp getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Timestamp createDate) {
        this.createDate = createDate;
    }

    public String getDocContent() {
        return this.getDocumentContent().getDocumentContent();
    }

    public void setDocContent(String docContent) {
        DocumentRouteHeaderValueContent content = this.getDocumentContent();
        content.setDocumentContent(docContent);
    }

    public Integer getDocRouteLevel() {
        return this.docRouteLevel;
    }

    public void setDocRouteLevel(Integer docRouteLevel) {
        this.docRouteLevel = docRouteLevel;
    }

    public String getDocRouteStatus() {
        return this.docRouteStatus;
    }

    public void setDocRouteStatus(String docRouteStatus) {
        this.docRouteStatus = docRouteStatus;
    }

    public String getDocTitle() {
        return this.docTitle;
    }

    public void setDocTitle(String docTitle) {
        this.docTitle = docTitle;
    }

    public String getDocumentTypeId() {
        return this.documentTypeId;
    }

    public void setDocumentTypeId(String documentTypeId) {
        this.documentTypeId = documentTypeId;
    }

    public Integer getDocVersion() {
        return this.docVersion;
    }

    public void setDocVersion(Integer docVersion) {
        this.docVersion = docVersion;
    }

    public Timestamp getFinalizedDate() {
        return this.finalizedDate;
    }

    public void setFinalizedDate(Timestamp finalizedDate) {
        this.finalizedDate = finalizedDate;
    }

    public String getInitiatorWorkflowId() {
        return this.initiatorWorkflowId;
    }

    public void setInitiatorWorkflowId(String initiatorWorkflowId) {
        this.initiatorWorkflowId = initiatorWorkflowId;
    }

    public String getRoutedByUserWorkflowId() {
        if (this.isEnroute() && StringUtils.isBlank((String)this.routedByUserWorkflowId)) {
            return this.initiatorWorkflowId;
        }
        return this.routedByUserWorkflowId;
    }

    public void setRoutedByUserWorkflowId(String routedByUserWorkflowId) {
        this.routedByUserWorkflowId = routedByUserWorkflowId;
    }

    @Override
    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public Timestamp getRouteStatusDate() {
        return this.routeStatusDate;
    }

    public void setRouteStatusDate(Timestamp routeStatusDate) {
        this.routeStatusDate = routeStatusDate;
    }

    public Timestamp getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Timestamp dateModified) {
        this.dateModified = dateModified;
    }

    public String getAppDocStatus() {
        if (this.appDocStatus == null || TERMINAL.equals(this.appDocStatus)) {
            return KewApiConstants.UNKNOWN_STATUS;
        }
        return this.appDocStatus;
    }

    public void setAppDocStatus(String appDocStatus) {
        this.appDocStatus = appDocStatus;
    }

    public String getCombinedStatus() {
        String routeStatus = this.getRouteStatusLabel();
        String appStatus = this.getAppDocStatus();
        if (routeStatus != null && routeStatus.length() > 0) {
            if (appStatus.length() > 0) {
                routeStatus = routeStatus + CURRENT_ROUTE_NODE_NAME_DELIMITER + appStatus;
            }
        } else {
            return appStatus;
        }
        return routeStatus;
    }

    public void updateAppDocStatus(String appDocStatus) throws WorkflowRuntimeException {
        if (appDocStatus != null && appDocStatus.length() > 0 && !appDocStatus.equalsIgnoreCase(this.appDocStatus)) {
            DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findById(this.getDocumentTypeId());
            if (documentType.getValidApplicationStatuses() != null && documentType.getValidApplicationStatuses().size() > 0) {
                Iterator<ApplicationDocumentStatus> iter = documentType.getValidApplicationStatuses().iterator();
                boolean statusValidated = false;
                while (iter.hasNext()) {
                    ApplicationDocumentStatus myAppDocStat = iter.next();
                    if (appDocStatus.compareToIgnoreCase(myAppDocStat.getStatusName()) != 0) continue;
                    statusValidated = true;
                    break;
                }
                if (!statusValidated) {
                    WorkflowRuntimeException xpee = new WorkflowRuntimeException("AppDocStatus value " + appDocStatus + " not allowable.");
                    LOG.error((Object)("Error validating nextAppDocStatus name: " + appDocStatus + " against acceptable values."), (Throwable)xpee);
                    throw xpee;
                }
            }
            String oldStatus = this.appDocStatus;
            this.appDocStatus = appDocStatus;
            this.setAppDocStatusDate(new Timestamp(System.currentTimeMillis()));
            this.appDocStatusHistory.add(new DocumentStatusTransition(this.documentId, oldStatus, appDocStatus));
        }
    }

    public Timestamp getAppDocStatusDate() {
        return this.appDocStatusDate;
    }

    public void setAppDocStatusDate(Timestamp appDocStatusDate) {
        this.appDocStatusDate = appDocStatusDate;
    }

    public Object copy(boolean preserveKeys) {
        throw new UnsupportedOperationException("The copy method is deprecated and unimplemented!");
    }

    public boolean isStateInitiated() {
        return "I".equals(this.docRouteStatus);
    }

    public boolean isStateSaved() {
        return "S".equals(this.docRouteStatus);
    }

    public boolean isRouted() {
        return !this.isStateInitiated() && !this.isStateSaved();
    }

    public boolean isInException() {
        return "E".equals(this.docRouteStatus);
    }

    public boolean isDisaproved() {
        return "D".equals(this.docRouteStatus);
    }

    public boolean isCanceled() {
        return "X".equals(this.docRouteStatus);
    }

    public boolean isFinal() {
        return "F".equals(this.docRouteStatus);
    }

    public boolean isEnroute() {
        return "R".equals(this.docRouteStatus);
    }

    public boolean isProcessed() {
        return "P".equals(this.docRouteStatus);
    }

    public boolean isRoutable() {
        return "R".equals(this.docRouteStatus) || "S".equals(this.docRouteStatus) || "P".equals(this.docRouteStatus);
    }

    public boolean isValidActionToTake(String actionCd) {
        String actions = legalActions.get(this.docRouteStatus);
        return actions.contains(actionCd);
    }

    public boolean isValidStatusChange(String newStatus) {
        return stateTransitionMap.get(this.getDocRouteStatus()).contains(newStatus);
    }

    public void setRouteStatus(String newStatus, boolean finalState) throws InvalidActionTakenException {
        if (newStatus != this.getDocRouteStatus()) {
            this.setRouteStatusDate(new Timestamp(System.currentTimeMillis()));
        }
        if (!stateTransitionMap.get(this.getDocRouteStatus()).contains(newStatus)) {
            LOG.debug((Object)"unable to change status");
            throw new InvalidActionTakenException("Document status " + CodeTranslator.getRouteStatusLabel((String)this.getDocRouteStatus()) + " cannot transition to status " + CodeTranslator.getRouteStatusLabel((String)newStatus));
        }
        LOG.debug((Object)"changing status");
        this.setDocRouteStatus(newStatus);
        this.setDateModified(new Timestamp(System.currentTimeMillis()));
        if (finalState) {
            LOG.debug((Object)"setting final timeStamp");
            this.setFinalizedDate(new Timestamp(System.currentTimeMillis()));
        }
    }

    public void markDocumentProcessed() throws InvalidActionTakenException {
        LOG.debug((Object)(this + " marked processed"));
        this.setRouteStatus("P", false);
    }

    public void markDocumentCanceled() throws InvalidActionTakenException {
        LOG.debug((Object)(this + " marked canceled"));
        this.setRouteStatus("X", true);
    }

    public void markDocumentRecalled() throws InvalidActionTakenException {
        LOG.debug((Object)(this + " marked recalled"));
        this.setRouteStatus(DocumentStatus.RECALLED.getCode(), true);
    }

    public void markDocumentDisapproved() throws InvalidActionTakenException {
        LOG.debug((Object)(this + " marked disapproved"));
        this.setRouteStatus("D", true);
    }

    public void markDocumentSaved() throws InvalidActionTakenException {
        LOG.debug((Object)(this + " marked saved"));
        this.setRouteStatus("S", false);
    }

    public void markDocumentInException() throws InvalidActionTakenException {
        LOG.debug((Object)(this + " marked in exception"));
        this.setRouteStatus("E", false);
    }

    public void markDocumentEnroute() throws InvalidActionTakenException {
        LOG.debug((Object)(this + " marked enroute"));
        this.setRouteStatus("R", false);
    }

    public void markDocumentFinalized() throws InvalidActionTakenException {
        LOG.debug((Object)(this + " marked finalized"));
        this.setRouteStatus("F", true);
    }

    public void setRouteHeaderData(Document routeHeaderVO) throws WorkflowException {
        if (!ObjectUtils.equals((Object)this.getDocTitle(), (Object)routeHeaderVO.getTitle())) {
            KEWServiceLocator.getActionListService().updateActionItemsForTitleChange(this.getDocumentId(), routeHeaderVO.getTitle());
        }
        this.setDocTitle(routeHeaderVO.getTitle());
        this.setAppDocId(routeHeaderVO.getApplicationDocumentId());
        this.setDateModified(new Timestamp(System.currentTimeMillis()));
        this.updateAppDocStatus(routeHeaderVO.getApplicationDocumentStatus());
        for (Map.Entry kvp : routeHeaderVO.getVariables().entrySet()) {
            this.setVariable((String)kvp.getKey(), (String)kvp.getValue());
        }
    }

    public void applyDocumentUpdate(DocumentUpdate documentUpdate) {
        if (documentUpdate != null) {
            String updateDocTitle;
            String thisDocTitle = this.getDocTitle() == null ? TERMINAL : this.getDocTitle();
            String string = updateDocTitle = documentUpdate.getTitle() == null ? TERMINAL : documentUpdate.getTitle();
            if (!StringUtils.equals((String)thisDocTitle, (String)updateDocTitle)) {
                KEWServiceLocator.getActionListService().updateActionItemsForTitleChange(this.getDocumentId(), documentUpdate.getTitle());
            }
            this.setDocTitle(updateDocTitle);
            this.setAppDocId(documentUpdate.getApplicationDocumentId());
            this.setDateModified(new Timestamp(System.currentTimeMillis()));
            this.updateAppDocStatus(documentUpdate.getApplicationDocumentStatus());
            Map variables = documentUpdate.getVariables();
            for (String variableName : variables.keySet()) {
                this.setVariable(variableName, (String)variables.get(variableName));
            }
        }
    }

    public Branch getRootBranch() {
        if (!this.initialRouteNodeInstances.isEmpty()) {
            return this.getInitialRouteNodeInstance(0).getBranch();
        }
        return null;
    }

    private BranchState findVariable(String name) {
        Branch rootBranch = this.getRootBranch();
        if (rootBranch != null) {
            List<BranchState> branchState = rootBranch.getBranchState();
            for (BranchState state : branchState) {
                if (!ObjectUtils.equals((Object)state.getKey(), (Object)("var::" + name))) continue;
                return state;
            }
        }
        return null;
    }

    public String getVariable(String name) {
        BranchState state = this.findVariable(name);
        if (state == null) {
            LOG.debug((Object)("Variable not found: '" + name + "'"));
            return null;
        }
        return state.getValue();
    }

    public void removeVariableThatContains(String name) {
        ArrayList<BranchState> statesToRemove = new ArrayList<BranchState>();
        for (BranchState state : this.getRootBranchState()) {
            if (!state.getKey().contains(name)) continue;
            statesToRemove.add(state);
        }
        this.getRootBranchState().removeAll(statesToRemove);
    }

    public void setVariable(String name, String value) {
        BranchState state = this.findVariable(name);
        Branch rootBranch = this.getRootBranch();
        if (rootBranch != null) {
            List<BranchState> branchState = rootBranch.getBranchState();
            if (state == null) {
                if (value == null) {
                    LOG.debug((Object)("set non existent variable '" + name + "' to null value"));
                    return;
                }
                LOG.debug((Object)("Adding branch state: '" + name + "'='" + value + "'"));
                state = new BranchState();
                state.setBranch(rootBranch);
                state.setKey("var::" + name);
                state.setValue(value);
                rootBranch.addBranchState(state);
            } else if (value == null) {
                LOG.debug((Object)("Removing value: " + state.getKey() + "=" + state.getValue()));
                branchState.remove((Object)state);
            } else {
                LOG.debug((Object)("Setting value of variable '" + name + "' to '" + value + "'"));
                state.setValue(value);
            }
        }
    }

    public List<BranchState> getRootBranchState() {
        if (this.getRootBranch() != null) {
            return this.getRootBranch().getBranchState();
        }
        return null;
    }

    public CustomActionListAttribute getCustomActionListAttribute() throws WorkflowException {
        CustomActionListAttribute customActionListAttribute = null;
        if (this.getDocumentType() != null && (customActionListAttribute = this.getDocumentType().getCustomActionListAttribute()) != null) {
            return customActionListAttribute;
        }
        customActionListAttribute = new DefaultCustomActionListAttribute();
        return customActionListAttribute;
    }

    public CustomEmailAttribute getCustomEmailAttribute() throws WorkflowException {
        CustomEmailAttribute customEmailAttribute = null;
        try {
            if (this.getDocumentType() != null && (customEmailAttribute = this.getDocumentType().getCustomEmailAttribute()) != null) {
                customEmailAttribute.setRouteHeaderVO(DocumentRouteHeaderValue.to(this));
                return customEmailAttribute;
            }
        }
        catch (Exception e) {
            LOG.debug((Object)"Error in retrieving custom email attribute", (Throwable)e);
        }
        customEmailAttribute = new CustomEmailAttributeImpl();
        customEmailAttribute.setRouteHeaderVO(DocumentRouteHeaderValue.to(this));
        return customEmailAttribute;
    }

    public CustomNoteAttribute getCustomNoteAttribute() throws WorkflowException {
        CustomNoteAttribute customNoteAttribute = null;
        try {
            if (this.getDocumentType() != null && (customNoteAttribute = this.getDocumentType().getCustomNoteAttribute()) != null) {
                customNoteAttribute.setRouteHeaderVO(DocumentRouteHeaderValue.to(this));
                return customNoteAttribute;
            }
        }
        catch (Exception e) {
            LOG.debug((Object)"Error in retrieving custom note attribute", (Throwable)e);
        }
        customNoteAttribute = new CustomNoteAttributeImpl();
        customNoteAttribute.setRouteHeaderVO(DocumentRouteHeaderValue.to(this));
        return customNoteAttribute;
    }

    public ActionRequestValue getDocActionRequest(int index) {
        List<ActionRequestValue> actionRequests = this.getActionRequests();
        while (actionRequests.size() <= index) {
            ActionRequestValue actionRequest = new ActionRequestFactory(this).createBlankActionRequest();
            actionRequest.setNodeInstance(new RouteNodeInstance());
            actionRequests.add(actionRequest);
        }
        return actionRequests.get(index);
    }

    public ActionTakenValue getDocActionTaken(int index) {
        List<ActionTakenValue> actionsTaken = this.getActionsTaken();
        while (actionsTaken.size() <= index) {
            actionsTaken.add(new ActionTakenValue());
        }
        return actionsTaken.get(index);
    }

    public ActionItem getDocActionItem(int index) {
        List<ActionItem> actionItems = this.getActionItems();
        while (actionItems.size() <= index) {
            actionItems.add(new ActionItem());
        }
        return actionItems.get(index);
    }

    private RouteNodeInstance getInitialRouteNodeInstance(int index) {
        if (this.initialRouteNodeInstances.size() >= index) {
            return this.initialRouteNodeInstances.get(index);
        }
        return null;
    }

    public boolean isRoutingReport() {
        return this.routingReport;
    }

    public void setRoutingReport(boolean routingReport) {
        this.routingReport = routingReport;
    }

    public List<RouteNodeInstance> getInitialRouteNodeInstances() {
        return this.initialRouteNodeInstances;
    }

    public void setInitialRouteNodeInstances(List<RouteNodeInstance> initialRouteNodeInstances) {
        this.initialRouteNodeInstances = initialRouteNodeInstances;
    }

    public List<Note> getNotes() {
        return this.notes;
    }

    public void setNotes(List<Note> notes) {
        this.notes = notes;
    }

    public DocumentRouteHeaderValueContent getDocumentContent() {
        if (this.documentContent == null) {
            this.documentContent = KEWServiceLocator.getRouteHeaderService().getContent(this.getDocumentId());
        }
        return this.documentContent;
    }

    public void setDocumentContent(DocumentRouteHeaderValueContent documentContent) {
        this.documentContent = documentContent;
    }

    public List<DocumentStatusTransition> getAppDocStatusHistory() {
        return this.appDocStatusHistory;
    }

    public void setAppDocStatusHistory(List<DocumentStatusTransition> appDocStatusHistory) {
        this.appDocStatusHistory = appDocStatusHistory;
    }

    @Override
    public DocumentStatus getStatus() {
        return DocumentStatus.fromCode((String)this.getDocRouteStatus());
    }

    @Override
    public DateTime getDateCreated() {
        if (this.getCreateDate() == null) {
            return null;
        }
        return new DateTime(this.getCreateDate().getTime());
    }

    public DateTime getDateLastModified() {
        if (this.getDateModified() == null) {
            return null;
        }
        return new DateTime(this.getDateModified().getTime());
    }

    public DateTime getDateApproved() {
        if (this.getApprovedDate() == null) {
            return null;
        }
        return new DateTime(this.getApprovedDate().getTime());
    }

    public DateTime getDateFinalized() {
        if (this.getFinalizedDate() == null) {
            return null;
        }
        return new DateTime(this.getFinalizedDate().getTime());
    }

    @Override
    public String getTitle() {
        return this.docTitle;
    }

    @Override
    public String getApplicationDocumentId() {
        return this.appDocId;
    }

    @Override
    public String getInitiatorPrincipalId() {
        return this.initiatorWorkflowId;
    }

    public String getRoutedByPrincipalId() {
        return this.routedByUserWorkflowId;
    }

    @Override
    public String getDocumentTypeName() {
        return this.getDocumentType().getName();
    }

    public String getDocumentHandlerUrl() {
        return this.getDocumentType().getResolvedDocumentHandlerUrl();
    }

    @Override
    public String getApplicationDocumentStatus() {
        return this.appDocStatus;
    }

    public DateTime getApplicationDocumentStatusDate() {
        if (this.appDocStatusDate == null) {
            return null;
        }
        return new DateTime(this.appDocStatusDate.getTime());
    }

    public Map<String, String> getVariables() {
        HashMap<String, String> documentVariables = new HashMap<String, String>();
        Branch routeNodeInstanceBranch = this.getRootBranch();
        if (routeNodeInstanceBranch != null) {
            List<BranchState> listOfBranchStates = routeNodeInstanceBranch.getBranchState();
            for (BranchState bs : listOfBranchStates) {
                if (bs.getKey() == null || !bs.getKey().startsWith("var::")) continue;
                LOG.debug((Object)("Setting branch state variable on vo: " + bs.getKey() + "=" + bs.getValue()));
                documentVariables.put(bs.getKey().substring("var::".length()), bs.getValue());
            }
        }
        return documentVariables;
    }

    public static Document to(DocumentRouteHeaderValue documentBo) {
        if (documentBo == null) {
            return null;
        }
        Document.Builder builder = Document.Builder.create((DocumentContract)documentBo);
        return builder.build();
    }

    public static DocumentRouteHeaderValue from(Document document) {
        Map variables;
        DocumentRouteHeaderValue documentBo = new DocumentRouteHeaderValue();
        documentBo.setAppDocId(document.getApplicationDocumentId());
        if (document.getDateApproved() != null) {
            documentBo.setApprovedDate(new Timestamp(document.getDateApproved().getMillis()));
        }
        if (document.getDateCreated() != null) {
            documentBo.setCreateDate(new Timestamp(document.getDateCreated().getMillis()));
        }
        if (StringUtils.isEmpty((String)documentBo.getDocContent())) {
            documentBo.setDocContent("<documentContent/>");
        }
        documentBo.setDocRouteStatus(document.getStatus().getCode());
        documentBo.setDocTitle(document.getTitle());
        if (document.getDocumentTypeName() != null) {
            DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByName(document.getDocumentTypeName());
            if (documentType == null) {
                throw new RiceRuntimeException("Could not locate the given document type name: " + document.getDocumentTypeName());
            }
            documentBo.setDocumentTypeId(documentType.getDocumentTypeId());
        }
        if (document.getDateFinalized() != null) {
            documentBo.setFinalizedDate(new Timestamp(document.getDateFinalized().getMillis()));
        }
        documentBo.setInitiatorWorkflowId(document.getInitiatorPrincipalId());
        documentBo.setRoutedByUserWorkflowId(document.getRoutedByPrincipalId());
        documentBo.setDocumentId(document.getDocumentId());
        if (document.getDateLastModified() != null) {
            documentBo.setDateModified(new Timestamp(document.getDateLastModified().getMillis()));
        }
        documentBo.setAppDocStatus(document.getApplicationDocumentStatus());
        if (document.getApplicationDocumentStatusDate() != null) {
            documentBo.setAppDocStatusDate(new Timestamp(document.getApplicationDocumentStatusDate().getMillis()));
        }
        if ((variables = document.getVariables()) != null && !variables.isEmpty()) {
            for (Map.Entry kvp : variables.entrySet()) {
                documentBo.setVariable((String)kvp.getKey(), (String)kvp.getValue());
            }
        }
        return documentBo;
    }

    static {
        stateTransitionMap = new HashMap();
        stateTransitionMap.put("I", "SRX");
        stateTransitionMap.put("S", "SRXP");
        stateTransitionMap.put("R", "DXPES" + DocumentStatus.RECALLED.getCode());
        stateTransitionMap.put("D", TERMINAL);
        stateTransitionMap.put("X", TERMINAL);
        stateTransitionMap.put("F", TERMINAL);
        stateTransitionMap.put(DocumentStatus.RECALLED.getCode(), TERMINAL);
        stateTransitionMap.put("E", "ERXPDS");
        stateTransitionMap.put("P", "FP");
        legalActions = new HashMap();
        legalActions.put("I", "FKSCOXHVBM");
        legalActions.put("S", "FKSCOAXHVBM");
        legalActions.put("R", "AKFHVBXCDacdrZzM" + ActionType.RECALL.getCode());
        legalActions.put("E", "FKHVABXCDacdrZzM");
        legalActions.put("F", "FKV");
        legalActions.put("X", "FKV");
        legalActions.put("D", "FKV");
        legalActions.put("P", "FKV");
        legalActions.put(DocumentStatus.RECALLED.getCode(), TERMINAL);
    }
}

