/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.routeheader;

import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.kew.api.document.DocumentContent;
import org.kuali.rice.kew.routeheader.StandardDocumentContent;
import org.w3c.dom.Node;

@Entity
@Table(name="KREW_DOC_HDR_CNTNT_T")
@NamedQuery(name="DocumentRouteHeaderValueContent.FindByDocumentId", query="select d from DocumentRouteHeaderValueContent as d where d.documentId = :documentId")
public class DocumentRouteHeaderValueContent
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="DOC_HDR_ID")
    private String documentId;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Column(name="DOC_CNTNT_TXT")
    private String documentContent;

    public DocumentRouteHeaderValueContent() {
    }

    public DocumentRouteHeaderValueContent(String documentId) {
        this.documentId = documentId;
    }

    public String getDocumentContent() {
        return this.documentContent;
    }

    public void setDocumentContent(String documentContent) {
        this.documentContent = documentContent;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public static DocumentContent to(DocumentRouteHeaderValueContent content) {
        if (content == null) {
            return null;
        }
        DocumentContent.Builder builder = DocumentContent.Builder.create((String)content.getDocumentId());
        builder.setApplicationContent("");
        builder.setAttributeContent("");
        builder.setSearchableContent("");
        StandardDocumentContent documentContent = new StandardDocumentContent(content.getDocumentContent());
        if (documentContent.getApplicationContent() != null) {
            builder.setApplicationContent(XmlJotter.jotNode((Node)documentContent.getApplicationContent()));
        }
        if (documentContent.getAttributeContent() != null) {
            builder.setAttributeContent(XmlJotter.jotNode((Node)documentContent.getAttributeContent()));
        }
        if (documentContent.getSearchableContent() != null) {
            builder.setSearchableContent(XmlJotter.jotNode((Node)documentContent.getSearchableContent()));
        }
        return builder.build();
    }
}

