/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.routelog.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.service.ActionRequestService;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.api.action.RoutingReportCriteria;
import org.kuali.rice.kew.api.document.DocumentDetail;
import org.kuali.rice.kew.api.document.node.RouteNodeInstance;
import org.kuali.rice.kew.api.document.node.RouteNodeInstanceState;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.doctype.SecuritySession;
import org.kuali.rice.kew.doctype.service.DocumentSecurityService;
import org.kuali.rice.kew.dto.DTOConverter;
import org.kuali.rice.kew.engine.node.Branch;
import org.kuali.rice.kew.engine.node.NodeState;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.service.RouteNodeService;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routelog.web.RouteLogForm;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.util.Utilities;
import org.kuali.rice.kew.web.KewKualiAction;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;

public class RouteLogAction
extends KewKualiAction {
    private static final Logger LOG = Logger.getLogger(RouteLogAction.class);
    private static Comparator<ActionRequestValue> ROUTE_LOG_ACTION_REQUEST_SORTER = new Utilities.RouteLogActionRequestSorter();

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RouteLogForm rlForm = (RouteLogForm)form;
        String documentId = null;
        if (!StringUtils.isEmpty((String)rlForm.getDocumentId())) {
            documentId = rlForm.getDocumentId();
        } else if (!StringUtils.isEmpty((String)rlForm.getDocId())) {
            documentId = rlForm.getDocId();
        } else {
            throw new WorkflowRuntimeException("No paramater provided to fetch document");
        }
        DocumentRouteHeaderValue routeHeader = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId);
        DocumentSecurityService security = KEWServiceLocator.getDocumentSecurityService();
        if (!security.routeLogAuthorized(this.getUserSession().getPrincipalId(), routeHeader, new SecuritySession(GlobalVariables.getUserSession().getPrincipalId()))) {
            return mapping.findForward("NotAuthorized");
        }
        this.fixActionRequestsPositions(routeHeader);
        this.populateRouteLogFormActionRequests(rlForm, routeHeader);
        rlForm.setLookFuture(routeHeader.getDocumentType().getLookIntoFuturePolicy().getPolicyValue());
        if (rlForm.isShowFuture()) {
            try {
                this.populateRouteLogFutureRequests(rlForm, routeHeader);
            }
            catch (Exception e) {
                String errorMsg = "Unable to determine Future Action Requests";
                LOG.info((Object)errorMsg, (Throwable)e);
                rlForm.setShowFutureError(errorMsg);
            }
        }
        request.setAttribute("routeHeader", (Object)routeHeader);
        boolean isAuthorizedToAddRouteLogMessage = KEWServiceLocator.getDocumentTypePermissionService().canAddRouteLogMessage(GlobalVariables.getUserSession().getPrincipalId(), routeHeader);
        if (isAuthorizedToAddRouteLogMessage) {
            rlForm.setEnableLogAction(true);
        } else {
            rlForm.setEnableLogAction(false);
        }
        return super.execute(mapping, (ActionForm)rlForm, request, response);
    }

    public void populateRouteLogFormActionRequests(RouteLogForm rlForm, DocumentRouteHeaderValue routeHeader) {
        List<ActionRequestValue> rootRequests = this.getActionRequestService().getRootRequests(routeHeader.getActionRequests());
        Collections.sort(rootRequests, ROUTE_LOG_ACTION_REQUEST_SORTER);
        rootRequests = this.switchActionRequestPositionsIfPrimaryDelegatesPresent(rootRequests);
        int arCount = 0;
        for (ActionRequestValue actionRequest : rootRequests) {
            if (!actionRequest.isPending()) continue;
            ++arCount;
            if (ActionRequestStatus.INITIALIZED.getCode().equals(actionRequest.getStatus())) {
                actionRequest.setDisplayStatus("PENDING");
                continue;
            }
            if (!ActionRequestStatus.ACTIVATED.getCode().equals(actionRequest.getStatus())) continue;
            actionRequest.setDisplayStatus("IN ACTION LIST");
        }
        rlForm.setRootRequests(rootRequests);
        rlForm.setPendingActionRequestCount(arCount);
    }

    private ActionRequestValue switchActionRequestPositionIfPrimaryDelegatePresent(ActionRequestValue actionRequest) {
        if (!actionRequest.isRoleRequest()) {
            List<ActionRequestValue> primaryDelegateRequests = actionRequest.getPrimaryDelegateRequests();
            if (primaryDelegateRequests.size() != 1) {
                return actionRequest;
            }
            ActionRequestValue primaryDelegateRequest = primaryDelegateRequests.get(0);
            actionRequest.getChildrenRequests().remove(primaryDelegateRequest);
            primaryDelegateRequest.setChildrenRequests(actionRequest.getChildrenRequests());
            primaryDelegateRequest.setParentActionRequest(actionRequest.getParentActionRequest());
            primaryDelegateRequest.setParentActionRequestId(actionRequest.getParentActionRequestId());
            actionRequest.setChildrenRequests(new ArrayList<ActionRequestValue>(0));
            actionRequest.setParentActionRequest(primaryDelegateRequest);
            actionRequest.setParentActionRequestId(primaryDelegateRequest.getActionRequestId());
            primaryDelegateRequest.getChildrenRequests().add(0, actionRequest);
            for (ActionRequestValue delegateRequest : primaryDelegateRequest.getChildrenRequests()) {
                delegateRequest.setParentActionRequest(primaryDelegateRequest);
                delegateRequest.setParentActionRequestId(primaryDelegateRequest.getActionRequestId());
            }
            return primaryDelegateRequest;
        }
        return actionRequest;
    }

    private List<ActionRequestValue> switchActionRequestPositionsIfPrimaryDelegatesPresent(Collection<ActionRequestValue> actionRequests) {
        ArrayList<ActionRequestValue> results = new ArrayList<ActionRequestValue>(actionRequests.size());
        for (ActionRequestValue actionRequest : actionRequests) {
            results.add(this.switchActionRequestPositionIfPrimaryDelegatePresent(actionRequest));
        }
        return results;
    }

    private void fixActionRequestsPositions(DocumentRouteHeaderValue routeHeader) {
        for (ActionTakenValue actionTaken : routeHeader.getActionsTaken()) {
            Collections.sort((List)actionTaken.getActionRequests(), ROUTE_LOG_ACTION_REQUEST_SORTER);
            actionTaken.setActionRequests(actionTaken.getActionRequests());
        }
    }

    public void populateRouteLogFutureRequests(RouteLogForm rlForm, DocumentRouteHeaderValue document) throws Exception {
        RoutingReportCriteria reportCriteria = RoutingReportCriteria.Builder.createByDocumentId((String)document.getDocumentId()).build();
        String applicationId = document.getDocumentType().getApplicationId();
        Set<String> preexistingActionRequestIds = this.getActionRequestIds(document);
        DocumentDetail documentDetail = KewApiServiceLocator.getWorkflowDocumentActionsService((String)applicationId).executeSimulation(reportCriteria);
        List<ActionRequestValue> futureActionRequests = this.reconstituteActionRequestValues(documentDetail, preexistingActionRequestIds);
        Collections.sort(futureActionRequests, ROUTE_LOG_ACTION_REQUEST_SORTER);
        futureActionRequests = this.switchActionRequestPositionsIfPrimaryDelegatesPresent(futureActionRequests);
        int pendingActionRequestCount = 0;
        for (ActionRequestValue actionRequest : futureActionRequests) {
            if (!actionRequest.isPending()) continue;
            ++pendingActionRequestCount;
            if (ActionRequestStatus.INITIALIZED.getCode().equals(actionRequest.getStatus())) {
                actionRequest.setDisplayStatus("PENDING");
                continue;
            }
            if (!ActionRequestStatus.ACTIVATED.getCode().equals(actionRequest.getStatus())) continue;
            actionRequest.setDisplayStatus("IN ACTION LIST");
        }
        rlForm.setFutureRootRequests(futureActionRequests);
        rlForm.setFutureActionRequestCount(pendingActionRequestCount);
    }

    private Set<String> getActionRequestIds(DocumentRouteHeaderValue document) {
        HashSet<String> actionRequestIds = new HashSet<String>();
        List<ActionRequestValue> actionRequests = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(document.getDocumentId());
        if (actionRequests != null) {
            for (ActionRequestValue actionRequest : actionRequests) {
                if (actionRequest.getActionRequestId() == null) continue;
                actionRequestIds.add(actionRequest.getActionRequestId());
            }
        }
        return actionRequestIds;
    }

    private List<ActionRequestValue> reconstituteActionRequestValues(DocumentDetail documentDetail, Set<String> preexistingActionRequestIds) {
        RouteNodeInstanceFabricator routeNodeInstanceFabricator = new RouteNodeInstanceFabricator(KEWServiceLocator.getRouteNodeService());
        if (documentDetail.getRouteNodeInstances() != null && !documentDetail.getRouteNodeInstances().isEmpty()) {
            for (RouteNodeInstance routeNodeInstanceVO : documentDetail.getRouteNodeInstances()) {
                routeNodeInstanceFabricator.importRouteNodeInstanceDTO(routeNodeInstanceVO);
            }
        }
        List actionRequestVOs = documentDetail.getActionRequests();
        ArrayList<ActionRequestValue> futureActionRequests = new ArrayList<ActionRequestValue>();
        if (actionRequestVOs != null) {
            for (ActionRequest actionRequestVO : actionRequestVOs) {
                if (actionRequestVO == null || preexistingActionRequestIds.contains(actionRequestVO.getId())) continue;
                ActionRequestValue converted = ActionRequestValue.from(actionRequestVO, routeNodeInstanceFabricator);
                futureActionRequests.add(converted);
            }
        }
        return futureActionRequests;
    }

    private ActionRequestService getActionRequestService() {
        return (ActionRequestService)KEWServiceLocator.getService("enActionRequestService");
    }

    private UserSession getUserSession() {
        return GlobalVariables.getUserSession();
    }

    public ActionForward logActionMessageInRouteLog(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RouteLogForm routeLogForm = (RouteLogForm)form;
        String documentId = null;
        if (!StringUtils.isEmpty((String)routeLogForm.getDocumentId())) {
            documentId = routeLogForm.getDocumentId();
        } else if (!StringUtils.isEmpty((String)routeLogForm.getDocId())) {
            documentId = routeLogForm.getDocId();
        } else {
            throw new WorkflowRuntimeException("No paramater provided to fetch document");
        }
        DocumentRouteHeaderValue routeHeader = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId);
        boolean isAuthorizedToAddRouteLogMessage = KEWServiceLocator.getDocumentTypePermissionService().canAddRouteLogMessage(GlobalVariables.getUserSession().getPrincipalId(), routeHeader);
        if (!isAuthorizedToAddRouteLogMessage) {
            throw new InvalidActionTakenException("Principal with name '" + GlobalVariables.getUserSession().getPrincipalName() + "' is not authorized to add route log messages for documents of type '" + routeHeader.getDocumentType().getName());
        }
        LOG.info((Object)("Logging new action message for user " + GlobalVariables.getUserSession().getPrincipalName() + ", route header " + routeHeader));
        KEWServiceLocator.getWorkflowDocumentService().logDocumentAction(GlobalVariables.getUserSession().getPrincipalId(), routeHeader, routeLogForm.getNewRouteLogActionMessage());
        routeLogForm.setNewRouteLogActionMessage("");
        routeHeader = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId, true);
        this.fixActionRequestsPositions(routeHeader);
        request.setAttribute("routeHeader", (Object)routeHeader);
        return mapping.findForward(this.getDefaultMapping());
    }

    private static class RouteNodeInstanceFabricator
    implements DTOConverter.RouteNodeInstanceLoader {
        private Map<String, Branch> branches = new HashMap<String, Branch>();
        private Map<String, org.kuali.rice.kew.engine.node.RouteNodeInstance> routeNodeInstances = new HashMap<String, org.kuali.rice.kew.engine.node.RouteNodeInstance>();
        private Map<String, RouteNode> routeNodes = new HashMap<String, RouteNode>();
        private Map<String, NodeState> nodeStates = new HashMap<String, NodeState>();
        private RouteNodeService routeNodeService;

        public RouteNodeInstanceFabricator(RouteNodeService routeNodeService) {
            this.routeNodeService = routeNodeService;
        }

        public void importRouteNodeInstanceDTO(RouteNodeInstance nodeInstanceDTO) {
            this._importRouteNodeInstanceDTO(nodeInstanceDTO);
        }

        private org.kuali.rice.kew.engine.node.RouteNodeInstance _importRouteNodeInstanceDTO(RouteNodeInstance nodeInstanceDTO) {
            if (nodeInstanceDTO == null) {
                return null;
            }
            org.kuali.rice.kew.engine.node.RouteNodeInstance nodeInstance = new org.kuali.rice.kew.engine.node.RouteNodeInstance();
            nodeInstance.setActive(nodeInstanceDTO.isActive());
            nodeInstance.setComplete(nodeInstanceDTO.isComplete());
            nodeInstance.setDocumentId(nodeInstanceDTO.getDocumentId());
            nodeInstance.setInitial(nodeInstanceDTO.isInitial());
            Branch branch = this.getBranch(nodeInstanceDTO.getBranchId());
            nodeInstance.setBranch(branch);
            if (nodeInstanceDTO.getRouteNodeId() != null) {
                RouteNode routeNode = this.routeNodeService.findRouteNodeById(nodeInstanceDTO.getRouteNodeId());
                if (routeNode == null) {
                    routeNode = this.getRouteNode(nodeInstanceDTO.getRouteNodeId());
                    routeNode.setNodeType(nodeInstanceDTO.getName());
                }
                nodeInstance.setRouteNode(routeNode);
                if (routeNode.getBranch() != null) {
                    branch.setName(routeNode.getBranch().getName());
                }
            }
            org.kuali.rice.kew.engine.node.RouteNodeInstance process = this.getRouteNodeInstance(nodeInstanceDTO.getProcessId());
            nodeInstance.setProcess(process);
            nodeInstance.setRouteNodeInstanceId(nodeInstanceDTO.getId());
            ArrayList<NodeState> nodeState = new ArrayList<NodeState>();
            if (nodeInstanceDTO.getState() != null) {
                for (RouteNodeInstanceState stateDTO : nodeInstanceDTO.getState()) {
                    NodeState state = this.getNodeState(stateDTO.getId());
                    if (state == null) continue;
                    state.setKey(stateDTO.getKey());
                    state.setValue(stateDTO.getValue());
                    state.setStateId(stateDTO.getId());
                    state.setNodeInstance(nodeInstance);
                    nodeState.add(state);
                }
            }
            nodeInstance.setState(nodeState);
            ArrayList<org.kuali.rice.kew.engine.node.RouteNodeInstance> nextNodeInstances = new ArrayList<org.kuali.rice.kew.engine.node.RouteNodeInstance>();
            for (RouteNodeInstance nextNodeInstanceVO : nodeInstanceDTO.getNextNodeInstances()) {
                nextNodeInstances.add(this._importRouteNodeInstanceDTO(nextNodeInstanceVO));
            }
            nodeInstance.setNextNodeInstances(nextNodeInstances);
            this.routeNodeInstances.put(nodeInstance.getRouteNodeInstanceId(), nodeInstance);
            return nodeInstance;
        }

        @Override
        public org.kuali.rice.kew.engine.node.RouteNodeInstance load(String routeNodeInstanceID) {
            return this.routeNodeInstances.get(routeNodeInstanceID);
        }

        private Branch getBranch(String branchId) {
            Branch result = null;
            if (branchId != null) {
                if (!this.branches.containsKey(branchId)) {
                    result = new Branch();
                    result.setBranchId(branchId);
                    this.branches.put(branchId, result);
                } else {
                    result = this.branches.get(branchId);
                }
            }
            return result;
        }

        private RouteNode getRouteNode(String routeNodeId) {
            RouteNode result = null;
            if (routeNodeId != null) {
                if (!this.routeNodes.containsKey(routeNodeId)) {
                    result = new RouteNode();
                    result.setRouteNodeId(routeNodeId);
                    this.routeNodes.put(routeNodeId, result);
                } else {
                    result = this.routeNodes.get(routeNodeId);
                }
            }
            return result;
        }

        public org.kuali.rice.kew.engine.node.RouteNodeInstance getRouteNodeInstance(String routeNodeInstanceId) {
            org.kuali.rice.kew.engine.node.RouteNodeInstance result = null;
            if (routeNodeInstanceId != null) {
                if (!this.routeNodeInstances.containsKey(routeNodeInstanceId)) {
                    result = new org.kuali.rice.kew.engine.node.RouteNodeInstance();
                    result.setRouteNodeInstanceId(routeNodeInstanceId);
                    this.routeNodeInstances.put(routeNodeInstanceId, result);
                } else {
                    result = this.routeNodeInstances.get(routeNodeInstanceId);
                }
            }
            return result;
        }

        private NodeState getNodeState(String nodeStateId) {
            NodeState result = null;
            if (nodeStateId != null) {
                if (!this.nodeStates.containsKey(nodeStateId)) {
                    result = new NodeState();
                    result.setNodeStateId(nodeStateId);
                    this.nodeStates.put(nodeStateId, result);
                } else {
                    result = this.nodeStates.get(nodeStateId);
                }
            }
            return result;
        }
    }
}

