/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.dao.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.core.framework.persistence.jpa.criteria.Criteria;
import org.kuali.rice.core.framework.persistence.jpa.criteria.QueryByCriteria;
import org.kuali.rice.core.framework.persistence.platform.DatabasePlatform;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.rule.dao.RuleTemplateDAO;

public class RuleTemplateDAOJpaImpl
implements RuleTemplateDAO {
    @PersistenceContext(unitName="kew-unit")
    private EntityManager entityManager;

    @Override
    public List<RuleTemplateBo> findAll() {
        return this.entityManager.createNamedQuery("findAllOrderedByName").getResultList();
    }

    @Override
    public RuleTemplateBo findByRuleTemplateName(String ruleTemplateName) {
        if (StringUtils.isBlank((String)ruleTemplateName)) {
            return null;
        }
        Criteria crit = new Criteria(RuleTemplateBo.class.getName());
        crit.eq("name", (Object)ruleTemplateName);
        crit.orderBy("ruleTemplateId", false);
        List ruleTemplates = new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
        if (ruleTemplates == null || ruleTemplates.size() == 0) {
            return null;
        }
        return (RuleTemplateBo)((Object)ruleTemplates.get(0));
    }

    @Override
    public List<RuleTemplateBo> findByRuleTemplate(RuleTemplateBo ruleTemplate) {
        Criteria crit = new Criteria(RuleTemplateBo.class.getName());
        if (ruleTemplate.getName() != null) {
            crit.rawJpql("UPPER(RULE_TMPL_NM) like '" + ruleTemplate.getName().toUpperCase() + "'");
        }
        if (ruleTemplate.getDescription() != null) {
            crit.rawJpql("UPPER(RULE_TMPL_DESC) like '" + ruleTemplate.getDescription().toUpperCase() + "'");
        }
        return new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
    }

    @Override
    public void delete(String ruleTemplateId) {
        this.entityManager.remove((Object)this.findByRuleTemplateId(ruleTemplateId));
    }

    @Override
    public RuleTemplateBo findByRuleTemplateId(String ruleTemplateId) {
        return (RuleTemplateBo)((Object)this.entityManager.find(RuleTemplateBo.class, (Object)ruleTemplateId));
    }

    @Override
    public void save(RuleTemplateBo ruleTemplate) {
        if (ruleTemplate.getId() == null) {
            this.entityManager.persist((Object)ruleTemplate);
        } else {
            OrmUtils.merge((EntityManager)this.entityManager, (Object)((Object)ruleTemplate));
        }
    }

    @Override
    public String getNextRuleTemplateId() {
        return String.valueOf(this.getPlatform().getNextValSQL("KREW_RTE_TMPL_S", this.entityManager));
    }

    protected DatabasePlatform getPlatform() {
        return (DatabasePlatform)GlobalResourceLoader.getService((String)"dbPlatform");
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

