/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.util;

import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.lang.text.StrSubstitutor;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.util.ConfigStringLookup;

public final class Utilities {
    private static final StrSubstitutor SUBSTITUTOR = new StrSubstitutor((StrLookup)new ConfigStringLookup());

    private Utilities() {
        throw new UnsupportedOperationException("do not call");
    }

    public static String substituteConfigParameters(String applicationId, String string) {
        StrSubstitutor sub = new StrSubstitutor((StrLookup)new ConfigStringLookup(applicationId));
        return sub.replace(string);
    }

    public static String substituteConfigParameters(String string) {
        return SUBSTITUTOR.replace(string);
    }

    public static String parseGroupNamespaceCode(String namespaceAndNameCombo) {
        if (namespaceAndNameCombo == null) {
            return null;
        }
        String[] groupData = namespaceAndNameCombo.split(":");
        if (groupData.length == 1) {
            return "KR-WKFLW";
        }
        if (groupData.length == 2) {
            return groupData[0].trim();
        }
        return null;
    }

    public static String parseGroupName(String namespaceAndNameCombo) {
        if (namespaceAndNameCombo == null) {
            return null;
        }
        String[] groupData = namespaceAndNameCombo.split(":");
        if (groupData.length == 1) {
            return groupData[0].trim();
        }
        if (groupData.length == 2) {
            return groupData[1].trim();
        }
        return null;
    }

    public static boolean checkDateRanges(String fromDate, String toDate) {
        try {
            Date parsedDate = CoreApiServiceLocator.getDateTimeService().convertToDate(fromDate.trim());
            Calendar fromCalendar = Calendar.getInstance();
            fromCalendar.setLenient(false);
            fromCalendar.setTime(parsedDate);
            fromCalendar.set(11, 0);
            fromCalendar.set(12, 0);
            fromCalendar.set(13, 0);
            fromCalendar.set(14, 0);
            parsedDate = CoreApiServiceLocator.getDateTimeService().convertToDate(toDate.trim());
            Calendar toCalendar = Calendar.getInstance();
            toCalendar.setLenient(false);
            toCalendar.setTime(parsedDate);
            toCalendar.set(11, 0);
            toCalendar.set(12, 0);
            toCalendar.set(13, 0);
            toCalendar.set(14, 0);
            return !fromCalendar.after(toCalendar);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static <T extends KeyValue> Map<String, String> getKeyValueCollectionAsMap(List<T> collection) {
        HashMap<String, String> map = new HashMap<String, String>(collection.size());
        for (KeyValue kv : collection) {
            map.put(kv.getKey(), kv.getValue());
        }
        return map;
    }

    public static <T extends KeyValue> Map<String, T> getKeyValueCollectionAsLookupTable(List<T> collection) {
        HashMap<String, KeyValue> map = new HashMap<String, KeyValue>(collection.size());
        for (KeyValue kv : collection) {
            map.put(kv.getKey(), kv);
        }
        return map;
    }

    public static class RouteLogActionRequestSorter
    extends PrioritySorter
    implements Comparator<ActionRequestValue> {
        @Override
        public int compare(ActionRequestValue ar1, ActionRequestValue ar2) {
            int routeLevelCompareVal;
            if (!ar1.getChildrenRequests().isEmpty()) {
                Collections.sort(ar1.getChildrenRequests(), this);
            }
            if (!ar2.getChildrenRequests().isEmpty()) {
                Collections.sort(ar2.getChildrenRequests(), this);
            }
            if ((routeLevelCompareVal = ar1.getRouteLevel().compareTo(ar2.getRouteLevel())) != 0) {
                return routeLevelCompareVal;
            }
            if (ar1.isActive() && ar2.isPending()) {
                return -1;
            }
            if (ar2.isActive() && ar1.isPending()) {
                return 1;
            }
            return super.compare(ar1, ar2);
        }
    }

    public static class PrioritySorter
    implements Comparator<ActionRequestValue> {
        @Override
        public int compare(ActionRequestValue ar1, ActionRequestValue ar2) {
            int value = ar1.getPriority().compareTo(ar2.getPriority());
            if (value == 0 && (value = ActionRequestValue.compareActionCode(ar1.getActionRequested(), ar2.getActionRequested(), true)) == 0) {
                value = ar1.getActionRequestId() != null && ar2.getActionRequestId() != null ? ar1.getActionRequestId().compareTo(ar2.getActionRequestId()) : 0;
            }
            return value;
        }
    }
}

