/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.bo.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.bo.ui.KimDocumentBoActivatableToFromEditableBase;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleMemberId;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleQualifier;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleResponsibilityAction;

@IdClass(value=KimDocumentRoleMemberId.class)
@Entity
@Table(name="KRIM_PND_ROLE_MBR_MT")
public class KimDocumentRoleMember
extends KimDocumentBoActivatableToFromEditableBase {
    private static final long serialVersionUID = -2463865643038170979L;
    @Id
    @GeneratedValue(generator="KRIM_ROLE_MBR_ID_S")
    @GenericGenerator(name="KRIM_ROLE_MBR_ID_S", strategy="org.kuali.rice.core.jpa.spring.RiceNumericStringSequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KRIM_ROLE_MBR_ID_S"), @Parameter(name="value_column", value="id")})
    @Column(name="ROLE_MBR_ID")
    protected String roleMemberId;
    @Column(name="ROLE_ID")
    protected String roleId;
    @Column(name="MBR_ID")
    protected String memberId;
    @Column(name="MBR_TYP_CD")
    protected String memberTypeCode = KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode();
    @Transient
    protected String memberName;
    @Transient
    protected String memberNamespaceCode;
    protected String memberFullName;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumns(value={@JoinColumn(name="ROLE_MBR_ID", insertable=false, updatable=false), @JoinColumn(name="FDOC_NBR", insertable=false, updatable=false)})
    protected List<KimDocumentRoleQualifier> qualifiers = new ArrayList<KimDocumentRoleQualifier>();
    @Transient
    protected String qualifiersToDisplay;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumns(value={@JoinColumn(name="ROLE_MBR_ID", insertable=false, updatable=false), @JoinColumn(name="FDOC_NBR", insertable=false, updatable=false)})
    private List<KimDocumentRoleResponsibilityAction> roleRspActions = new ArrayList<KimDocumentRoleResponsibilityAction>();

    public int getNumberOfQualifiers() {
        return this.qualifiers == null ? 0 : this.qualifiers.size();
    }

    public String getMemberId() {
        return this.memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public String getRoleMemberId() {
        return this.roleMemberId;
    }

    public void setRoleMemberId(String roleMemberId) {
        this.roleMemberId = roleMemberId;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public KimDocumentRoleQualifier getQualifier(String kimAttributeDefnId) {
        for (KimDocumentRoleQualifier qualifier : this.qualifiers) {
            if (!qualifier.getKimAttrDefnId().equals(kimAttributeDefnId)) continue;
            return qualifier;
        }
        return null;
    }

    public List<KimDocumentRoleQualifier> getQualifiers() {
        return this.qualifiers;
    }

    public void setQualifiers(List<KimDocumentRoleQualifier> qualifiers) {
        this.qualifiers = qualifiers;
    }

    public String getMemberTypeCode() {
        return this.memberTypeCode;
    }

    public void setMemberTypeCode(String memberTypeCode) {
        this.memberTypeCode = memberTypeCode;
    }

    public String getMemberName() {
        if (this.memberName == null) {
            this.populateDerivedValues();
        }
        return this.memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public List<KimDocumentRoleResponsibilityAction> getRoleRspActions() {
        return this.roleRspActions;
    }

    public void setRoleRspActions(List<KimDocumentRoleResponsibilityAction> roleRspActions) {
        this.roleRspActions = roleRspActions;
    }

    public String getMemberNamespaceCode() {
        if (this.memberNamespaceCode == null) {
            this.populateDerivedValues();
        }
        return this.memberNamespaceCode;
    }

    public void setMemberNamespaceCode(String memberNamespaceCode) {
        this.memberNamespaceCode = memberNamespaceCode;
    }

    protected void populateDerivedValues() {
        if (MemberType.PRINCIPAL.getCode().equals(this.getMemberTypeCode())) {
            Principal principalInfo;
            if (!StringUtils.isEmpty((String)this.getMemberId()) && (principalInfo = KimApiServiceLocator.getIdentityService().getPrincipal(this.getMemberId())) != null) {
                this.setMemberName(principalInfo.getPrincipalName());
            }
        } else if (MemberType.GROUP.getCode().equals(this.getMemberTypeCode())) {
            Group groupInfo = KimApiServiceLocator.getGroupService().getGroup(this.getMemberId());
            if (groupInfo != null) {
                this.setMemberName(groupInfo.getName());
                this.setMemberNamespaceCode(groupInfo.getNamespaceCode());
            }
        } else if (MemberType.ROLE.getCode().equals(this.getMemberTypeCode())) {
            Role role = KimApiServiceLocator.getRoleService().getRole(this.getMemberId());
            this.setMemberName(role.getName());
            this.setMemberNamespaceCode(role.getNamespaceCode());
        }
    }

    public boolean isRole() {
        return this.getMemberTypeCode() != null && this.getMemberTypeCode().equals(MemberType.ROLE.getCode());
    }

    public boolean isGroup() {
        return this.getMemberTypeCode() != null && this.getMemberTypeCode().equals(MemberType.GROUP.getCode());
    }

    public boolean isPrincipal() {
        return this.getMemberTypeCode() != null && this.getMemberTypeCode().equals(MemberType.PRINCIPAL.getCode());
    }

    public Map<String, String> getQualifierAsMap() {
        HashMap<String, String> m = new HashMap<String, String>();
        for (KimDocumentRoleQualifier data : this.getQualifiers()) {
            if (data.getKimAttribute() == null) {
                data.refreshReferenceObject("kimAttribute");
            }
            if (data.getKimAttribute() == null) continue;
            m.put(data.getKimAttribute().getAttributeName(), data.getAttrVal());
        }
        return m;
    }

    public String getQualifiersToDisplay() {
        return this.qualifiersToDisplay;
    }

    public void setQualifiersToDisplay(String qualifiersToDisplay) {
        this.qualifiersToDisplay = qualifiersToDisplay;
    }

    public String getMemberFullName() {
        return this.memberFullName;
    }

    public void setMemberFullName(String memberFullName) {
        this.memberFullName = memberFullName;
    }

    public boolean isMemberNameNull() {
        return this.memberName == null;
    }

    public boolean isMemberNameSpaceCodeNull() {
        return this.memberNamespaceCode == null;
    }
}

