/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.bo.ui;

import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.bo.ui.KimDocumentBoActivatableToFromBase;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegationMemberId;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegationMemberQualifier;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.impl.type.KimTypeAttributesHelper;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.springframework.util.AutoPopulatingList;

@IdClass(value=RoleDocumentDelegationMemberId.class)
@Entity
@Table(name="KRIM_PND_DLGN_MBR_T")
public class RoleDocumentDelegationMember
extends KimDocumentBoActivatableToFromBase {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="KRIM_DLGN_MBR_ID_S")
    @GenericGenerator(name="KRIM_DLGN_MBR_ID_S", strategy="org.kuali.rice.core.jpa.spring.RiceNumericStringSequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KRIM_DLGN_MBR_ID_S"), @Parameter(name="value_column", value="id")})
    @Column(name="DLGN_MBR_ID")
    protected String delegationMemberId;
    @Column(name="ROLE_MBR_ID")
    protected String roleMemberId;
    @Transient
    protected String roleMemberMemberId;
    @Transient
    protected String roleMemberMemberTypeCode;
    @Transient
    protected String roleMemberName;
    @Transient
    protected String roleMemberNamespaceCode;
    @Transient
    private KimTypeAttributesHelper attributesHelper;
    @Transient
    protected RoleBo roleBo = new RoleBo();
    @Column(name="DLGN_ID")
    protected String delegationId;
    @Column(name="MBR_ID")
    protected String memberId;
    @Column(name="MBR_TYP_CD")
    protected String memberTypeCode = KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode();
    @Transient
    protected String memberNamespaceCode;
    @Column(name="MBR_NM")
    protected String memberName;
    @OneToMany(targetEntity=RoleDocumentDelegationMemberQualifier.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Fetch(value=FetchMode.SELECT)
    @JoinColumns(value={@JoinColumn(name="dlgn_id", insertable=false, updatable=false), @JoinColumn(name="fdoc_nbr", insertable=false, updatable=false)})
    protected List<RoleDocumentDelegationMemberQualifier> qualifiers = new AutoPopulatingList(RoleDocumentDelegationMemberQualifier.class);
    @Transient
    protected String delegationTypeCode;

    public String getDelegationTypeCode() {
        return this.delegationTypeCode;
    }

    public void setDelegationTypeCode(String delegationTypeCode) {
        this.delegationTypeCode = delegationTypeCode;
    }

    public String getDelegationId() {
        return this.delegationId;
    }

    public void setDelegationId(String delegationId) {
        this.delegationId = delegationId;
    }

    public List<RoleDocumentDelegationMemberQualifier> getQualifiers() {
        return this.qualifiers;
    }

    public RoleDocumentDelegationMemberQualifier getQualifier(String kimAttributeDefnId) {
        for (RoleDocumentDelegationMemberQualifier qualifier : this.qualifiers) {
            if (!qualifier.getKimAttrDefnId().equals(kimAttributeDefnId)) continue;
            return qualifier;
        }
        return null;
    }

    public void setQualifiers(List<RoleDocumentDelegationMemberQualifier> qualifiers) {
        this.qualifiers = qualifiers;
    }

    public int getNumberOfQualifiers() {
        return this.qualifiers == null ? 0 : this.qualifiers.size();
    }

    public String getMemberId() {
        return this.memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public String getDelegationMemberId() {
        return this.delegationMemberId;
    }

    public void setDelegationMemberId(String delegationMemberId) {
        this.delegationMemberId = delegationMemberId;
    }

    public String getMemberTypeCode() {
        return this.memberTypeCode;
    }

    public void setMemberTypeCode(String memberTypeCode) {
        this.memberTypeCode = memberTypeCode;
    }

    public boolean isDelegationPrimary() {
        return DelegationType.PRIMARY.getCode().equals(this.getDelegationTypeCode());
    }

    public boolean isDelegationSecondary() {
        return DelegationType.SECONDARY.getCode().equals(this.getDelegationTypeCode());
    }

    public String getMemberNamespaceCode() {
        if (this.memberNamespaceCode == null) {
            this.populateDerivedValues();
        }
        return this.memberNamespaceCode;
    }

    public void setMemberNamespaceCode(String memberNamespaceCode) {
        this.memberNamespaceCode = memberNamespaceCode;
    }

    protected void populateDerivedValues() {
        if (MemberType.GROUP.getCode().equals(this.getMemberTypeCode())) {
            Group groupInfo = null;
            groupInfo = KimApiServiceLocator.getGroupService().getGroup(this.getMemberId());
            if (groupInfo != null) {
                this.setMemberNamespaceCode(groupInfo.getNamespaceCode());
            }
        } else if (MemberType.ROLE.getCode().equals(this.getMemberTypeCode())) {
            Role role = KimApiServiceLocator.getRoleService().getRole(this.getMemberId());
            this.setMemberNamespaceCode(role.getNamespaceCode());
        }
    }

    public String getRoleMemberId() {
        return this.roleMemberId;
    }

    public void setRoleMemberId(String roleMemberId) {
        this.roleMemberId = roleMemberId;
    }

    public boolean isRole() {
        return this.getMemberTypeCode() != null && this.getMemberTypeCode().equals(MemberType.ROLE.getCode());
    }

    public boolean isGroup() {
        return this.getMemberTypeCode() != null && this.getMemberTypeCode().equals(MemberType.GROUP.getCode());
    }

    public boolean isPrincipal() {
        return this.getMemberTypeCode() != null && this.getMemberTypeCode().equals(MemberType.PRINCIPAL.getCode());
    }

    public String getRoleMemberName() {
        return this.roleMemberName;
    }

    public void setRoleMemberName(String roleMemberName) {
        this.roleMemberName = roleMemberName;
    }

    public String getRoleMemberNamespaceCode() {
        return this.roleMemberNamespaceCode;
    }

    public void setRoleMemberNamespaceCode(String roleMemberNamespaceCode) {
        this.roleMemberNamespaceCode = roleMemberNamespaceCode;
    }

    public RoleBo getRoleBo() {
        return this.roleBo;
    }

    public void setRoleBo(RoleBo roleBo) {
        this.roleBo = roleBo;
        this.setAttributesHelper(new KimTypeAttributesHelper(KimTypeBo.to((KimTypeBo)roleBo.getKimRoleType())));
    }

    public KimTypeAttributesHelper getAttributesHelper() {
        return this.attributesHelper;
    }

    public void setAttributesHelper(KimTypeAttributesHelper attributesHelper) {
        this.attributesHelper = attributesHelper;
    }

    public String getRoleMemberMemberId() {
        return this.roleMemberMemberId;
    }

    public void setRoleMemberMemberId(String roleMemberMemberId) {
        this.roleMemberMemberId = roleMemberMemberId;
    }

    public String getRoleMemberMemberTypeCode() {
        return this.roleMemberMemberTypeCode;
    }

    public void setRoleMemberMemberTypeCode(String roleMemberMemberTypeCode) {
        this.roleMemberMemberTypeCode = roleMemberMemberTypeCode;
    }
}

