/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.document;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.responsibility.ResponsibilityService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleMember;
import org.kuali.rice.kim.bo.ui.KimDocumentRolePermission;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleQualifier;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleResponsibility;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleResponsibilityAction;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegation;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegationMember;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegationMemberQualifier;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityInternalService;
import org.kuali.rice.kim.impl.services.KimImplServiceLocator;
import org.kuali.rice.kim.impl.type.IdentityManagementTypeAttributeTransactionalDocument;
import org.kuali.rice.kim.service.KIMServiceLocatorInternal;
import org.kuali.rice.kim.web.struts.form.IdentityManagementRoleDocumentForm;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.util.AutoPopulatingList;

public class IdentityManagementRoleDocument
extends IdentityManagementTypeAttributeTransactionalDocument {
    private static final long serialVersionUID = 1L;
    protected String roleId;
    protected String roleTypeId;
    protected String roleTypeName;
    protected String roleNamespace = "";
    protected String roleName = "";
    protected String roleDescription = "";
    protected boolean active = true;
    protected boolean editing;
    protected List<KimDocumentRolePermission> permissions = new AutoPopulatingList(KimDocumentRolePermission.class);
    protected List<KimDocumentRoleResponsibility> responsibilities = new AutoPopulatingList(KimDocumentRoleResponsibility.class);
    protected List<KimDocumentRoleMember> modifiedMembers = new AutoPopulatingList(KimDocumentRoleMember.class);
    private List<RoleDocumentDelegationMember> delegationMembers = new AutoPopulatingList(RoleDocumentDelegationMember.class);
    private List<RoleDocumentDelegation> delegations = new AutoPopulatingList(RoleDocumentDelegation.class);
    @Transient
    protected List<KimDocumentRoleMember> searchResultMembers = new AutoPopulatingList(KimDocumentRoleMember.class);
    @Transient
    protected List<KimDocumentRoleMember> members = new AutoPopulatingList(KimDocumentRoleMember.class);
    @Transient
    private transient ResponsibilityService responsibilityService;
    private transient ResponsibilityInternalService responsibilityInternalService;
    protected RoleMemberMetaDataType memberMetaDataType = RoleMemberMetaDataType.MEMBER_NAME;

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getRoleDescription() {
        return this.roleDescription;
    }

    public void setRoleDescription(String roleDescription) {
        this.roleDescription = roleDescription;
    }

    public String getRoleNamespace() {
        return this.roleNamespace;
    }

    public void setRoleNamespace(String roleNamespace) {
        this.roleNamespace = roleNamespace;
    }

    public String getRoleTypeId() {
        return this.roleTypeId;
    }

    public void setRoleTypeId(String roleTypeId) {
        this.roleTypeId = roleTypeId;
    }

    public String getRoleTypeName() {
        if (this.roleTypeName == null) {
            if (this.kimType != null) {
                this.roleTypeName = this.kimType.getName();
            } else if (this.roleTypeId != null) {
                this.setKimType(KimApiServiceLocator.getKimTypeInfoService().getKimType(this.roleTypeId));
                if (this.kimType != null) {
                    this.roleTypeName = this.kimType.getName();
                }
            }
        }
        return this.roleTypeName;
    }

    public void setRoleTypeName(String roleTypeName) {
        this.roleTypeName = roleTypeName;
    }

    @Override
    public List<RoleDocumentDelegationMember> getDelegationMembers() {
        return this.delegationMembers;
    }

    @Override
    public void setDelegationMembers(List<RoleDocumentDelegationMember> delegationMembers) {
        this.delegationMembers = delegationMembers;
    }

    public List<KimDocumentRolePermission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<KimDocumentRolePermission> permissions) {
        this.permissions = permissions;
    }

    public List<KimDocumentRoleResponsibility> getResponsibilities() {
        return this.responsibilities;
    }

    public void setResponsibilities(List<KimDocumentRoleResponsibility> responsibilities) {
        this.responsibilities = responsibilities;
    }

    public List<KimDocumentRoleMember> getMembers() {
        return this.members;
    }

    public void setMemberMetaDataTypeToSort(Integer columnNumber) {
        switch (columnNumber) {
            case 1: {
                this.memberMetaDataType = RoleMemberMetaDataType.MEMBER_ID;
                break;
            }
            case 2: {
                this.memberMetaDataType = RoleMemberMetaDataType.MEMBER_NAME;
                break;
            }
            case 3: {
                this.memberMetaDataType = RoleMemberMetaDataType.FULL_MEMBER_NAME;
                break;
            }
            default: {
                this.memberMetaDataType = RoleMemberMetaDataType.MEMBER_NAME;
            }
        }
    }

    public RoleMemberMetaDataType getMemberMetaDataType() {
        return this.memberMetaDataType;
    }

    public void setMemberMetaDataType(RoleMemberMetaDataType memberMetaDataType) {
        this.memberMetaDataType = memberMetaDataType;
    }

    public KimDocumentRoleMember getMember(String roleMemberId) {
        if (StringUtils.isEmpty((String)roleMemberId)) {
            return null;
        }
        for (KimDocumentRoleMember roleMember : this.getMembers()) {
            if (!roleMemberId.equals(roleMember.getRoleMemberId())) continue;
            return roleMember;
        }
        return null;
    }

    public void setMembers(List<KimDocumentRoleMember> members) {
        this.members = members;
    }

    public List<KimDocumentRoleMember> getModifiedMembers() {
        return this.modifiedMembers;
    }

    public void setModifiedMembers(List<KimDocumentRoleMember> modifiedMembers) {
        this.modifiedMembers = modifiedMembers;
    }

    public List<KimDocumentRoleMember> getSearchResultMembers() {
        return this.searchResultMembers;
    }

    public void setSearchResultMembers(List<KimDocumentRoleMember> searchResultMembers) {
        this.searchResultMembers = searchResultMembers;
    }

    public void addResponsibility(KimDocumentRoleResponsibility roleResponsibility) {
        if (!this.getResponsibilityInternalService().areActionsAtAssignmentLevelById(roleResponsibility.getResponsibilityId())) {
            roleResponsibility.getRoleRspActions().add(this.getNewRespAction(roleResponsibility));
        }
        this.getResponsibilities().add(roleResponsibility);
    }

    protected KimDocumentRoleResponsibilityAction getNewRespAction(KimDocumentRoleResponsibility roleResponsibility) {
        KimDocumentRoleResponsibilityAction roleRspAction = new KimDocumentRoleResponsibilityAction();
        roleRspAction.setKimResponsibility(roleResponsibility.getKimResponsibility());
        roleRspAction.setRoleResponsibilityId(roleResponsibility.getRoleResponsibilityId());
        return roleRspAction;
    }

    public void addDelegationMember(RoleDocumentDelegationMember newDelegationMember) {
        this.getDelegationMembers().add(newDelegationMember);
    }

    public void addMember(KimDocumentRoleMember member) {
        SequenceAccessorService sas = this.getSequenceAccessorService();
        Long nextSeq = sas.getNextAvailableSequenceNumber("KRIM_ROLE_MBR_ID_S", KimDocumentRoleMember.class);
        String roleMemberId = nextSeq.toString();
        member.setRoleMemberId(roleMemberId);
        this.setupMemberRspActions(member);
        this.getModifiedMembers().add(member);
    }

    public KimDocumentRoleMember getBlankMember() {
        KimDocumentRoleMember member = new KimDocumentRoleMember();
        if (this.getDefinitions() != null) {
            for (KimAttributeField key : this.getDefinitions()) {
                KimDocumentRoleQualifier qualifier = new KimDocumentRoleQualifier();
                qualifier.setKimAttrDefnId(this.getKimAttributeDefnId(key));
                member.getQualifiers().add(qualifier);
            }
        }
        this.setupMemberRspActions(member);
        return member;
    }

    public RoleDocumentDelegationMember getBlankDelegationMember() {
        RoleDocumentDelegationMember member = new RoleDocumentDelegationMember();
        if (this.getDefinitions() != null) {
            for (KimAttributeField key : this.getDefinitions()) {
                RoleDocumentDelegationMemberQualifier qualifier = new RoleDocumentDelegationMemberQualifier();
                this.setAttrDefnIdForDelMemberQualifier(qualifier, key);
                member.getQualifiers().add(qualifier);
            }
        }
        return member;
    }

    public void setupMemberRspActions(KimDocumentRoleMember member) {
        member.getRoleRspActions().clear();
        for (KimDocumentRoleResponsibility roleResp : this.getResponsibilities()) {
            if (!this.getResponsibilityInternalService().areActionsAtAssignmentLevelById(roleResp.getResponsibilityId())) continue;
            KimDocumentRoleResponsibilityAction action = new KimDocumentRoleResponsibilityAction();
            action.setRoleResponsibilityId("*");
            action.setRoleMemberId(member.getRoleMemberId());
            member.getRoleRspActions().add(action);
            break;
        }
    }

    public void updateMembers(IdentityManagementRoleDocumentForm roleDocumentForm) {
        for (KimDocumentRoleMember member : roleDocumentForm.getRoleDocument().getMembers()) {
            roleDocumentForm.getRoleDocument().setupMemberRspActions(member);
        }
    }

    public void updateMembers(KimDocumentRoleResponsibility newResponsibility) {
        for (KimDocumentRoleMember member : this.getMembers()) {
            this.setupMemberRspActions(newResponsibility, member);
        }
    }

    public void setupMemberRspActions(KimDocumentRoleResponsibility roleResp, KimDocumentRoleMember member) {
        if ((member.getRoleRspActions() == null || member.getRoleRspActions().size() < 1) && this.getResponsibilityInternalService().areActionsAtAssignmentLevelById(roleResp.getResponsibilityId())) {
            KimDocumentRoleResponsibilityAction action = new KimDocumentRoleResponsibilityAction();
            action.setRoleResponsibilityId("*");
            action.setRoleMemberId(member.getRoleMemberId());
            if (member.getRoleRspActions() == null) {
                member.setRoleRspActions(new ArrayList<KimDocumentRoleResponsibilityAction>());
            }
            member.getRoleRspActions().add(action);
        }
    }

    protected void setAttrDefnIdForDelMemberQualifier(RoleDocumentDelegationMemberQualifier qualifier, KimAttributeField definition) {
        qualifier.setKimAttrDefnId(definition.getId());
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (this.getDocumentHeader().getWorkflowDocument().isProcessed()) {
            KIMServiceLocatorInternal.getUiDocumentService().saveRole(this);
        }
    }

    public void initializeDocumentForNewRole() {
        if (StringUtils.isBlank((String)this.roleId)) {
            SequenceAccessorService sas = this.getSequenceAccessorService();
            Long nextSeq = sas.getNextAvailableSequenceNumber("KRIM_ROLE_ID_S", ((Object)((Object)this)).getClass());
            this.roleId = nextSeq.toString();
        }
        if (StringUtils.isBlank((String)this.roleTypeId)) {
            this.roleTypeId = "1";
        }
    }

    public String getRoleId() {
        if (StringUtils.isBlank((String)this.roleId)) {
            this.initializeDocumentForNewRole();
        }
        return this.roleId;
    }

    public void prepareForSave() {
        Long nextSeq;
        String roleId;
        SequenceAccessorService sas = this.getSequenceAccessorService();
        if (StringUtils.isBlank((String)this.getRoleId())) {
            Long nextSeq2 = sas.getNextAvailableSequenceNumber("KRIM_ROLE_ID_S", ((Object)((Object)this)).getClass());
            roleId = nextSeq2.toString();
            this.setRoleId(roleId);
        } else {
            roleId = this.getRoleId();
        }
        if (this.getPermissions() != null) {
            for (KimDocumentRolePermission permission : this.getPermissions()) {
                permission.setRoleId(roleId);
                if (!StringUtils.isBlank((String)permission.getRolePermissionId())) continue;
                nextSeq = sas.getNextAvailableSequenceNumber("KRIM_ROLE_PERM_ID_S", KimDocumentRolePermission.class);
                String rolePermissionId = nextSeq.toString();
                permission.setRolePermissionId(rolePermissionId);
            }
        }
        if (this.getResponsibilities() != null) {
            for (KimDocumentRoleResponsibility responsibility : this.getResponsibilities()) {
                if (StringUtils.isBlank((String)responsibility.getRoleResponsibilityId())) {
                    nextSeq = sas.getNextAvailableSequenceNumber("KRIM_ROLE_RSP_ID_S", KimDocumentRoleResponsibility.class);
                    String roleResponsibilityId = nextSeq.toString();
                    responsibility.setRoleResponsibilityId(roleResponsibilityId);
                }
                responsibility.setRoleId(roleId);
                if (this.getResponsibilityInternalService().areActionsAtAssignmentLevelById(responsibility.getResponsibilityId())) continue;
                if (StringUtils.isBlank((String)responsibility.getRoleRspActions().get(0).getRoleResponsibilityActionId())) {
                    nextSeq = sas.getNextAvailableSequenceNumber("KRIM_ROLE_RSP_ACTN_ID_S", KimDocumentRoleResponsibilityAction.class);
                    String roleResponsibilityActionId = nextSeq.toString();
                    responsibility.getRoleRspActions().get(0).setRoleResponsibilityActionId(roleResponsibilityActionId);
                }
                responsibility.getRoleRspActions().get(0).setRoleMemberId("*");
                responsibility.getRoleRspActions().get(0).setDocumentNumber(this.getDocumentNumber());
            }
        }
        if (this.getModifiedMembers() != null) {
            for (KimDocumentRoleMember member : this.getModifiedMembers()) {
                member.setRoleId(roleId);
                if (StringUtils.isBlank((String)member.getRoleMemberId())) {
                    Long nextSeq3 = sas.getNextAvailableSequenceNumber("KRIM_ROLE_MBR_ID_S", KimDocumentRoleMember.class);
                    String roleMemberId = nextSeq3.toString();
                    member.setRoleMemberId(roleMemberId);
                }
                for (KimDocumentRoleQualifier qualifier : member.getQualifiers()) {
                    qualifier.setKimTypId(this.getKimType().getId());
                }
                for (KimDocumentRoleResponsibilityAction roleRespAction : member.getRoleRspActions()) {
                    if (StringUtils.isBlank((String)roleRespAction.getRoleResponsibilityActionId())) {
                        Long nextSeq4 = sas.getNextAvailableSequenceNumber("KRIM_ROLE_RSP_ACTN_ID_S", KimDocumentRoleResponsibilityAction.class);
                        String roleResponsibilityActionId = nextSeq4.toString();
                        roleRespAction.setRoleResponsibilityActionId(roleResponsibilityActionId);
                    }
                    roleRespAction.setRoleMemberId(member.getRoleMemberId());
                    roleRespAction.setDocumentNumber(this.getDocumentNumber());
                    if (!StringUtils.equals((String)roleRespAction.getRoleResponsibilityId(), (String)"*")) {
                        for (KimDocumentRoleResponsibility responsibility : this.getResponsibilities()) {
                            if (!StringUtils.equals((String)roleRespAction.getKimResponsibility().getId(), (String)responsibility.getResponsibilityId())) continue;
                            roleRespAction.setRoleResponsibilityId(responsibility.getRoleResponsibilityId());
                        }
                    }
                    if (!ObjectUtils.isNull((Object)roleRespAction.getVersionNumber())) continue;
                    roleRespAction.setVersionNumber(new Long(1L));
                }
            }
        }
        if (this.getDelegationMembers() != null) {
            for (RoleDocumentDelegationMember delegationMember : this.getDelegationMembers()) {
                delegationMember.setDocumentNumber(this.getDocumentNumber());
                this.addDelegationMemberToDelegation(delegationMember);
            }
            for (RoleDocumentDelegation delegation : this.getDelegations()) {
                delegation.setDocumentNumber(this.getDocumentNumber());
                delegation.setKimTypeId(this.getKimType().getId());
                AutoPopulatingList membersToRemove = new AutoPopulatingList(RoleDocumentDelegationMember.class);
                for (RoleDocumentDelegationMember member : delegation.getMembers()) {
                    if (delegation.getDelegationId().equals(member.getDelegationId()) && delegation.getDelegationTypeCode().equals(member.getDelegationTypeCode())) {
                        for (RoleDocumentDelegationMemberQualifier qualifier : member.getQualifiers()) {
                            qualifier.setKimTypId(this.getKimType().getId());
                        }
                        continue;
                    }
                    membersToRemove.add(member);
                }
                if (!membersToRemove.isEmpty()) {
                    for (RoleDocumentDelegationMember member : membersToRemove) {
                        delegation.getMembers().remove((Object)member);
                    }
                }
                delegation.setRoleId(roleId);
            }
        }
    }

    public ResponsibilityService getResponsibilityService() {
        if (this.responsibilityService == null) {
            this.responsibilityService = KimApiServiceLocator.getResponsibilityService();
        }
        return this.responsibilityService;
    }

    public ResponsibilityInternalService getResponsibilityInternalService() {
        if (this.responsibilityInternalService == null) {
            this.responsibilityInternalService = KimImplServiceLocator.getResponsibilityInternalService();
        }
        return this.responsibilityInternalService;
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setEditing(boolean editing) {
        this.editing = editing;
    }

    @Override
    public List<RoleDocumentDelegation> getDelegations() {
        return this.delegations;
    }

    @Override
    public void setDelegations(List<RoleDocumentDelegation> delegations) {
        this.delegations = delegations;
    }

    @Override
    public void setKimType(KimType kimType) {
        super.setKimType(kimType);
        if (kimType != null) {
            this.setRoleTypeId(kimType.getId());
            this.setRoleTypeName(kimType.getName());
        }
    }

    public static enum RoleMemberMetaDataType implements Comparator<KimDocumentRoleMember>
    {
        MEMBER_ID("memberId"),
        MEMBER_NAME("memberName"),
        FULL_MEMBER_NAME("memberFullName");

        private final String attributeName;

        private RoleMemberMetaDataType(String anAttributeName) {
            this.attributeName = anAttributeName;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public int compare(KimDocumentRoleMember m1, KimDocumentRoleMember m2) {
            if (m1 == null && m2 == null) {
                return 0;
            }
            if (m1 == null) {
                return -1;
            }
            if (m2 == null) {
                return 1;
            }
            if (this.getAttributeName().equals(MEMBER_ID.getAttributeName())) {
                return m1.getMemberId().compareToIgnoreCase(m2.getMemberId());
            }
            if (this.getAttributeName().equals(FULL_MEMBER_NAME.getAttributeName())) {
                return m1.getMemberFullName().compareToIgnoreCase(m2.getMemberFullName());
            }
            return m1.getMemberName().compareToIgnoreCase(m2.getMemberName());
        }
    }
}

