/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.document.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.kim.api.type.KimTypeAttribute;
import org.kuali.rice.kim.bo.ui.KimDocumentAttributeDataBusinessObjectBase;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeBo;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeDataBo;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public class AttributeValidationHelper {
    private static final Logger LOG = Logger.getLogger(AttributeValidationHelper.class);
    private static final String DOCUMENT_PROPERTY_PREFIX = "document.";
    protected BusinessObjectService businessObjectService;
    protected Map<String, KimAttributeBo> attributeDefinitionMap = new HashMap<String, KimAttributeBo>();

    protected KimAttributeBo getAttributeDefinition(String id) {
        KimAttributeBo attributeImpl = this.attributeDefinitionMap.get(id);
        if (attributeImpl == null) {
            HashMap<String, String> criteria = new HashMap<String, String>();
            criteria.put("id", id);
            attributeImpl = (KimAttributeBo)this.getBusinessObjectService().findByPrimaryKey(KimAttributeBo.class, criteria);
            this.attributeDefinitionMap.put(id, attributeImpl);
        }
        return attributeImpl;
    }

    public Map<String, String> convertAttributesToMap(List<? extends KimAttributeDataBo> attributes) {
        HashMap<String, String> m = new HashMap<String, String>();
        for (KimAttributeDataBo kimAttributeDataBo : attributes) {
            KimAttributeBo attrib = this.getAttributeDefinition(kimAttributeDataBo.getKimAttributeId());
            if (attrib != null) {
                m.put(attrib.getAttributeName(), kimAttributeDataBo.getAttributeValue());
                continue;
            }
            LOG.error((Object)("Unable to get attribute name for ID:" + kimAttributeDataBo.getKimAttributeId()));
        }
        return m;
    }

    public Map<String, String> convertQualifiersToMap(List<? extends KimDocumentAttributeDataBusinessObjectBase> qualifiers) {
        HashMap<String, String> m = new HashMap<String, String>();
        for (KimDocumentAttributeDataBusinessObjectBase kimDocumentAttributeDataBusinessObjectBase : qualifiers) {
            KimAttributeBo attrib = this.getAttributeDefinition(kimDocumentAttributeDataBusinessObjectBase.getKimAttrDefnId());
            if (attrib != null) {
                m.put(attrib.getAttributeName(), kimDocumentAttributeDataBusinessObjectBase.getAttrVal());
                continue;
            }
            LOG.error((Object)("Unable to get attribute name for ID:" + kimDocumentAttributeDataBusinessObjectBase.getKimAttrDefnId()));
        }
        return m;
    }

    public Map<String, String> getBlankValueQualifiersMap(List<KimTypeAttribute> attributes) {
        HashMap<String, String> m = new HashMap<String, String>();
        for (KimTypeAttribute attribute : attributes) {
            KimAttributeBo attrib = this.getAttributeDefinition(attribute.getKimAttribute().getId());
            if (attrib != null) {
                m.put(attrib.getAttributeName(), "");
                continue;
            }
            LOG.error((Object)("Unable to get attribute name for ID:" + attribute.getId()));
        }
        return m;
    }

    public Map<String, String> convertQualifiersToAttrIdxMap(List<? extends KimDocumentAttributeDataBusinessObjectBase> qualifiers) {
        HashMap<String, String> m = new HashMap<String, String>();
        int i = 0;
        for (KimDocumentAttributeDataBusinessObjectBase kimDocumentAttributeDataBusinessObjectBase : qualifiers) {
            KimAttributeBo attrib = this.getAttributeDefinition(kimDocumentAttributeDataBusinessObjectBase.getKimAttrDefnId());
            if (attrib != null) {
                m.put(attrib.getAttributeName(), Integer.toString(i));
            } else {
                LOG.error((Object)("Unable to get attribute name for ID:" + kimDocumentAttributeDataBusinessObjectBase.getKimAttrDefnId()));
            }
            ++i;
        }
        return m;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KRADServiceLocator.getBusinessObjectService();
        }
        return this.businessObjectService;
    }

    public void moveValidationErrorsToErrorMap(List<RemotableAttributeError> validationErrors) {
        for (RemotableAttributeError error : validationErrors) {
            for (String errMsg : error.getErrors()) {
                String[] splitMsg = StringUtils.split((String)errMsg, (String)":");
                if (error.getAttributeName().startsWith(DOCUMENT_PROPERTY_PREFIX)) {
                    GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(error.getAttributeName(), splitMsg[0], splitMsg.length > 1 ? StringUtils.split((String)splitMsg[1], (String)";") : new String[]{});
                    continue;
                }
                GlobalVariables.getMessageMap().putError(error.getAttributeName(), splitMsg[0], splitMsg.length > 1 ? StringUtils.split((String)splitMsg[1], (String)";") : new String[]{});
            }
        }
    }

    public List<RemotableAttributeError> convertErrorsForMappedFields(String errorPath, List<RemotableAttributeError> localErrors) {
        ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>();
        if (errorPath == null) {
            errorPath = "";
        } else if (StringUtils.isNotEmpty((String)errorPath)) {
            errorPath = errorPath + ".";
        }
        for (RemotableAttributeError error : localErrors) {
            HashMap<String, String> criteria = new HashMap<String, String>();
            criteria.put("attributeName", error.getAttributeName());
            KimAttributeBo attribute = (KimAttributeBo)this.getBusinessObjectService().findByPrimaryKey(KimAttributeBo.class, criteria);
            String attributeDefnId = attribute == null ? "" : attribute.getId();
            errors.add(RemotableAttributeError.Builder.create((String)(errorPath + "qualifier(" + attributeDefnId + ").attrVal"), (List)error.getErrors()).build());
        }
        return errors;
    }

    public List<RemotableAttributeError> convertErrors(String errorPath, Map<String, String> attrIdxMap, List<RemotableAttributeError> localErrors) {
        ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>();
        if (errorPath == null) {
            errorPath = "";
        } else if (StringUtils.isNotEmpty((String)errorPath)) {
            errorPath = errorPath + ".";
        }
        for (RemotableAttributeError error : localErrors) {
            for (String errMsg : error.getErrors()) {
                errors.add(RemotableAttributeError.Builder.create((String)(errorPath + "qualifiers[" + attrIdxMap.get(error.getAttributeName()) + "].attrVal"), (String[])new String[]{errMsg}).build());
            }
        }
        return errors;
    }
}

