/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.responsibility;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.responsibility.Responsibility;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleResponsibility;
import org.kuali.rice.kim.document.IdentityManagementRoleDocument;
import org.kuali.rice.kim.impl.responsibility.AddResponsibilityEvent;
import org.kuali.rice.kim.impl.responsibility.AddResponsibilityRule;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityBo;
import org.kuali.rice.kns.rules.DocumentRuleBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class KimDocumentResponsibilityRule
extends DocumentRuleBase
implements AddResponsibilityRule {
    public static final String ERROR_PATH = "document.responsibility.responsibilityId";

    @Override
    public boolean processAddResponsibility(AddResponsibilityEvent addResponsibilityEvent) {
        KimDocumentRoleResponsibility newResponsibility = addResponsibilityEvent.getResponsibility();
        if (newResponsibility == null) {
            GlobalVariables.getMessageMap().putError(ERROR_PATH, "error.empty.entry", new String[]{"Responsibility"});
            return false;
        }
        ResponsibilityBo kimResponsibilityImpl = newResponsibility.getKimResponsibility();
        if (kimResponsibilityImpl == null) {
            GlobalVariables.getMessageMap().putError(ERROR_PATH, "error.empty.entry", new String[]{"Responsibility"});
            return false;
        }
        IdentityManagementRoleDocument document = (IdentityManagementRoleDocument)addResponsibilityEvent.getDocument();
        boolean rulePassed = true;
        if (!this.hasPermissionToGrantResponsibility(ResponsibilityBo.to((ResponsibilityBo)kimResponsibilityImpl), document)) {
            GlobalVariables.getMessageMap().putError(ERROR_PATH, "error.assign.responsibility", new String[]{kimResponsibilityImpl.getNamespaceCode(), kimResponsibilityImpl.getTemplate().getName()});
            return false;
        }
        if (newResponsibility == null || StringUtils.isBlank((String)newResponsibility.getResponsibilityId())) {
            rulePassed = false;
            GlobalVariables.getMessageMap().putError(ERROR_PATH, "error.empty.entry", new String[]{"Responsibility"});
        } else {
            int i = 0;
            for (KimDocumentRoleResponsibility responsibility : document.getResponsibilities()) {
                if (responsibility.getResponsibilityId().equals(newResponsibility.getResponsibilityId())) {
                    rulePassed = false;
                    GlobalVariables.getMessageMap().putError("document.responsibilities[" + i + "].responsibilityId", "error.duplicate.entry", new String[]{"Responsibility"});
                }
                ++i;
            }
        }
        return rulePassed;
    }

    @Override
    public boolean hasPermissionToGrantResponsibility(Responsibility kimResponsibilityInfo, IdentityManagementRoleDocument document) {
        HashMap<String, String> responsibilityDetails = new HashMap<String, String>();
        responsibilityDetails.put("namespaceCode", kimResponsibilityInfo.getNamespaceCode());
        responsibilityDetails.put("responsibilityName", kimResponsibilityInfo.getName());
        return KimDocumentResponsibilityRule.getDocumentDictionaryService().getDocumentAuthorizer((Document)document).isAuthorizedByTemplate((Object)document, "KR-IDM", "Grant Responsibility", GlobalVariables.getUserSession().getPerson().getPrincipalId(), responsibilityDetails, null);
    }
}

