/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.dao.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceException;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.ejb.HibernateEntityManager;
import org.hibernate.proxy.HibernateProxy;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.core.framework.persistence.jpa.criteria.Criteria;
import org.kuali.rice.core.framework.persistence.jpa.criteria.QueryByCriteria;
import org.kuali.rice.core.framework.persistence.jpa.metadata.MetadataManager;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObjectExtension;
import org.kuali.rice.krad.dao.BusinessObjectDao;
import org.kuali.rice.krad.service.PersistenceStructureService;
import org.kuali.rice.krad.util.OjbCollectionHelper;
import org.springframework.dao.DataAccessException;

public class BusinessObjectDaoJpa
implements BusinessObjectDao {
    @PersistenceContext
    private EntityManager entityManager;
    private PersistenceStructureService persistenceStructureService;
    private OjbCollectionHelper ojbCollectionHelper;

    public BusinessObjectDaoJpa(EntityManager entityManager, PersistenceStructureService persistenceStructureService) {
        this.entityManager = entityManager;
        this.persistenceStructureService = persistenceStructureService;
    }

    @Override
    public <T extends BusinessObject> T findBySinglePrimaryKey(Class<T> clazz, Object primaryKey) {
        return (T)((BusinessObject)this.entityManager.find(clazz, primaryKey));
    }

    @Override
    public <T extends BusinessObject> T findByPrimaryKey(Class<T> clazz, Map<String, ?> primaryKeys) {
        if (primaryKeys == null || primaryKeys.isEmpty()) {
            return null;
        }
        BusinessObject bo = null;
        try {
            bo = (BusinessObject)new QueryByCriteria(this.entityManager, this.buildJpaCriteria(clazz, primaryKeys)).toQuery().getSingleResult();
        }
        catch (PersistenceException e) {
            // empty catch block
        }
        return (T)bo;
    }

    @Override
    public <T extends BusinessObject> T findByPrimaryKeyUsingKeyObject(Class<T> clazz, Object pkObject) {
        if (pkObject == null) {
            return null;
        }
        BusinessObject bo = null;
        try {
            bo = (BusinessObject)this.entityManager.find(clazz, pkObject);
        }
        catch (PersistenceException e) {
            // empty catch block
        }
        return (T)bo;
    }

    @Override
    public <T extends BusinessObject> Collection<T> findAll(Class<T> clazz) {
        return new QueryByCriteria(this.entityManager, new Criteria(clazz.getName())).toQuery().getResultList();
    }

    @Override
    public <T extends BusinessObject> Collection<T> findAllOrderBy(Class<T> clazz, String sortField, boolean sortAscending) {
        Criteria criteria = new Criteria(clazz.getName());
        criteria.orderBy(sortField, sortAscending);
        return new QueryByCriteria(this.entityManager, criteria).toQuery().getResultList();
    }

    @Override
    public <T extends BusinessObject> Collection<T> findMatching(Class<T> clazz, Map<String, ?> fieldValues) {
        return new QueryByCriteria(this.entityManager, this.buildJpaCriteria(clazz, fieldValues)).toQuery().getResultList();
    }

    public <T extends BusinessObject> Collection<T> findMatching(Criteria criteria) {
        return new QueryByCriteria(this.entityManager, criteria).toQuery().getResultList();
    }

    @Override
    public <T extends BusinessObject> Collection<T> findAllActive(Class<T> clazz) {
        return new QueryByCriteria(this.entityManager, this.buildActiveJpaCriteria(clazz)).toQuery().getResultList();
    }

    @Override
    public <T extends BusinessObject> Collection<T> findAllInactive(Class<T> clazz) {
        return new QueryByCriteria(this.entityManager, this.buildInactiveJpaCriteria(clazz)).toQuery().getResultList();
    }

    @Override
    public <T extends BusinessObject> Collection<T> findAllActiveOrderBy(Class<T> clazz, String sortField, boolean sortAscending) {
        Criteria criteria = this.buildActiveJpaCriteria(clazz);
        criteria.orderBy(sortField, sortAscending);
        return new QueryByCriteria(this.entityManager, criteria).toQuery().getResultList();
    }

    @Override
    public <T extends BusinessObject> Collection<T> findMatchingActive(Class<T> clazz, Map<String, ?> fieldValues) {
        Criteria criteria = this.buildJpaCriteria(clazz, fieldValues);
        criteria.and(this.buildActiveJpaCriteria(clazz));
        return new QueryByCriteria(this.entityManager, criteria).toQuery().getResultList();
    }

    @Override
    public int countMatching(Class clazz, Map<String, ?> fieldValues) {
        return ((Long)new QueryByCriteria(this.entityManager, this.buildJpaCriteria(clazz, fieldValues)).toCountQuery().getSingleResult()).intValue();
    }

    @Override
    public int countMatching(Class clazz, Map<String, ?> positiveFieldValues, Map<String, ?> negativeFieldValues) {
        Criteria criteria = this.buildJpaCriteria(clazz, positiveFieldValues);
        criteria.and(this.buildNegativeJpaCriteria(clazz, negativeFieldValues));
        return ((Long)new QueryByCriteria(this.entityManager, criteria).toCountQuery().getSingleResult()).intValue();
    }

    @Override
    public <T extends BusinessObject> Collection<T> findMatchingOrderBy(Class<T> clazz, Map<String, ?> fieldValues, String sortField, boolean sortAscending) {
        Criteria criteria = this.buildJpaCriteria(clazz, fieldValues);
        criteria.orderBy(sortField, sortAscending);
        return new QueryByCriteria(this.entityManager, criteria).toQuery().getResultList();
    }

    @Override
    public PersistableBusinessObject save(PersistableBusinessObject bo) throws DataAccessException {
        if (this.entityManager.contains((Object)bo) && ((HibernateEntityManager)this.entityManager).getSession().isReadOnly((Object)bo)) {
            ((HibernateEntityManager)this.entityManager).getSession().setReadOnly((Object)bo, false);
        }
        return this.reattachAndSave(bo);
    }

    @Override
    public List<? extends PersistableBusinessObject> save(List businessObjects) throws DataAccessException {
        ArrayList<PersistableBusinessObject> savedBOs = new ArrayList<PersistableBusinessObject>();
        for (Object bo : businessObjects) {
            PersistableBusinessObject savedBusinessObject = this.reattachAndSave((PersistableBusinessObject)bo);
            savedBOs.add(savedBusinessObject);
        }
        return savedBOs;
    }

    @Override
    public void delete(PersistableBusinessObject bo) {
        PersistableBusinessObject realPBO = this.materialize(bo);
        if (realPBO != null) {
            if (realPBO.getExtension() != null) {
                this.delete((PersistableBusinessObject)realPBO.getExtension());
            }
            if (this.entityManager.contains((Object)realPBO)) {
                this.entityManager.remove((Object)realPBO);
            } else {
                PersistableBusinessObject foundBO = (PersistableBusinessObject)this.entityManager.find(realPBO.getClass(), MetadataManager.getEntityPrimaryKeyObject((Object)realPBO));
                if (foundBO != null) {
                    this.entityManager.remove((Object)foundBO);
                }
            }
        }
    }

    protected PersistableBusinessObject materialize(PersistableBusinessObject bo) {
        try {
            if (bo instanceof HibernateProxy) {
                return (PersistableBusinessObject)((HibernateProxy)bo).getHibernateLazyInitializer().getImplementation();
            }
            return bo;
        }
        catch (EntityNotFoundException enfe) {
            return null;
        }
    }

    @Override
    public void delete(List<? extends PersistableBusinessObject> boList) {
        for (PersistableBusinessObject persistableBusinessObject : boList) {
            this.delete(persistableBusinessObject);
        }
    }

    @Override
    public void deleteMatching(Class clazz, Map<String, ?> fieldValues) {
        new QueryByCriteria(this.entityManager, this.buildJpaCriteria(clazz, fieldValues), QueryByCriteria.QueryByCriteriaType.DELETE).toQuery().executeUpdate();
    }

    @Override
    public PersistableBusinessObject retrieve(PersistableBusinessObject object) {
        PersistableBusinessObject pbo = null;
        Object pkObject = MetadataManager.getEntityPrimaryKeyObject((Object)object);
        if (pkObject != null && (pbo = (PersistableBusinessObject)this.entityManager.find(object.getClass(), pkObject)) != null && pbo.getExtension() != null) {
            pbo.setExtension((PersistableBusinessObjectExtension)this.entityManager.find(pbo.getExtension().getClass(), MetadataManager.getPersistableBusinessObjectPrimaryKeyObjectWithValuesForExtension((Object)pbo, (Object)pbo.getExtension())));
        }
        return pbo;
    }

    private Criteria buildJpaCriteria(Class clazz, Map<String, ?> fieldValues) {
        Criteria criteria = new Criteria(clazz.getName());
        for (Map.Entry<String, ?> e : fieldValues.entrySet()) {
            String key = e.getKey();
            Object value = e.getValue();
            String alias = "";
            String[] keySplit = key.split("\\.");
            if (keySplit.length > 1) {
                alias = keySplit[keySplit.length - 2];
                String variableKey = keySplit[keySplit.length - 1];
                for (int j = 0; j < keySplit.length - 1; ++j) {
                    if (criteria.getAliasIndex(keySplit[j]) != -1) continue;
                    criteria.join(keySplit[j], keySplit[j], false, true);
                }
                key = "__JPA_ALIAS[['" + alias + "']]__." + variableKey;
            }
            if (value == null) continue;
            if (value instanceof Collection) {
                criteria.in(key, (Collection)value);
                continue;
            }
            criteria.eq(key, value);
        }
        return criteria;
    }

    private Criteria buildActiveJpaCriteria(Class clazz) {
        Criteria criteria = new Criteria(clazz.getName());
        criteria.eq("active", (Object)true);
        return criteria;
    }

    private Criteria buildInactiveJpaCriteria(Class clazz) {
        Criteria criteria = new Criteria(clazz.getName());
        criteria.eq("active", (Object)false);
        return criteria;
    }

    private Criteria buildNegativeJpaCriteria(Class clazz, Map negativeFieldValues) {
        Criteria criteria = new Criteria(clazz.getName());
        for (Map.Entry e : negativeFieldValues.entrySet()) {
            String key = (String)e.getKey();
            Object value = e.getValue();
            if (value instanceof Collection) {
                criteria.notIn(key, (Collection)((List)value));
                continue;
            }
            criteria.ne(key, value);
        }
        return criteria;
    }

    @Override
    public PersistableBusinessObject manageReadOnly(PersistableBusinessObject bo) {
        Session session = ((HibernateEntityManager)this.entityManager).getSession();
        FlushMode currentFlushMode = session.getFlushMode();
        session.setFlushMode(FlushMode.MANUAL);
        PersistableBusinessObject managedBO = (PersistableBusinessObject)this.entityManager.merge((Object)bo);
        session.setReadOnly((Object)managedBO, true);
        session.setFlushMode(currentFlushMode);
        return managedBO;
    }

    protected PersistenceStructureService getPersistenceStructureService() {
        return this.persistenceStructureService;
    }

    public void setPersistenceStructureService(PersistenceStructureService persistenceStructureService) {
        this.persistenceStructureService = persistenceStructureService;
    }

    private PersistableBusinessObject reattachAndSave(PersistableBusinessObject bo) {
        PersistableBusinessObject attachedBo;
        PersistableBusinessObject newBo = attachedBo = (PersistableBusinessObject)this.findByPrimaryKey(bo.getClass(), MetadataManager.getEntityPrimaryKeyValuePairs((Object)bo));
        if (attachedBo == null) {
            newBo = (PersistableBusinessObject)this.entityManager.merge((Object)bo);
            if (bo.getExtension() != null) {
                this.entityManager.merge((Object)bo.getExtension());
            }
        } else {
            OrmUtils.reattach((Object)bo, (Object)attachedBo);
            newBo = (PersistableBusinessObject)this.entityManager.merge((Object)attachedBo);
        }
        return newBo;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

