/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.dao.impl;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.proxy.HibernateProxy;
import org.kuali.rice.core.framework.persistence.jpa.metadata.CollectionDescriptor;
import org.kuali.rice.core.framework.persistence.jpa.metadata.EntityDescriptor;
import org.kuali.rice.core.framework.persistence.jpa.metadata.JoinColumnDescriptor;
import org.kuali.rice.core.framework.persistence.jpa.metadata.MetadataManager;
import org.kuali.rice.core.framework.persistence.jpa.metadata.ObjectDescriptor;
import org.kuali.rice.krad.dao.PersistenceDao;
import org.kuali.rice.krad.service.KRADServiceLocator;

public class PersistenceDaoJpa
implements PersistenceDao {
    static Log LOG = LogFactory.getLog(PersistenceDaoJpa.class);
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public void clearCache() {
    }

    @Override
    public Object resolveProxy(Object o) {
        if (o instanceof HibernateProxy) {
            try {
                Object realObject = ((HibernateProxy)o).getHibernateLazyInitializer().getImplementation();
                return realObject;
            }
            catch (EntityNotFoundException enfe) {
                return null;
            }
        }
        return o;
    }

    @Override
    public void retrieveAllReferences(Object o) {
        EntityDescriptor ed = MetadataManager.getEntityDescriptor(o.getClass());
        for (ObjectDescriptor od : ed.getObjectRelationships()) {
            this.retrieveReference(o, od.getAttributeName());
        }
        for (CollectionDescriptor cd : ed.getCollectionRelationships()) {
            this.retrieveReference(o, cd.getAttributeName());
        }
    }

    @Override
    public void retrieveReference(Object o, String referenceName) {
        try {
            if (this.getEntityManager().contains(o)) {
                LOG.debug((Object)"the entity manager contains the object");
            }
            Field field = this.getField(o.getClass(), referenceName);
            field.setAccessible(true);
            Object fk = null;
            Object foreignPK = null;
            if (this.isReferenceCollection(o, referenceName)) {
                Collection reference = this.retrieveCollectionReference(o, referenceName);
                field.set(o, reference);
            } else {
                Object reference = this.retrieveObjectReference(o, referenceName);
                field.set(o, reference);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Field getField(Class clazz, String name) throws NoSuchFieldException {
        if (clazz.equals(Object.class)) {
            throw new NoSuchFieldException(name);
        }
        Field field = null;
        try {
            field = clazz.getDeclaredField(name);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (field == null) {
            field = this.getField(clazz.getSuperclass(), name);
        }
        return field;
    }

    protected boolean isReferenceCollection(Object o, String referenceName) {
        EntityDescriptor ed = MetadataManager.getEntityDescriptor(o.getClass());
        return ed.getCollectionDescriptorByName(referenceName) != null;
    }

    protected Collection retrieveCollectionReference(Object o, String referenceName) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        EntityDescriptor ed = MetadataManager.getEntityDescriptor(o.getClass());
        CollectionDescriptor cd = ed.getCollectionDescriptorByName(referenceName);
        EntityDescriptor foreignEntityDescriptor = MetadataManager.getEntityDescriptor((Class)cd.getTargetEntity());
        HashMap<String, Object> searchKey = new HashMap<String, Object>();
        for (String foreignKey : cd.getForeignKeyFields()) {
            Field localField = this.getField(o.getClass(), foreignKey);
            localField.setAccessible(true);
            Object localValue = localField.get(o);
            String foreignKeyProperty = this.getForeignKeyPropertyForKeyWithPossibleInverse(foreignKey, ed, foreignEntityDescriptor, cd);
            searchKey.put(foreignKeyProperty, localValue);
        }
        return KRADServiceLocator.getBusinessObjectService().findMatching(cd.getTargetEntity(), searchKey);
    }

    protected String getForeignKeyPropertyForKeyWithPossibleInverse(String foreignKey, EntityDescriptor localEntityDescriptor, EntityDescriptor foreignEntityDescriptor, CollectionDescriptor collectionDescriptor) {
        String foreignKeyColumn = localEntityDescriptor.getFieldByName(foreignKey).getColumn();
        JoinColumnDescriptor joinColumnDescriptor = null;
        JoinColumnDescriptor inverseColumnDescriptor = null;
        for (int count = 0; count < collectionDescriptor.getJoinColumnDescriptors().size() && joinColumnDescriptor == null; ++count) {
            if (!((JoinColumnDescriptor)collectionDescriptor.getJoinColumnDescriptors().get(count)).getName().equalsIgnoreCase(foreignKeyColumn)) continue;
            joinColumnDescriptor = (JoinColumnDescriptor)collectionDescriptor.getJoinColumnDescriptors().get(count);
            if (count >= collectionDescriptor.getInverseJoinColumnDescriptors().size()) continue;
            inverseColumnDescriptor = (JoinColumnDescriptor)collectionDescriptor.getInverseJoinColumnDescriptors().get(count);
        }
        if (inverseColumnDescriptor != null) {
            return foreignEntityDescriptor.getFieldByColumnName(inverseColumnDescriptor.getName()).getName();
        }
        if (!StringUtils.isBlank((String)joinColumnDescriptor.getReferencedColumName())) {
            return foreignEntityDescriptor.getFieldByColumnName(joinColumnDescriptor.getReferencedColumName()).getName();
        }
        return foreignEntityDescriptor.getFieldByColumnName(joinColumnDescriptor.getName()).getName();
    }

    protected Object retrieveObjectReference(Object o, String referenceName) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, InstantiationException, ClassNotFoundException {
        EntityDescriptor ed = MetadataManager.getEntityDescriptor(o.getClass());
        ObjectDescriptor od = ed.getObjectDescriptorByName(referenceName);
        Object foreignKeyObject = this.buildForeignKeyObject(o, ed, od);
        return this.getEntityManager().find(od.getTargetEntity(), foreignKeyObject);
    }

    protected Object buildForeignKeyObject(Object o, EntityDescriptor localEntityDescriptor, ObjectDescriptor objectDescriptor) throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException, InstantiationException {
        return objectDescriptor.getForeignKeyFields().size() == 1 ? this.buildSingleKeyForeignKeyObject(o, (String)objectDescriptor.getForeignKeyFields().get(0)) : this.buildCompositeForeignKeyObject(o, localEntityDescriptor, objectDescriptor);
    }

    private Object buildCompositeForeignKeyObject(Object o, EntityDescriptor localEntityDescriptor, ObjectDescriptor objectDescriptor) throws InstantiationException, IllegalAccessException, NoSuchFieldException {
        Map<String, JoinColumnDescriptor> joinColumnDescriptors = this.buildJoinColumnDescriptorMap(objectDescriptor.getJoinColumnDescriptors());
        EntityDescriptor foreignEntityDescriptor = MetadataManager.getEntityDescriptor((Class)objectDescriptor.getTargetEntity());
        Class foreignEntityIdClass = foreignEntityDescriptor.getIdClass();
        Object foreignEntityId = foreignEntityIdClass.newInstance();
        for (String foreignKey : objectDescriptor.getForeignKeyFields()) {
            Field localField = this.getField(o.getClass(), foreignKey);
            localField.setAccessible(true);
            Object localValue = localField.get(o);
            String foreignKeyProperty = this.getForeignKeyPropertyForKey(foreignKey, localEntityDescriptor, foreignEntityDescriptor, joinColumnDescriptors);
            Field foreignField = this.getField(foreignEntityId.getClass(), foreignKeyProperty);
            foreignField.setAccessible(true);
            foreignField.set(foreignEntityId, localValue);
        }
        return foreignEntityId;
    }

    protected String getForeignKeyPropertyForKey(String foreignKey, EntityDescriptor localEntityDescriptor, EntityDescriptor foreignEntityDescriptor, Map<String, JoinColumnDescriptor> joinColumnDescriptors) {
        String foreignKeyColumn = localEntityDescriptor.getFieldByName(foreignKey).getColumn();
        JoinColumnDescriptor joinColumnDescriptor = joinColumnDescriptors.get(foreignKeyColumn);
        return !StringUtils.isBlank((String)joinColumnDescriptor.getReferencedColumName()) ? foreignEntityDescriptor.getFieldByColumnName(joinColumnDescriptor.getReferencedColumName()).getName() : foreignEntityDescriptor.getFieldByColumnName(joinColumnDescriptor.getName()).getName();
    }

    protected Map<String, JoinColumnDescriptor> buildJoinColumnDescriptorMap(List<JoinColumnDescriptor> joinColumnDescriptors) {
        HashMap<String, JoinColumnDescriptor> descriptorMap = new HashMap<String, JoinColumnDescriptor>();
        for (JoinColumnDescriptor joinColumnDescriptor : joinColumnDescriptors) {
            descriptorMap.put(joinColumnDescriptor.getName(), joinColumnDescriptor);
        }
        return descriptorMap;
    }

    protected Object buildSingleKeyForeignKeyObject(Object o, String singleForeignKeyFieldName) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field singleFKField = this.getField(o.getClass(), singleForeignKeyFieldName);
        singleFKField.setAccessible(true);
        return singleFKField.get(o);
    }

    @Override
    public boolean isProxied(Object object) {
        return object instanceof HibernateProxy;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

