/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.CollectionDefinition;
import org.kuali.rice.krad.datadictionary.ComplexAttributeDefinition;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntryBase;
import org.kuali.rice.krad.datadictionary.DataObjectEntry;
import org.kuali.rice.krad.datadictionary.ReferenceDefinition;
import org.kuali.rice.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.DictionaryObjectAttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.ErrorLevel;
import org.kuali.rice.krad.datadictionary.validation.SingleAttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.capability.Constrainable;
import org.kuali.rice.krad.datadictionary.validation.constraint.Constraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.provider.ConstraintProvider;
import org.kuali.rice.krad.datadictionary.validation.processor.CollectionConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.processor.ConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.ProcessorResult;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.TransactionalDocument;
import org.kuali.rice.krad.exception.ObjectNotABusinessObjectRuntimeException;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.DictionaryValidationService;
import org.kuali.rice.krad.service.DocumentDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorInternal;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.PersistenceService;
import org.kuali.rice.krad.service.PersistenceStructureService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.workflow.service.WorkflowAttributePropertyResolutionService;

public class DictionaryValidationServiceImpl
implements DictionaryValidationService {
    private static Logger LOG = Logger.getLogger(DictionaryValidationServiceImpl.class);
    public static final String VALIDATE_METHOD = "validate";
    protected DataDictionaryService dataDictionaryService;
    protected BusinessObjectService businessObjectService;
    protected PersistenceService persistenceService;
    protected DocumentDictionaryService documentDictionaryService;
    protected WorkflowAttributePropertyResolutionService workflowAttributePropertyResolutionService;
    protected PersistenceStructureService persistenceStructureService;
    private List<CollectionConstraintProcessor> collectionConstraintProcessors;
    private List<ConstraintProvider> constraintProviders;
    private List<ConstraintProcessor> elementConstraintProcessors;

    protected final Set<BusinessObject> newIdentitySet() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    public DictionaryValidationResult validate(Object object) {
        return this.validate(object, object.getClass().getName(), true);
    }

    public DictionaryValidationResult validate(Object object, boolean doOptionalProcessing) {
        return this.validate(object, object.getClass().getName(), doOptionalProcessing);
    }

    public DictionaryValidationResult validate(Object object, String entryName) {
        return this.validate(object, entryName, true);
    }

    public DictionaryValidationResult validate(Object object, String entryName, boolean doOptionalProcessing) {
        return this.validate(object, entryName, (String)null, doOptionalProcessing);
    }

    public DictionaryValidationResult validate(Object object, String entryName, String attributeName) {
        return this.validate(object, entryName, attributeName, true);
    }

    public DictionaryValidationResult validate(Object object, String entryName, String attributeName, boolean doOptionalProcessing) {
        DataDictionaryEntry entry = this.getDataDictionaryService().getDataDictionary().getDictionaryObjectEntry(entryName);
        DictionaryObjectAttributeValueReader attributeValueReader = new DictionaryObjectAttributeValueReader(object, entryName, entry);
        attributeValueReader.setAttributeName(attributeName);
        return this.validate((AttributeValueReader)attributeValueReader, doOptionalProcessing);
    }

    public DictionaryValidationResult validate(Object object, String entryName, DataDictionaryEntry entry, boolean doOptionalProcessing) {
        DictionaryObjectAttributeValueReader attributeValueReader = new DictionaryObjectAttributeValueReader(object, entryName, entry);
        return this.validate((AttributeValueReader)attributeValueReader, doOptionalProcessing);
    }

    public void validate(String entryName, String attributeName, Object attributeValue) {
        this.validate(entryName, attributeName, attributeValue, true);
    }

    public void validate(String entryName, String attributeName, Object attributeValue, boolean doOptionalProcessing) {
        AttributeDefinition attributeDefinition = this.getDataDictionaryService().getAttributeDefinition(entryName, attributeName);
        if (attributeDefinition == null) {
            return;
        }
        SingleAttributeValueReader attributeValueReader = new SingleAttributeValueReader(attributeValue, entryName, attributeName, attributeDefinition);
        this.validate((AttributeValueReader)attributeValueReader, doOptionalProcessing);
    }

    public void validateDocument(Document document) {
        String documentEntryName = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        this.validate((Object)document, documentEntryName);
    }

    public void validateDocumentAttribute(Document document, String attributeName, String errorPrefix) {
        String documentEntryName = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        this.validate((Object)document, documentEntryName, attributeName, true);
    }

    public void validateDocumentAndUpdatableReferencesRecursively(Document document, int maxDepth, boolean validateRequired) {
        this.validateDocumentAndUpdatableReferencesRecursively(document, maxDepth, validateRequired, false);
    }

    public void validateDocumentAndUpdatableReferencesRecursively(Document document, int maxDepth, boolean validateRequired, boolean chompLastLetterSFromCollectionName) {
        String documentEntryName = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        this.validate((Object)document, documentEntryName, validateRequired);
        if (maxDepth > 0) {
            this.validateUpdatabableReferencesRecursively((BusinessObject)document, maxDepth - 1, validateRequired, chompLastLetterSFromCollectionName, this.newIdentitySet());
        }
    }

    protected void validateUpdatabableReferencesRecursively(BusinessObject businessObject, int maxDepth, boolean validateRequired, boolean chompLastLetterSFromCollectionName, Set<BusinessObject> processedBOs) {
        if (ObjectUtils.isNull((Object)businessObject) || processedBOs.contains(businessObject)) {
            return;
        }
        processedBOs.add(businessObject);
        Map references = this.persistenceStructureService.listReferenceObjectFields(businessObject.getClass());
        for (String referenceName : references.keySet()) {
            Object referenceObj;
            if (!this.persistenceStructureService.isReferenceUpdatable(businessObject.getClass(), referenceName) || ObjectUtils.isNull((Object)(referenceObj = ObjectUtils.getPropertyValue((Object)businessObject, (String)referenceName))) || !(referenceObj instanceof PersistableBusinessObject)) continue;
            BusinessObject referenceBusinessObject = (BusinessObject)referenceObj;
            GlobalVariables.getMessageMap().addToErrorPath(referenceName);
            this.validateBusinessObject(referenceBusinessObject, validateRequired);
            if (maxDepth > 0) {
                this.validateUpdatabableReferencesRecursively(referenceBusinessObject, maxDepth - 1, validateRequired, chompLastLetterSFromCollectionName, processedBOs);
            }
            GlobalVariables.getMessageMap().removeFromErrorPath(referenceName);
        }
        Map collections = this.persistenceStructureService.listCollectionObjectTypes(businessObject.getClass());
        for (String collectionName : collections.keySet()) {
            Object listObj;
            if (!this.persistenceStructureService.isCollectionUpdatable(businessObject.getClass(), collectionName) || ObjectUtils.isNull((Object)(listObj = ObjectUtils.getPropertyValue((Object)businessObject, (String)collectionName)))) continue;
            if (!(listObj instanceof List)) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)("The reference named " + collectionName + " of BO class " + businessObject.getClass().getName() + " should be of type java.util.List to be validated properly."));
                continue;
            }
            List list = (List)listObj;
            ObjectUtils.materializeObjects((Collection)list);
            for (int i = 0; i < list.size(); ++i) {
                Object o = list.get(i);
                if (!ObjectUtils.isNotNull(o) || !(o instanceof PersistableBusinessObject)) continue;
                BusinessObject element = (BusinessObject)o;
                String errorPathAddition = chompLastLetterSFromCollectionName ? StringUtils.chomp((String)collectionName, (String)"s") + "[" + Integer.toString(i) + "]" : collectionName + "[" + Integer.toString(i) + "]";
                GlobalVariables.getMessageMap().addToErrorPath(errorPathAddition);
                this.validateBusinessObject(element, validateRequired);
                if (maxDepth > 0) {
                    this.validateUpdatabableReferencesRecursively(element, maxDepth - 1, validateRequired, chompLastLetterSFromCollectionName, processedBOs);
                }
                GlobalVariables.getMessageMap().removeFromErrorPath(errorPathAddition);
            }
        }
    }

    public boolean isBusinessObjectValid(BusinessObject businessObject) {
        return this.isBusinessObjectValid(businessObject, null);
    }

    public boolean isBusinessObjectValid(BusinessObject businessObject, String prefix) {
        MessageMap errorMap = GlobalVariables.getMessageMap();
        int originalErrorCount = errorMap.getErrorCount();
        errorMap.addToErrorPath(prefix);
        this.validateBusinessObject(businessObject);
        errorMap.removeFromErrorPath(prefix);
        return errorMap.getErrorCount() == originalErrorCount;
    }

    public void validateBusinessObjectsRecursively(BusinessObject businessObject, int depth) {
        if (ObjectUtils.isNull((Object)businessObject)) {
            return;
        }
        this.validateBusinessObject(businessObject);
        this.validateBusinessObjectsFromDescriptors(businessObject, PropertyUtils.getPropertyDescriptors(businessObject.getClass()), depth);
    }

    public void validateBusinessObject(BusinessObject businessObject) {
        this.validateBusinessObject(businessObject, true);
    }

    public void validateBusinessObject(BusinessObject businessObject, boolean validateRequired) {
        if (ObjectUtils.isNull((Object)businessObject)) {
            return;
        }
        this.validate((Object)businessObject, businessObject.getClass().getName(), validateRequired);
    }

    protected void validateBusinessObjectsFromDescriptors(Object object, PropertyDescriptor[] propertyDescriptors, int depth) {
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (propertyDescriptor.getPropertyType() != null && PersistableBusinessObject.class.isAssignableFrom(propertyDescriptor.getPropertyType()) && ObjectUtils.getPropertyValue((Object)object, (String)propertyDescriptor.getName()) != null) {
                BusinessObject bo = (BusinessObject)ObjectUtils.getPropertyValue((Object)object, (String)propertyDescriptor.getName());
                if (depth == 0) {
                    GlobalVariables.getMessageMap().addToErrorPath(propertyDescriptor.getName());
                    this.validateBusinessObject(bo);
                    GlobalVariables.getMessageMap().removeFromErrorPath(propertyDescriptor.getName());
                    continue;
                }
                this.validateBusinessObjectsRecursively(bo, depth - 1);
                continue;
            }
            if (propertyDescriptor.getPropertyType() == null || !List.class.isAssignableFrom(propertyDescriptor.getPropertyType()) || ObjectUtils.getPropertyValue((Object)object, (String)propertyDescriptor.getName()) == null) continue;
            List propertyList = (List)ObjectUtils.getPropertyValue((Object)object, (String)propertyDescriptor.getName());
            for (int j = 0; j < propertyList.size(); ++j) {
                if (propertyList.get(j) == null || !(propertyList.get(j) instanceof PersistableBusinessObject)) continue;
                if (depth == 0) {
                    GlobalVariables.getMessageMap().addToErrorPath(StringUtils.chomp((String)propertyDescriptor.getName(), (String)"s") + "[" + new Integer(j).toString() + "]");
                    this.validateBusinessObject((BusinessObject)propertyList.get(j));
                    GlobalVariables.getMessageMap().removeFromErrorPath(StringUtils.chomp((String)propertyDescriptor.getName(), (String)"s") + "[" + new Integer(j).toString() + "]");
                    continue;
                }
                this.validateBusinessObjectsRecursively((BusinessObject)propertyList.get(j), depth - 1);
            }
        }
    }

    @Deprecated
    public void validatePrimitiveFromDescriptor(String entryName, Object object, PropertyDescriptor propertyDescriptor, String errorPrefix, boolean validateRequired) {
        if (null != propertyDescriptor) {
            this.validate(object, entryName, propertyDescriptor.getName(), validateRequired);
        }
    }

    public boolean validateReferenceExists(BusinessObject bo, ReferenceDefinition reference) {
        return this.validateReferenceExists(bo, reference.getAttributeName());
    }

    public boolean validateReferenceExists(BusinessObject bo, String referenceName) {
        BusinessObject referenceBo = this.businessObjectService.getReferenceIfExists(bo, referenceName);
        return ObjectUtils.isNotNull((Object)referenceBo);
    }

    public boolean validateReferenceIsActive(BusinessObject bo, ReferenceDefinition reference) {
        return this.validateReferenceIsActive(bo, reference.getAttributeName());
    }

    public boolean validateReferenceIsActive(BusinessObject bo, String referenceName) {
        BusinessObject referenceBo = this.businessObjectService.getReferenceIfExists(bo, referenceName);
        if (referenceBo == null) {
            return false;
        }
        return !(referenceBo instanceof MutableInactivatable) || ((MutableInactivatable)referenceBo).isActive();
    }

    public boolean validateReferenceExistsAndIsActive(BusinessObject bo, ReferenceDefinition reference) {
        String displayFieldName;
        boolean success = true;
        if (reference.isDisplayFieldNameSet()) {
            displayFieldName = reference.getDisplayFieldName();
        } else {
            Class<?> boClass = reference.isCollectionReference() ? reference.getCollectionBusinessObjectClass() : bo.getClass();
            displayFieldName = this.dataDictionaryService.getAttributeLabel(boClass, reference.getAttributeToHighlightOnFail());
        }
        success = reference.isCollectionReference() ? this.validateCollectionReferenceExistsAndIsActive(bo, reference, displayFieldName, StringUtils.split((String)reference.getCollection(), (String)"."), null) : this.validateReferenceExistsAndIsActive(bo, reference.getAttributeName(), reference.getAttributeToHighlightOnFail(), displayFieldName);
        return success;
    }

    private boolean validateCollectionReferenceExistsAndIsActive(BusinessObject bo, ReferenceDefinition reference, String displayFieldName, String[] intermediateCollections, String pathToAttributeI) {
        Collection referenceCollection;
        boolean success = true;
        String collectionName = intermediateCollections[0];
        intermediateCollections = (String[])ArrayUtils.removeElement((Object[])intermediateCollections, (Object)collectionName);
        try {
            referenceCollection = (Collection)PropertyUtils.getProperty((Object)bo, (String)collectionName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int pos = 0;
        Iterator iterator = referenceCollection.iterator();
        while (iterator.hasNext()) {
            String pathToAttribute = StringUtils.defaultString((String)pathToAttributeI) + collectionName + "[" + pos++ + "].";
            if (intermediateCollections.length > 0) {
                success &= this.validateCollectionReferenceExistsAndIsActive((BusinessObject)iterator.next(), reference, displayFieldName, intermediateCollections, pathToAttribute);
                continue;
            }
            String attributeToHighlightOnFail = pathToAttribute + reference.getAttributeToHighlightOnFail();
            success &= this.validateReferenceExistsAndIsActive((BusinessObject)iterator.next(), reference.getAttributeName(), attributeToHighlightOnFail, displayFieldName);
        }
        return success;
    }

    public boolean validateReferenceExistsAndIsActive(BusinessObject bo, String referenceName, String attributeToHighlightOnFail, String displayFieldName) {
        if (ObjectUtils.isNestedAttribute((String)referenceName)) {
            String nestedAttributePrefix = ObjectUtils.getNestedAttributePrefix((String)referenceName);
            String nestedAttributePrimitive = ObjectUtils.getNestedAttributePrimitive((String)referenceName);
            Object nestedObject = ObjectUtils.getPropertyValue((Object)bo, (String)nestedAttributePrefix);
            if (!(nestedObject instanceof BusinessObject)) {
                throw new ObjectNotABusinessObjectRuntimeException("Attribute requested (" + nestedAttributePrefix + ") is of class: " + "'" + nestedObject.getClass().getName() + "' and is not a " + "descendent of BusinessObject.");
            }
            return this.validateReferenceExistsAndIsActive((BusinessObject)nestedObject, nestedAttributePrimitive, attributeToHighlightOnFail, displayFieldName);
        }
        boolean success = true;
        boolean fkFieldsPopulated = true;
        List fkFields = this.getDataDictionaryService().getRelationshipSourceAttributes(bo.getClass().getName(), referenceName);
        if (fkFields != null) {
            for (String fkFieldName : fkFields) {
                Object fkFieldValue = null;
                try {
                    fkFieldValue = PropertyUtils.getProperty((Object)bo, (String)fkFieldName);
                }
                catch (IllegalAccessException e) {
                    fkFieldsPopulated = false;
                }
                catch (InvocationTargetException e) {
                    fkFieldsPopulated = false;
                }
                catch (NoSuchMethodException e) {
                    fkFieldsPopulated = false;
                }
                if (fkFieldValue == null) {
                    fkFieldsPopulated = false;
                    continue;
                }
                if (!String.class.isAssignableFrom(fkFieldValue.getClass()) || !StringUtils.isBlank((String)((String)fkFieldValue))) continue;
                fkFieldsPopulated = false;
            }
        } else if (bo instanceof PersistableBusinessObject) {
            fkFieldsPopulated = this.persistenceService.allForeignKeyValuesPopulatedForReference((PersistableBusinessObject)bo, referenceName);
        }
        if (fkFieldsPopulated) {
            boolean exists = this.validateReferenceExists(bo, referenceName);
            if (exists) {
                boolean active;
                if (!(bo instanceof MutableInactivatable && !((MutableInactivatable)bo).isActive() || (active = this.validateReferenceIsActive(bo, referenceName)))) {
                    GlobalVariables.getMessageMap().putError(attributeToHighlightOnFail, "error.inactive", new String[]{displayFieldName});
                    success &= false;
                }
            } else {
                GlobalVariables.getMessageMap().putError(attributeToHighlightOnFail, "error.existence", new String[]{displayFieldName});
                success &= false;
            }
        }
        return success;
    }

    public boolean validateDefaultExistenceChecks(BusinessObject bo) {
        boolean success = true;
        Collection references = this.getDocumentDictionaryService().getDefaultExistenceChecks(bo.getClass());
        for (ReferenceDefinition reference : references) {
            success &= this.validateReferenceExistsAndIsActive(bo, reference);
        }
        return success;
    }

    public boolean validateDefaultExistenceChecksForNewCollectionItem(BusinessObject bo, BusinessObject newCollectionItem, String collectionName) {
        boolean success = true;
        if (StringUtils.isNotBlank((String)collectionName)) {
            Collection references = this.getDocumentDictionaryService().getDefaultExistenceChecks(bo.getClass());
            for (ReferenceDefinition reference : references) {
                String displayFieldName;
                if (collectionName == null || !collectionName.equals(reference.getCollection())) continue;
                if (reference.isDisplayFieldNameSet()) {
                    displayFieldName = reference.getDisplayFieldName();
                } else {
                    Class<?> boClass = reference.isCollectionReference() ? reference.getCollectionBusinessObjectClass() : bo.getClass();
                    displayFieldName = this.dataDictionaryService.getAttributeLabel(boClass, reference.getAttributeToHighlightOnFail());
                }
                success &= this.validateReferenceExistsAndIsActive(newCollectionItem, reference.getAttributeName(), reference.getAttributeToHighlightOnFail(), displayFieldName);
            }
        }
        return success;
    }

    public boolean validateDefaultExistenceChecksForTransDoc(TransactionalDocument document) {
        boolean success = true;
        Collection references = this.getDocumentDictionaryService().getDefaultExistenceChecks((Document)document);
        for (ReferenceDefinition reference : references) {
            success &= this.validateReferenceExistsAndIsActive((BusinessObject)document, reference);
        }
        return success;
    }

    public boolean validateDefaultExistenceChecksForNewCollectionItem(TransactionalDocument document, BusinessObject newCollectionItem, String collectionName) {
        boolean success = true;
        if (StringUtils.isNotBlank((String)collectionName)) {
            Collection references = this.getDocumentDictionaryService().getDefaultExistenceChecks((Document)document);
            for (ReferenceDefinition reference : references) {
                String displayFieldName;
                if (collectionName == null || !collectionName.equals(reference.getCollection())) continue;
                if (reference.isDisplayFieldNameSet()) {
                    displayFieldName = reference.getDisplayFieldName();
                } else {
                    Class<?> boClass = reference.isCollectionReference() ? reference.getCollectionBusinessObjectClass() : document.getClass();
                    displayFieldName = this.dataDictionaryService.getAttributeLabel(boClass, reference.getAttributeToHighlightOnFail());
                }
                success &= this.validateReferenceExistsAndIsActive(newCollectionItem, reference.getAttributeName(), reference.getAttributeToHighlightOnFail(), displayFieldName);
            }
        }
        return success;
    }

    public DictionaryValidationResult validate(AttributeValueReader valueReader, boolean doOptionalProcessing) {
        DictionaryValidationResult result = new DictionaryValidationResult();
        if (valueReader.getAttributeName() == null) {
            this.validateObject(result, valueReader, doOptionalProcessing, true);
        } else {
            this.validateAttribute(result, valueReader, doOptionalProcessing);
        }
        if (result.getNumberOfErrors() > 0) {
            for (ConstraintValidationResult constraintValidationResult : result) {
                if (constraintValidationResult.getStatus().getLevel() < ErrorLevel.WARN.getLevel()) continue;
                String attributePath = constraintValidationResult.getAttributePath();
                if (attributePath == null || attributePath.isEmpty()) {
                    attributePath = constraintValidationResult.getAttributeName();
                }
                if (constraintValidationResult.getConstraintLabelKey() != null) {
                    GlobalVariables.getMessageMap().putError(attributePath, constraintValidationResult.getConstraintLabelKey(), constraintValidationResult.getErrorParameters());
                    continue;
                }
                GlobalVariables.getMessageMap().putError(attributePath, constraintValidationResult.getErrorKey(), constraintValidationResult.getErrorParameters());
            }
        }
        return result;
    }

    private void processElementConstraints(DictionaryValidationResult result, Object value, Constrainable definition, AttributeValueReader attributeValueReader, boolean doOptionalProcessing) {
        this.processConstraints(result, this.elementConstraintProcessors, value, definition, attributeValueReader, doOptionalProcessing);
    }

    private void processCollectionConstraints(DictionaryValidationResult result, Collection<?> collection, Constrainable definition, AttributeValueReader attributeValueReader, boolean doOptionalProcessing) {
        this.processConstraints(result, this.collectionConstraintProcessors, collection, definition, attributeValueReader, doOptionalProcessing);
    }

    private void processConstraints(DictionaryValidationResult result, List<? extends ConstraintProcessor> constraintProcessors, Object value, Constrainable definition, AttributeValueReader attributeValueReader, boolean doOptionalProcessing) {
        if (constraintProcessors != null) {
            Constrainable selectedDefinition = definition;
            AttributeValueReader selectedAttributeValueReader = attributeValueReader;
            LinkedList constraintQueue = new LinkedList();
            for (ConstraintProcessor constraintProcessor : constraintProcessors) {
                if (!doOptionalProcessing && constraintProcessor.isOptional()) {
                    result.addSkipped(attributeValueReader, constraintProcessor.getName());
                    continue;
                }
                Class constraintType = constraintProcessor.getConstraintType();
                for (ConstraintProvider constraintProvider : this.constraintProviders) {
                    List constraintList;
                    if (!constraintProvider.isSupported(selectedDefinition) || (constraintList = constraintProvider.getConstraints(selectedDefinition, constraintType)) == null) continue;
                    constraintQueue.addAll(constraintList);
                }
                if (constraintQueue.isEmpty()) {
                    result.addSkipped(attributeValueReader, constraintProcessor.getName());
                    continue;
                }
                LinkedList<Constraint> additionalConstraints = new LinkedList<Constraint>();
                while (!constraintQueue.isEmpty()) {
                    Constraint constraint = (Constraint)constraintQueue.poll();
                    if (!constraintType.isInstance(constraint)) {
                        result.addSkipped(attributeValueReader, constraintProcessor.getName());
                        additionalConstraints.add(constraint);
                        continue;
                    }
                    ProcessorResult processorResult = constraintProcessor.process(result, value, constraint, selectedAttributeValueReader);
                    List processorResultContraints = processorResult.getConstraints();
                    if (processorResultContraints != null && processorResultContraints.size() > 0) {
                        constraintQueue.addAll(processorResultContraints);
                    }
                    if (processorResult.isDefinitionProvided()) {
                        selectedDefinition = processorResult.getDefinition();
                    }
                    if (!processorResult.isAttributeValueReaderProvided()) continue;
                    selectedAttributeValueReader = processorResult.getAttributeValueReader();
                }
                constraintQueue.addAll(additionalConstraints);
            }
        }
    }

    private void setFieldError(String entryName, String attributeName, String key, String ... args) {
        if (this.getDataDictionaryService() == null) {
            return;
        }
        String errorLabel = this.getDataDictionaryService().getAttributeErrorLabel(entryName, attributeName);
        LinkedList<String> list = new LinkedList<String>();
        list.add(errorLabel);
        list.addAll(Arrays.asList(args));
        String[] array = new String[list.size()];
        array = list.toArray(array);
        GlobalVariables.getMessageMap().putError(attributeName, key, array);
    }

    private void validateAttribute(DictionaryValidationResult result, AttributeValueReader attributeValueReader, boolean checkIfRequired) throws AttributeValidationException {
        Constrainable definition = attributeValueReader.getDefinition(attributeValueReader.getAttributeName());
        this.validateAttribute(result, definition, attributeValueReader, checkIfRequired);
    }

    private void validateAttribute(DictionaryValidationResult result, Constrainable definition, AttributeValueReader attributeValueReader, boolean checkIfRequired) throws AttributeValidationException {
        if (definition == null) {
            throw new AttributeValidationException("Unable to validate constraints for attribute \"" + attributeValueReader.getAttributeName() + "\" on entry \"" + attributeValueReader.getEntryName() + "\" because no attribute definition can be found.");
        }
        Object value = attributeValueReader.getValue();
        this.processElementConstraints(result, value, definition, attributeValueReader, checkIfRequired);
    }

    private void validateObject(DictionaryValidationResult result, AttributeValueReader attributeValueReader, boolean doOptionalProcessing, boolean processAttributes) throws AttributeValidationException {
        DataObjectEntry entry;
        List complexAttrDefinitions;
        Constrainable objectEntry = attributeValueReader.getEntry();
        this.processElementConstraints(result, attributeValueReader.getObject(), objectEntry, attributeValueReader, doOptionalProcessing);
        List definitions = attributeValueReader.getDefinitions();
        if (null == definitions) {
            return;
        }
        if (processAttributes) {
            for (Constrainable definition : definitions) {
                String attributeName = definition.getName();
                attributeValueReader.setAttributeName(attributeName);
                if (!attributeValueReader.isReadable()) continue;
                Object value = attributeValueReader.getValue(attributeName);
                this.processElementConstraints(result, value, definition, attributeValueReader, doOptionalProcessing);
            }
        }
        if (objectEntry instanceof DataDictionaryEntryBase && (complexAttrDefinitions = ((DataDictionaryEntryBase)objectEntry).getComplexAttributes()) != null) {
            for (ComplexAttributeDefinition complexAttrDefinition : complexAttrDefinitions) {
                String attributeName = complexAttrDefinition.getName();
                attributeValueReader.setAttributeName(attributeName);
                if (!attributeValueReader.isReadable()) continue;
                Object value = attributeValueReader.getValue();
                DataDictionaryEntry childEntry = complexAttrDefinition.getDataObjectEntry();
                if (value != null) {
                    DictionaryObjectAttributeValueReader nestedAttributeValueReader = new DictionaryObjectAttributeValueReader(value, childEntry.getFullClassName(), childEntry, attributeValueReader.getPath());
                    nestedAttributeValueReader.setAttributeName(attributeValueReader.getAttributeName());
                    this.validateObject(result, (AttributeValueReader)nestedAttributeValueReader, doOptionalProcessing, false);
                }
                this.processElementConstraints(result, value, (Constrainable)complexAttrDefinition, attributeValueReader, doOptionalProcessing);
            }
        }
        if ((entry = (DataObjectEntry)attributeValueReader.getEntry()) != null) {
            for (CollectionDefinition collectionDefinition : entry.getCollections()) {
                DataDictionaryEntry childEntry;
                String childEntryName = collectionDefinition.getDataObjectClass();
                String attributeName = collectionDefinition.getName();
                attributeValueReader.setAttributeName(attributeName);
                if (!attributeValueReader.isReadable()) continue;
                Collection collectionObject = (Collection)attributeValueReader.getValue();
                DataDictionaryEntry dataDictionaryEntry = childEntry = childEntryName != null ? this.getDataDictionaryService().getDataDictionary().getDictionaryObjectEntry(childEntryName) : null;
                if (collectionObject != null) {
                    int index = 0;
                    for (Object value : collectionObject) {
                        String objectAttributePath = attributeValueReader.getPath() + "[" + index + "]";
                        DictionaryObjectAttributeValueReader nestedAttributeValueReader = new DictionaryObjectAttributeValueReader(value, childEntryName, childEntry, objectAttributePath);
                        this.validateObject(result, (AttributeValueReader)nestedAttributeValueReader, doOptionalProcessing, true);
                        ++index;
                    }
                }
                this.processCollectionConstraints(result, collectionObject, (Constrainable)collectionDefinition, attributeValueReader, doOptionalProcessing);
            }
        }
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setPersistenceStructureService(PersistenceStructureService persistenceStructureService) {
        this.persistenceStructureService = persistenceStructureService;
    }

    protected WorkflowAttributePropertyResolutionService getWorkflowAttributePropertyResolutionService() {
        if (this.workflowAttributePropertyResolutionService == null) {
            this.workflowAttributePropertyResolutionService = KRADServiceLocatorInternal.getWorkflowAttributePropertyResolutionService();
        }
        return this.workflowAttributePropertyResolutionService;
    }

    public List<CollectionConstraintProcessor> getCollectionConstraintProcessors() {
        return this.collectionConstraintProcessors;
    }

    public void setCollectionConstraintProcessors(List<CollectionConstraintProcessor> collectionConstraintProcessors) {
        this.collectionConstraintProcessors = collectionConstraintProcessors;
    }

    public List<ConstraintProvider> getConstraintProviders() {
        return this.constraintProviders;
    }

    public void setConstraintProviders(List<ConstraintProvider> constraintProviders) {
        this.constraintProviders = constraintProviders;
    }

    public List<ConstraintProcessor> getElementConstraintProcessors() {
        return this.elementConstraintProcessors;
    }

    public void setElementConstraintProcessors(List<ConstraintProcessor> elementConstraintProcessors) {
        this.elementConstraintProcessors = elementConstraintProcessors;
    }

    public DocumentDictionaryService getDocumentDictionaryService() {
        if (this.documentDictionaryService == null) {
            this.documentDictionaryService = KRADServiceLocatorWeb.getDocumentDictionaryService();
        }
        return this.documentDictionaryService;
    }

    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }
}

