/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.mail.MailMessage;
import org.kuali.rice.core.api.mail.Mailer;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KualiFeedbackService;
import org.kuali.rice.krad.util.GlobalVariables;

public class KualiFeedbackServiceImpl
implements KualiFeedbackService {
    private static final Logger LOG = Logger.getLogger(KualiFeedbackServiceImpl.class);
    private static final String FEEDBACK_EMAIL_SUBJECT_PARAM = "feedback.email.subject";
    private static final String FEEDBACK_EMAIL_BODY_PARAM = "feedback.email.body";
    private Mailer mailer;
    private MailMessage messageTemplate;

    public void emailReport(String subject, String message) throws Exception {
        if (LOG.isTraceEnabled()) {
            String lm = String.format("ENTRY %s;%s", subject == null ? "null" : subject.toString(), message == null ? "null" : message.toString());
            LOG.trace((Object)lm);
        }
        if (this.mailer == null) {
            String errorMessage = "mailer property of KualiExceptionIncidentServiceImpl is null";
            LOG.fatal((Object)errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        MailMessage msg = this.createMailMessage(subject, message);
        this.mailer.sendEmail(msg);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"EXIT");
        }
    }

    public void sendFeedback(String documentId, String componentName, String description) throws Exception {
        this.emailReport(this.createFeedbackReportSubject(), this.createFeedbackReportMessage(documentId, componentName, description));
    }

    private String createFeedbackReportSubject() {
        String env = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("environment");
        String formatString = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString(FEEDBACK_EMAIL_SUBJECT_PARAM);
        String subject = MessageFormat.format(formatString, env);
        return subject;
    }

    private String createFeedbackReportMessage(String documentId, String componentName, String description) {
        documentId = documentId == null ? "" : documentId;
        componentName = componentName == null ? "" : componentName;
        description = description == null ? "" : description;
        String principalName = GlobalVariables.getUserSession().getLoggedInUserPrincipalName();
        principalName = principalName == null ? "" : principalName;
        String formatString = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString(FEEDBACK_EMAIL_BODY_PARAM);
        String message = MessageFormat.format(formatString, documentId, principalName, componentName, description);
        return message;
    }

    protected MailMessage createMailMessage(String subject, String message) throws Exception {
        MailMessage messageTemplate;
        if (LOG.isTraceEnabled()) {
            String lm = String.format("ENTRY %s%n%s", subject == null ? "null" : subject.toString(), message == null ? "null" : message.toString());
            LOG.trace((Object)lm);
        }
        if ((messageTemplate = this.getMessageTemplate()) == null) {
            throw new IllegalStateException(String.format("%s.templateMessage is null or not set", this.getClass().getName()));
        }
        MailMessage msg = new MailMessage();
        msg.setFromAddress(this.getFromAddress());
        msg.setToAddresses(this.getToAddresses());
        msg.setBccAddresses(this.getBccAddresses());
        msg.setCcAddresses(this.getCcAddresses());
        msg.setSubject(subject == null ? "" : subject);
        msg.setMessage(message == null ? "" : message);
        if (LOG.isTraceEnabled()) {
            String lm = String.format("EXIT %s", msg == null ? "null" : msg.toString());
            LOG.trace((Object)lm);
        }
        return msg;
    }

    protected String getFromAddress() {
        Person actualUser = GlobalVariables.getUserSession().getActualPerson();
        String fromEmail = actualUser.getEmailAddress();
        if (StringUtils.isNotBlank((String)fromEmail)) {
            return fromEmail;
        }
        return this.getMessageTemplate().getFromAddress();
    }

    protected Set<String> getToAddresses() {
        Set emails = this.getMessageTemplate().getToAddresses();
        if (emails == null || emails.isEmpty()) {
            String mailingList = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString(this.getToAddressesPropertyName());
            if (StringUtils.isBlank((String)mailingList)) {
                String em = REPORT_MAIL_LIST + " is not set or messageTemplate does not have ToAddresses already set.";
                LOG.error((Object)em);
                throw new IllegalStateException(em);
            }
            return new HashSet<String>(Arrays.asList(StringUtils.split((String)mailingList, (String)",")));
        }
        return emails;
    }

    protected String getToAddressesPropertyName() {
        return REPORT_MAIL_LIST;
    }

    protected Set<String> getCcAddresses() {
        return this.getMessageTemplate().getCcAddresses();
    }

    protected Set<String> getBccAddresses() {
        return this.getMessageTemplate().getBccAddresses();
    }

    public Mailer getMailer() {
        return this.mailer;
    }

    public final void setMailer(Mailer mailer) {
        this.mailer = mailer;
    }

    public MailMessage getMessageTemplate() {
        return this.messageTemplate;
    }

    public void setMessageTemplate(MailMessage messageTemplate) {
        this.messageTemplate = messageTemplate;
    }
}

