/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.coreservice.api.CoreServiceApiServiceLocator;
import org.kuali.rice.coreservice.api.namespace.Namespace;
import org.kuali.rice.coreservice.framework.parameter.ParameterConstants;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.kuali.rice.krad.document.TransactionalDocument;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.service.ModuleServiceNotFoundException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class KualiModuleServiceImpl
implements KualiModuleService,
InitializingBean,
ApplicationContextAware {
    private List<ModuleService> installedModuleServices = new ArrayList<ModuleService>();
    private boolean loadRiceInstalledModuleServices;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public List<ModuleService> getInstalledModuleServices() {
        return this.installedModuleServices;
    }

    public ModuleService getModuleService(String moduleId) {
        for (ModuleService moduleService : this.installedModuleServices) {
            if (!moduleService.getModuleConfiguration().getNamespaceCode().equals(moduleId)) continue;
            return moduleService;
        }
        return null;
    }

    public ModuleService getModuleServiceByNamespaceCode(String namespaceCode) {
        for (ModuleService moduleService : this.installedModuleServices) {
            if (!moduleService.getModuleConfiguration().getNamespaceCode().equals(namespaceCode)) continue;
            return moduleService;
        }
        return null;
    }

    public boolean isModuleServiceInstalled(String namespaceCode) {
        for (ModuleService moduleService : this.installedModuleServices) {
            if (!moduleService.getModuleConfiguration().getNamespaceCode().equals(namespaceCode)) continue;
            return true;
        }
        return false;
    }

    public ModuleService getResponsibleModuleService(Class boClass) {
        if (boClass == null) {
            return null;
        }
        for (ModuleService moduleService : this.installedModuleServices) {
            if (!moduleService.isResponsibleFor(boClass)) continue;
            return moduleService;
        }
        if (ExternalizableBusinessObject.class.isAssignableFrom(boClass)) {
            String message = !boClass.isInterface() ? "There is no responsible module for the externalized business object class: " + boClass : "There is no responsible module for the externalized business object interface: " + boClass;
            throw new ModuleServiceNotFoundException(message);
        }
        return null;
    }

    public ModuleService getResponsibleModuleServiceForJob(String jobName) {
        for (ModuleService moduleService : this.installedModuleServices) {
            if (!moduleService.isResponsibleForJob(jobName)) continue;
            return moduleService;
        }
        return null;
    }

    public void setInstalledModuleServices(List<ModuleService> installedModuleServices) {
        this.installedModuleServices = installedModuleServices;
    }

    public List<String> getDataDictionaryPackages() {
        ArrayList<String> packages = new ArrayList<String>();
        for (ModuleService moduleService : this.installedModuleServices) {
            if (moduleService.getModuleConfiguration().getDataDictionaryPackages() == null) continue;
            packages.addAll(moduleService.getModuleConfiguration().getDataDictionaryPackages());
        }
        return packages;
    }

    public String getNamespaceName(String namespaceCode) {
        Namespace parameterNamespace = CoreServiceApiServiceLocator.getNamespaceService().getNamespace(namespaceCode);
        return parameterNamespace == null ? "" : parameterNamespace.getName();
    }

    public void setLoadRiceInstalledModuleServices(boolean loadRiceInstalledModuleServices) {
        this.loadRiceInstalledModuleServices = loadRiceInstalledModuleServices;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.loadRiceInstalledModuleServices) {
            try {
                this.installedModuleServices.addAll(((KualiModuleService)GlobalResourceLoader.getService((String)(KualiModuleService.class.getSimpleName().substring(0, 1).toLowerCase() + KualiModuleService.class.getSimpleName().substring(1)))).getInstalledModuleServices());
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.installedModuleServices.addAll(((KualiModuleService)this.applicationContext.getBean("kualiModuleService")).getInstalledModuleServices());
            }
        }
    }

    public String getNamespaceCode(Class<?> documentClass) {
        if (documentClass == null) {
            throw new IllegalArgumentException("documentClass must not be null");
        }
        if (documentClass.isAnnotationPresent(ParameterConstants.NAMESPACE.class)) {
            return documentClass.getAnnotation(ParameterConstants.NAMESPACE.class).namespace();
        }
        ModuleService moduleService = this.getResponsibleModuleService(documentClass);
        if (moduleService != null) {
            return moduleService.getModuleConfiguration().getNamespaceCode();
        }
        if (documentClass.getName().startsWith("org.kuali.rice.krad")) {
            return "KR-NS";
        }
        if (documentClass.getName().startsWith("org.kuali.rice.edl")) {
            return "KR-EDL";
        }
        if (documentClass.getName().startsWith("org.kuali.rice.kew")) {
            return "KR-WKFLW";
        }
        if (documentClass.getName().startsWith("org.kuali.rice.edl")) {
            return "KR-WKFLW";
        }
        if (documentClass.getName().startsWith("org.kuali.rice.kim")) {
            return "KR-IDM";
        }
        if (documentClass.getName().startsWith("org.kuali.rice.core")) {
            return "KR-CORE";
        }
        throw new IllegalArgumentException("Unable to determine the namespace code for documentClass " + documentClass.getName());
    }

    public String getComponentCode(Class<?> documentClass) {
        if (documentClass == null) {
            throw new IllegalArgumentException("documentClass must not be null");
        }
        if (documentClass.isAnnotationPresent(ParameterConstants.COMPONENT.class)) {
            return documentClass.getAnnotation(ParameterConstants.COMPONENT.class).component();
        }
        if (TransactionalDocument.class.isAssignableFrom(documentClass)) {
            return documentClass.getSimpleName().replace("Document", "");
        }
        if (BusinessObject.class.isAssignableFrom(documentClass)) {
            return documentClass.getSimpleName();
        }
        throw new IllegalArgumentException("Unable to determine the component code for documentClass " + documentClass.getName());
    }
}

