/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.framework.persistence.jta.TransactionalNoValidationExceptionRollback;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.dao.MaintenanceDocumentDao;
import org.kuali.rice.krad.exception.DocumentTypeAuthorizationException;
import org.kuali.rice.krad.maintenance.Maintainable;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.maintenance.MaintenanceLock;
import org.kuali.rice.krad.service.DataObjectAuthorizationService;
import org.kuali.rice.krad.service.DataObjectMetaDataService;
import org.kuali.rice.krad.service.DocumentDictionaryService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.MaintenanceDocumentService;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.ObjectUtils;

@TransactionalNoValidationExceptionRollback
public class MaintenanceDocumentServiceImpl
implements MaintenanceDocumentService {
    protected static final Logger LOG = Logger.getLogger(MaintenanceDocumentServiceImpl.class);
    private MaintenanceDocumentDao maintenanceDocumentDao;
    private DataObjectAuthorizationService dataObjectAuthorizationService;
    private DocumentService documentService;
    private DataObjectMetaDataService dataObjectMetaDataService;
    private DocumentDictionaryService documentDictionaryService;

    public MaintenanceDocument setupNewMaintenanceDocument(String objectClassName, String documentTypeName, String maintenanceAction) {
        if (StringUtils.isEmpty((String)objectClassName) && StringUtils.isEmpty((String)documentTypeName)) {
            throw new IllegalArgumentException("Document type name or bo class not given!");
        }
        if (StringUtils.isEmpty((String)documentTypeName)) {
            try {
                documentTypeName = this.getDocumentDictionaryService().getMaintenanceDocumentTypeName(Class.forName(objectClassName));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (StringUtils.isEmpty((String)documentTypeName)) {
                throw new RuntimeException("documentTypeName is empty; does this Business Object have a maintenance document definition? " + objectClassName);
            }
        }
        if ("New".equals(maintenanceAction) || "Copy".equals(maintenanceAction)) {
            Class boClass = this.getDocumentDictionaryService().getMaintenanceDataObjectClass(documentTypeName);
            boolean allowsNewOrCopy = this.getDataObjectAuthorizationService().canCreate(boClass, GlobalVariables.getUserSession().getPerson(), documentTypeName);
            if (!allowsNewOrCopy) {
                LOG.error((Object)("Document type " + documentTypeName + " does not allow new or copy actions."));
                throw new DocumentTypeAuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalId(), "newOrCopy", documentTypeName);
            }
        }
        try {
            return (MaintenanceDocument)this.getDocumentService().getNewDocument(documentTypeName);
        }
        catch (WorkflowException e) {
            LOG.error((Object)("Cannot get new maintenance document instance for doc type: " + documentTypeName), (Throwable)e);
            throw new RuntimeException("Cannot get new maintenance document instance for doc type: " + documentTypeName, e);
        }
    }

    public void setupMaintenanceObject(MaintenanceDocument document, String maintenanceAction, Map<String, String[]> requestParameters) {
        document.getNewMaintainableObject().setMaintenanceAction(maintenanceAction);
        document.getOldMaintainableObject().setMaintenanceAction(maintenanceAction);
        if (!"New".equals(maintenanceAction) && !"newWithExisting".equals(maintenanceAction)) {
            Object oldDataObject = this.retrieveObjectForMaintenance(document, requestParameters);
            Serializable newDataObject = ObjectUtils.deepCopy((Serializable)((Serializable)oldDataObject));
            document.getOldMaintainableObject().setDataObject(oldDataObject);
            document.getNewMaintainableObject().setDataObject((Object)newDataObject);
            if ("Copy".equals(maintenanceAction)) {
                this.processMaintenanceObjectForCopy(document, newDataObject, requestParameters);
            } else {
                this.checkMaintenanceActionAuthorization(document, oldDataObject, maintenanceAction, requestParameters);
            }
        }
        if ("newWithExisting".equals(maintenanceAction)) {
            Object newBO = document.getNewMaintainableObject().getDataObject();
            Map<String, String> parameters = this.buildKeyMapFromRequest(requestParameters, document.getNewMaintainableObject().getDataObjectClass());
            ObjectPropertyUtils.copyPropertiesToObject(parameters, (Object)newBO);
            if (newBO instanceof PersistableBusinessObject) {
                ((PersistableBusinessObject)newBO).refresh();
            }
            document.getNewMaintainableObject().setupNewFromExisting(document, requestParameters);
        } else if ("New".equals(maintenanceAction)) {
            document.getNewMaintainableObject().processAfterNew(document, requestParameters);
        }
    }

    protected void checkMaintenanceActionAuthorization(MaintenanceDocument document, Object oldBusinessObject, String maintenanceAction, Map<String, String[]> requestParameters) {
        boolean allowsDelete;
        if ("Edit".equals(maintenanceAction)) {
            boolean allowsEdit = this.getDataObjectAuthorizationService().canMaintain(oldBusinessObject, GlobalVariables.getUserSession().getPerson(), document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
            if (!allowsEdit) {
                LOG.error((Object)("Document type " + document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName() + " does not allow edit actions."));
                throw new DocumentTypeAuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalId(), "edit", document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
            }
            document.getNewMaintainableObject().processAfterEdit(document, requestParameters);
        } else if ("Delete".equals(maintenanceAction) && !(allowsDelete = this.getDataObjectAuthorizationService().canMaintain((Object)((BusinessObject)oldBusinessObject), GlobalVariables.getUserSession().getPerson(), document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName()))) {
            LOG.error((Object)("Document type " + document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName() + " does not allow delete actions."));
            throw new DocumentTypeAuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalId(), "delete", document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
        }
    }

    protected Object retrieveObjectForMaintenance(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        Map<String, String> keyMap = this.buildKeyMapFromRequest(requestParameters, document.getNewMaintainableObject().getDataObjectClass());
        Object oldDataObject = document.getNewMaintainableObject().retrieveObjectForEditOrCopy(document, keyMap);
        if (oldDataObject == null && !document.getOldMaintainableObject().isExternalBusinessObject()) {
            throw new RuntimeException("Cannot retrieve old record for maintenance document, incorrect parameters passed on maint url: " + requestParameters);
        }
        if (document.getOldMaintainableObject().isExternalBusinessObject()) {
            if (oldDataObject == null) {
                try {
                    oldDataObject = document.getOldMaintainableObject().getDataObjectClass().newInstance();
                }
                catch (Exception ex) {
                    throw new RuntimeException("External BO maintainable was null and unable to instantiate for old maintainable object.", ex);
                }
            }
            this.populateMaintenanceObjectWithCopyKeyValues(KRADUtils.translateRequestParameterMap(requestParameters), oldDataObject, document.getOldMaintainableObject());
            document.getOldMaintainableObject().prepareExternalBusinessObject((BusinessObject)((PersistableBusinessObject)oldDataObject));
            oldDataObject = document.getOldMaintainableObject().getDataObject();
        }
        return oldDataObject;
    }

    protected void processMaintenanceObjectForCopy(MaintenanceDocument document, Object maintenanceObject, Map<String, String[]> requestParameters) {
        if (!document.isFieldsClearedOnCopy()) {
            Maintainable maintainable = document.getNewMaintainableObject();
            if (!this.getDocumentDictionaryService().getPreserveLockingKeysOnCopy(maintainable.getDataObjectClass())) {
                this.clearPrimaryKeyFields(maintenanceObject, maintainable.getDataObjectClass());
            }
            this.clearUnauthorizedNewFields(document);
            maintainable.processAfterCopy(document, requestParameters);
            document.setFieldsClearedOnCopy(true);
        }
    }

    protected void clearPrimaryKeyFields(Object maintenanceObject, Class<?> dataObjectClass) {
        List keyFieldNames = this.getDataObjectMetaDataService().listPrimaryKeyFieldNames(dataObjectClass);
        for (String keyFieldName : keyFieldNames) {
            ObjectPropertyUtils.setPropertyValue((Object)maintenanceObject, (String)keyFieldName, null);
        }
    }

    protected void clearUnauthorizedNewFields(MaintenanceDocument document) {
        Person user = GlobalVariables.getUserSession().getPerson();
    }

    protected Map<String, String> buildKeyMapFromRequest(Map<String, String[]> requestParameters, Class<?> dataObjectClass) {
        List<String> keyFieldNames = null;
        Map parameters = KRADUtils.translateRequestParameterMap(requestParameters);
        if (!StringUtils.isBlank((String)((String)parameters.get("overrideKeys")))) {
            String[] overrideKeys = ((String)parameters.get("overrideKeys")).split(",");
            keyFieldNames = Arrays.asList(overrideKeys);
        } else {
            keyFieldNames = this.getDataObjectMetaDataService().listPrimaryKeyFieldNames(dataObjectClass);
        }
        return KRADUtils.getParametersFromRequest((List)keyFieldNames, dataObjectClass, (Map)parameters);
    }

    protected void populateMaintenanceObjectWithCopyKeyValues(Map<String, String> parameters, Object oldBusinessObject, Maintainable oldMaintainableObject) {
        List<String> keyFieldNamesToCopy = null;
        Map parametersToCopy = null;
        if (!StringUtils.isBlank((String)parameters.get("cpKys"))) {
            String[] copyKeys = parameters.get("cpKys").split(",");
            keyFieldNamesToCopy = Arrays.asList(copyKeys);
            parametersToCopy = KRADUtils.getParametersFromRequest(keyFieldNamesToCopy, (Class)oldMaintainableObject.getDataObjectClass(), parameters);
        }
        if (parametersToCopy != null) {
            ObjectPropertyUtils.copyPropertiesToObject(parametersToCopy, (Object)oldBusinessObject);
        }
    }

    public String getLockingDocumentId(MaintenanceDocument document) {
        return this.getLockingDocumentId(document.getNewMaintainableObject(), document.getDocumentNumber());
    }

    public String getLockingDocumentId(Maintainable maintainable, String documentNumber) {
        MaintenanceLock maintenanceLock;
        String lockingDocId = null;
        List maintenanceLocks = maintainable.generateMaintenanceLocks();
        Iterator i$ = maintenanceLocks.iterator();
        while (i$.hasNext() && !StringUtils.isNotBlank((String)(lockingDocId = this.maintenanceDocumentDao.getLockingDocumentNumber((maintenanceLock = (MaintenanceLock)i$.next()).getLockingRepresentation(), documentNumber)))) {
        }
        return lockingDocId;
    }

    public void deleteLocks(String documentNumber) {
        this.maintenanceDocumentDao.deleteLocks(documentNumber);
    }

    public void storeLocks(List<MaintenanceLock> maintenanceLocks) {
        this.maintenanceDocumentDao.storeLocks(maintenanceLocks);
    }

    public MaintenanceDocumentDao getMaintenanceDocumentDao() {
        return this.maintenanceDocumentDao;
    }

    public void setMaintenanceDocumentDao(MaintenanceDocumentDao maintenanceDocumentDao) {
        this.maintenanceDocumentDao = maintenanceDocumentDao;
    }

    protected DataObjectAuthorizationService getDataObjectAuthorizationService() {
        if (this.dataObjectAuthorizationService == null) {
            this.dataObjectAuthorizationService = KRADServiceLocatorWeb.getDataObjectAuthorizationService();
        }
        return this.dataObjectAuthorizationService;
    }

    public void setDataObjectAuthorizationService(DataObjectAuthorizationService dataObjectAuthorizationService) {
        this.dataObjectAuthorizationService = dataObjectAuthorizationService;
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected DataObjectMetaDataService getDataObjectMetaDataService() {
        if (this.dataObjectMetaDataService == null) {
            this.dataObjectMetaDataService = KRADServiceLocatorWeb.getDataObjectMetaDataService();
        }
        return this.dataObjectMetaDataService;
    }

    public void setDataObjectMetaDataService(DataObjectMetaDataService dataObjectMetaDataService) {
        this.dataObjectMetaDataService = dataObjectMetaDataService;
    }

    public DocumentDictionaryService getDocumentDictionaryService() {
        if (this.documentDictionaryService == null) {
            this.documentDictionaryService = KRADServiceLocatorWeb.getDocumentDictionaryService();
        }
        return this.documentDictionaryService;
    }

    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }
}

