/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ojb.broker.core.proxy.ListProxyDefaultImpl;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.PersistenceService;
import org.kuali.rice.krad.service.XmlObjectSerializerService;
import org.kuali.rice.krad.util.DateTimeConverter;

public class XmlObjectSerializerServiceImpl
implements XmlObjectSerializerService {
    private static final Log LOG = LogFactory.getLog(XmlObjectSerializerServiceImpl.class);
    private PersistenceService persistenceService;
    private XStream xstream = new XStream((ReflectionProvider)new ProxyAwareJavaReflectionProvider());

    public XmlObjectSerializerServiceImpl() {
        this.xstream.registerConverter((Converter)new ProxyConverter(this.xstream.getMapper(), this.xstream.getReflectionProvider()));
        this.xstream.addDefaultImplementation(ArrayList.class, ListProxyDefaultImpl.class);
        this.xstream.registerConverter((SingleValueConverter)new DateTimeConverter());
    }

    public String toXml(Object object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("toXml(" + object + ") : \n" + this.xstream.toXML(object)));
        }
        return this.xstream.toXML(object);
    }

    public Object fromXml(String xml) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("fromXml() : \n" + xml));
        }
        if (xml != null) {
            xml = xml.replaceAll("--EnhancerByCGLIB--[0-9a-f]{0,8}", "");
        }
        return this.xstream.fromXML(xml);
    }

    public PersistenceService getPersistenceService() {
        if (this.persistenceService == null) {
            this.persistenceService = KRADServiceLocator.getPersistenceService();
        }
        return this.persistenceService;
    }

    public class ProxyAwareJavaReflectionProvider
    extends PureJavaReflectionProvider {
        public void visitSerializableFields(Object object, ReflectionProvider.Visitor visitor) {
            Iterator iterator = this.fieldDictionary.serializableFieldsFor(object.getClass());
            while (iterator.hasNext()) {
                Field field = (Field)iterator.next();
                if (!this.fieldModifiersSupported(field)) continue;
                this.validateFieldAccess(field);
                Object value = null;
                try {
                    value = field.get(object);
                    if (value != null && XmlObjectSerializerServiceImpl.this.getPersistenceService().isProxied(value)) {
                        value = XmlObjectSerializerServiceImpl.this.getPersistenceService().resolveProxy(value);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new ObjectAccessException("Could not get field " + field.getClass() + "." + field.getName(), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new ObjectAccessException("Could not get field " + field.getClass() + "." + field.getName(), (Throwable)e);
                }
                visitor.visit(field.getName(), field.getType(), field.getDeclaringClass(), value);
            }
        }
    }

    public class ProxyConverter
    extends ReflectionConverter {
        public ProxyConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
            super(mapper, reflectionProvider);
        }

        public boolean canConvert(Class clazz) {
            return clazz.getName().contains("CGLIB");
        }

        public void marshal(Object obj, HierarchicalStreamWriter writer, MarshallingContext context) {
            super.marshal(XmlObjectSerializerServiceImpl.this.getPersistenceService().resolveProxy(obj), writer, context);
        }
    }
}

