/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.service.impl;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.inquiry.Inquirable;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.service.ViewDictionaryService;
import org.kuali.rice.krad.uif.util.ViewModelUtils;
import org.kuali.rice.krad.uif.view.LookupView;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.beans.PropertyValues;

public class ViewDictionaryServiceImpl
implements ViewDictionaryService {
    private DataDictionaryService dataDictionaryService;

    public Inquirable getInquirable(Class<?> dataObjectClass, String viewName) {
        Inquirable inquirable = null;
        if (StringUtils.isBlank((String)viewName)) {
            viewName = "default";
        }
        HashMap<String, String> indexKey = new HashMap<String, String>();
        indexKey.put("viewName", viewName);
        indexKey.put("dataObjectClassName", dataObjectClass.getName());
        PropertyValues propertyValues = this.getDataDictionary().getViewPropertiesByType(UifConstants.ViewType.INQUIRY, indexKey);
        String viewHelperServiceClassName = ViewModelUtils.getStringValFromPVs((PropertyValues)propertyValues, (String)"viewHelperServiceClassName");
        if (StringUtils.isNotBlank((String)viewHelperServiceClassName)) {
            try {
                inquirable = (Inquirable)ObjectUtils.newInstance(Class.forName(viewHelperServiceClassName));
            }
            catch (ClassNotFoundException e) {
                throw new RiceRuntimeException("Unable to find class for inquirable classname: " + viewHelperServiceClassName, (Throwable)e);
            }
        }
        return inquirable;
    }

    public boolean isInquirable(Class<?> dataObjectClass) {
        HashMap<String, String> indexKey = new HashMap<String, String>();
        indexKey.put("viewName", "default");
        indexKey.put("dataObjectClassName", dataObjectClass.getName());
        boolean isInquirable = this.getDataDictionary().viewByTypeExist(UifConstants.ViewType.INQUIRY, indexKey);
        return isInquirable;
    }

    public boolean isLookupable(Class<?> dataObjectClass) {
        HashMap<String, String> indexKey = new HashMap<String, String>();
        indexKey.put("viewName", "default");
        indexKey.put("dataObjectClassName", dataObjectClass.getName());
        boolean isLookupable = this.getDataDictionary().viewByTypeExist(UifConstants.ViewType.LOOKUP, indexKey);
        return isLookupable;
    }

    public boolean isMaintainable(Class<?> dataObjectClass) {
        HashMap<String, String> indexKey = new HashMap<String, String>();
        indexKey.put("viewName", "default");
        indexKey.put("dataObjectClassName", dataObjectClass.getName());
        boolean isMaintainable = this.getDataDictionary().viewByTypeExist(UifConstants.ViewType.MAINTENANCE, indexKey);
        return isMaintainable;
    }

    public Integer getResultSetLimitForLookup(Class<?> dataObjectClass) {
        LookupView lookupView = null;
        List lookupViews = this.getDataDictionary().getViewsForType(UifConstants.ViewType.LOOKUP);
        for (View view : lookupViews) {
            LookupView lView = (LookupView)view;
            if (!StringUtils.equals((String)lView.getDataObjectClassName().getName(), (String)dataObjectClass.getName())) continue;
            if (lookupView != null) {
                if (!StringUtils.equals((String)lView.getViewName(), (String)"default")) continue;
                lookupView = lView;
                continue;
            }
            lookupView = lView;
        }
        if (lookupView != null) {
            return lookupView.getResultSetLimit();
        }
        return null;
    }

    protected DataDictionary getDataDictionary() {
        return this.getDataDictionaryService().getDataDictionary();
    }

    protected DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

