/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.util.OjbCollectionAware;
import org.springframework.orm.ObjectRetrievalFailureException;

public class OjbCollectionHelper {
    private static final Logger LOG = Logger.getLogger(OjbCollectionHelper.class);

    public void processCollections(OjbCollectionAware template, PersistableBusinessObject orig, PersistableBusinessObject copy) {
        if (copy == null) {
            return;
        }
        List originalCollections = orig.buildListOfDeletionAwareLists();
        if (originalCollections != null && !originalCollections.isEmpty()) {
            try {
                List copyCollections = copy.buildListOfDeletionAwareLists();
                int size = originalCollections.size();
                if (copyCollections.size() != size) {
                    throw new RuntimeException("size mismatch while attempting to process list of Collections to manage");
                }
                for (int i = 0; i < size; ++i) {
                    Collection origSource = (Collection)originalCollections.get(i);
                    Collection copySource = (Collection)copyCollections.get(i);
                    List<PersistableBusinessObject> list = this.findUnwantedElements(copySource, origSource);
                    this.cleanse(template, origSource, list);
                }
            }
            catch (ObjectRetrievalFailureException orfe) {
                // empty catch block
            }
        }
    }

    public void processCollections2(OjbCollectionAware template, PersistableBusinessObject orig, PersistableBusinessObject copy) {
        if (copy == null) {
            return;
        }
        List originalCollections = orig.buildListOfDeletionAwareLists();
        if (originalCollections != null && !originalCollections.isEmpty()) {
            try {
                List copyCollections = copy.buildListOfDeletionAwareLists();
                int size = originalCollections.size();
                if (copyCollections.size() != size) {
                    throw new RuntimeException("size mismatch while attempting to process list of Collections to manage");
                }
                for (int i = 0; i < size; ++i) {
                    Collection origSource = (Collection)originalCollections.get(i);
                    Collection copySource = (Collection)copyCollections.get(i);
                    List<PersistableBusinessObject> list = this.findUnwantedElements(copySource, origSource);
                    this.cleanse(template, origSource, list);
                }
            }
            catch (ObjectRetrievalFailureException orfe) {
                // empty catch block
            }
        }
    }

    private void cleanse(OjbCollectionAware template, Collection<PersistableBusinessObject> origSource, List<PersistableBusinessObject> unwantedItems) {
        if (unwantedItems.size() > 0) {
            for (PersistableBusinessObject unwantedItem : unwantedItems) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("cleansing " + unwantedItem));
                }
                template.getPersistenceBrokerTemplate().delete((Object)unwantedItem);
            }
        }
    }

    private List<PersistableBusinessObject> findUnwantedElements(Collection<PersistableBusinessObject> fromList, Collection<PersistableBusinessObject> controlList) {
        ArrayList<PersistableBusinessObject> toRemove = new ArrayList<PersistableBusinessObject>();
        for (PersistableBusinessObject fromObject : fromList) {
            if (ObjectUtils.collectionContainsObjectWithIdentitcalKey(controlList, (PersistableBusinessObject)fromObject)) continue;
            toRemove.add(fromObject);
        }
        return toRemove;
    }
}

