/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.bo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.ken.api.notification.NotificationProducer;
import org.kuali.rice.ken.api.notification.NotificationProducerContract;
import org.kuali.rice.ken.bo.NotificationChannelBo;
import org.kuali.rice.ken.service.NotificationChannelService;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;

@Entity
@Table(name="KREN_PRODCR_T")
public class NotificationProducerBo
extends PersistableBusinessObjectBase
implements NotificationProducerContract {
    @Id
    @GeneratedValue(generator="KREN_PRODCR_S")
    @GenericGenerator(name="KREN_PRODCR_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KREN_PRODCR_S"), @Parameter(name="value_column", value="id")})
    @Column(name="PRODCR_ID")
    private Long id;
    @Column(name="NM", nullable=false)
    private String name;
    @Column(name="DESC_TXT", nullable=false)
    private String description;
    @Column(name="CNTCT_INFO", nullable=false)
    private String contactInfo;
    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinTable(name="KREN_CHNL_PRODCR_T", joinColumns={@JoinColumn(name="PRODCR_ID")}, inverseJoinColumns={@JoinColumn(name="CHNL_ID")})
    @OrderBy(value="id ASC")
    private List<NotificationChannelBo> channels = new ArrayList<NotificationChannelBo>();

    public String getContactInfo() {
        return this.contactInfo;
    }

    public List<Long> getChannelIds() {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (NotificationChannelBo bo : this.getChannels()) {
            ids.add(bo.getId());
        }
        return ids;
    }

    public void setContactInfo(String contactInfo) {
        this.contactInfo = contactInfo;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<NotificationChannelBo> getChannels() {
        return this.channels;
    }

    public void setChannels(List<NotificationChannelBo> channels) {
        this.channels = channels;
    }

    public static NotificationProducer to(NotificationProducerBo bo) {
        if (bo == null) {
            return null;
        }
        return NotificationProducer.Builder.create((NotificationProducerContract)bo).build();
    }

    public static NotificationProducerBo from(NotificationProducer im) {
        if (im == null) {
            return null;
        }
        NotificationProducerBo bo = new NotificationProducerBo();
        bo.setId(im.getId());
        bo.setVersionNumber(im.getVersionNumber());
        bo.setObjectId(im.getObjectId());
        bo.setName(im.getName());
        bo.setDescription(im.getDescription());
        bo.setContactInfo(im.getContactInfo());
        ArrayList<NotificationChannelBo> tempChannels = new ArrayList<NotificationChannelBo>();
        if (CollectionUtils.isNotEmpty((Collection)im.getChannelIds())) {
            NotificationChannelService ncs = (NotificationChannelService)GlobalResourceLoader.getService((String)"notificationChannelService");
            for (Long channelId : im.getChannelIds()) {
                tempChannels.add(ncs.getNotificationChannel(channelId.toString()));
            }
            bo.setChannels(tempChannels);
        }
        return bo;
    }
}

