/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionitem.dao.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.core.framework.persistence.jpa.criteria.Criteria;
import org.kuali.rice.core.framework.persistence.jpa.criteria.QueryByCriteria;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionitem.OutboxItemActionListExtension;
import org.kuali.rice.kew.actionitem.dao.ActionItemDAO;
import org.kuali.rice.kew.actionrequest.KimGroupRecipient;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.util.WebFriendlyRecipient;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class ActionItemDAOJpaImpl
implements ActionItemDAO {
    @PersistenceContext(unitName="kew-unit")
    private EntityManager entityManager;

    @Override
    public ActionItem findByActionItemId(String actionItemId) {
        return (ActionItem)this.entityManager.find(ActionItem.class, (Object)actionItemId);
    }

    public void deleteActionItems(Long actionRequestId) {
        Criteria crit = new Criteria(ActionItem.class.getName());
        crit.eq("actionRequestId", (Object)actionRequestId);
        for (Object actionItem : new QueryByCriteria(this.entityManager, crit).toQuery().getResultList()) {
            if (actionItem instanceof OutboxItemActionListExtension) continue;
            this.entityManager.remove(actionItem);
        }
    }

    @Override
    public void deleteActionItem(ActionItem actionItem) {
        this.entityManager.remove((Object)this.findByActionItemId(actionItem.getId()));
    }

    @Override
    public void deleteByDocumentIdWorkflowUserId(String documentId, String workflowUserId) {
        Criteria crit = new Criteria(ActionItem.class.getName());
        crit.eq("documentId", (Object)documentId);
        crit.eq("principalId", (Object)workflowUserId);
        for (Object actionItem : new QueryByCriteria(this.entityManager, crit).toQuery().getResultList()) {
            if (actionItem instanceof OutboxItemActionListExtension) continue;
            this.entityManager.remove(actionItem);
        }
    }

    @Override
    public void deleteByDocumentId(String documentId) {
        Criteria crit = new Criteria(ActionItem.class.getName());
        crit.eq("documentId", (Object)documentId);
        for (Object actionItem : new QueryByCriteria(this.entityManager, crit).toQuery().getResultList()) {
            if (actionItem instanceof OutboxItemActionListExtension) continue;
            this.entityManager.remove(actionItem);
        }
    }

    @Override
    public Collection<ActionItem> findByPrincipalId(String principalId) {
        Criteria crit = new Criteria(ActionItem.class.getName());
        crit.eq("principalId", (Object)principalId);
        crit.orderBy("documentId", true);
        List results = new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
        return this.removeOutBoxItems(results);
    }

    @Override
    public Collection<ActionItem> findByWorkflowUserDocumentId(String workflowId, String documentId) {
        Criteria crit = new Criteria(ActionItem.class.getName());
        crit.eq("principalId", (Object)workflowId);
        crit.eq("documentId", (Object)documentId);
        List results = new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
        return this.removeOutBoxItems(results);
    }

    @Override
    public Collection<ActionItem> findByDocumentTypeName(String documentTypeName) {
        Criteria crit = new Criteria(ActionItem.class.getName());
        crit.eq("docName", (Object)documentTypeName);
        List results = new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
        return this.removeOutBoxItems(results);
    }

    @Override
    public Collection<OutboxItemActionListExtension> getOutboxItemsByDocumentType(String documentTypeName) {
        Criteria crit = new Criteria(ActionItem.class.getName());
        crit.eq("docName", (Object)documentTypeName);
        List results = new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
        ArrayList<OutboxItemActionListExtension> finalResults = new ArrayList<OutboxItemActionListExtension>();
        for (ActionItem actionItem : results) {
            if (!(actionItem instanceof OutboxItemActionListExtension)) continue;
            finalResults.add((OutboxItemActionListExtension)actionItem);
        }
        return finalResults;
    }

    @Override
    public Collection<ActionItem> findByDocumentId(String documentId) {
        Criteria crit = new Criteria(ActionItem.class.getName());
        crit.eq("documentId", (Object)documentId);
        List results = new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
        return this.removeOutBoxItems(results);
    }

    @Override
    public Collection<ActionItem> findByActionRequestId(String actionRequestId) {
        Criteria crit = new Criteria(ActionItem.class.getName());
        crit.eq("actionRequestId", (Object)actionRequestId);
        List results = new QueryByCriteria(this.entityManager, crit).toQuery().getResultList();
        return this.removeOutBoxItems(results);
    }

    @Override
    public void saveActionItem(ActionItem actionItem) {
        if (actionItem.getDateAssigned() == null) {
            actionItem.setDateAssigned(new Timestamp(new Date().getTime()));
        }
        if (actionItem.getId() == null) {
            this.entityManager.persist((Object)actionItem);
        } else {
            OrmUtils.merge((EntityManager)this.entityManager, (Object)actionItem);
        }
    }

    @Override
    public Collection<Recipient> findSecondaryDelegators(String principalId) {
        Criteria notNullWorkflowCriteria = new Criteria(ActionItem.class.getName());
        notNullWorkflowCriteria.notNull("delegatorPrincipalId");
        Criteria notNullWorkgroupCriteria = new Criteria(ActionItem.class.getName());
        notNullWorkgroupCriteria.notNull("delegatorGroupId");
        Criteria orCriteria = new Criteria(ActionItem.class.getName());
        orCriteria.or(notNullWorkflowCriteria);
        orCriteria.or(notNullWorkgroupCriteria);
        Criteria criteria = new Criteria(ActionItem.class.getName());
        criteria.eq("principalId", (Object)principalId);
        criteria.eq("delegationType", (Object)DelegationType.SECONDARY.getCode());
        criteria.and(orCriteria);
        HashMap<String, Recipient> delegators = new HashMap<String, Recipient>();
        for (Object actionItem : new QueryByCriteria(this.entityManager, criteria).toQuery().getResultList()) {
            String delegatorPrincipalId = ((ActionItem)actionItem).getDelegatorPrincipalId();
            String delegatorGroupId = ((ActionItem)actionItem).getDelegatorGroupId();
            if (delegatorPrincipalId != null && !delegators.containsKey(delegatorPrincipalId)) {
                delegators.put(delegatorPrincipalId, new WebFriendlyRecipient(KimApiServiceLocator.getPersonService().getPerson(delegatorPrincipalId)));
                continue;
            }
            if (delegatorGroupId == null || delegators.containsKey(delegatorGroupId)) continue;
            delegators.put(delegatorGroupId, new KimGroupRecipient(KimApiServiceLocator.getGroupService().getGroup(delegatorGroupId)));
        }
        return delegators.values();
    }

    @Override
    public Collection<Recipient> findPrimaryDelegationRecipients(String principalId) {
        List workgroupIds = KimApiServiceLocator.getGroupService().getGroupIdsByPrincipalId(principalId);
        Criteria orCriteria = new Criteria(ActionItem.class.getName());
        Criteria delegatorPrincipalIdCriteria = new Criteria(ActionItem.class.getName());
        delegatorPrincipalIdCriteria.eq("delegatorPrincipalId", (Object)principalId);
        if (CollectionUtils.isNotEmpty((Collection)workgroupIds)) {
            Criteria delegatorWorkgroupCriteria = new Criteria(ActionItem.class.getName());
            delegatorWorkgroupCriteria.in("delegatorGroupId", new ArrayList(workgroupIds));
            orCriteria.or(delegatorWorkgroupCriteria);
            orCriteria.or(delegatorPrincipalIdCriteria);
        } else {
            orCriteria.and(delegatorPrincipalIdCriteria);
        }
        Criteria criteria = new Criteria(ActionItem.class.getName());
        criteria.eq("delegationType", (Object)DelegationType.PRIMARY.getCode());
        criteria.and(orCriteria);
        HashMap<String, WebFriendlyRecipient> delegators = new HashMap<String, WebFriendlyRecipient>();
        for (Object actionItem : new QueryByCriteria(this.entityManager, criteria).toQuery().getResultList()) {
            String princlId = ((ActionItem)actionItem).getPrincipalId();
            if (princlId == null || delegators.containsKey(princlId)) continue;
            delegators.put(princlId, new WebFriendlyRecipient(KimApiServiceLocator.getPersonService().getPerson(princlId)));
        }
        return delegators.values();
    }

    private List<ActionItem> removeOutBoxItems(List<ActionItem> results) {
        Iterator<ActionItem> iterator = results.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof OutboxItemActionListExtension)) continue;
            iterator.remove();
        }
        return results;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

