/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionrequest;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionrequest.ActionRequestFactory;
import org.kuali.rice.kew.actionrequest.KimGroupRecipient;
import org.kuali.rice.kew.actionrequest.KimPrincipalRecipient;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestPolicy;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.action.ActionTakenContract;
import org.kuali.rice.kew.api.action.RecipientType;
import org.kuali.rice.kew.api.util.CodeTranslator;
import org.kuali.rice.kew.dto.DTOConverter;
import org.kuali.rice.kew.engine.CompatUtils;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.service.RuleServiceInternal;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.user.RoleRecipient;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

@Entity
@Table(name="KREW_ACTN_RQST_T")
@NamedQueries(value={@NamedQuery(name="ActionRequestValue.FindByDocumentId", query="select arv from ActionRequestValue arv where arv.documentId = :documentId"), @NamedQuery(name="ActionRequestValue.GetUserRequestCount", query="select count(arv) from ActionRequestValue arv where arv.documentId = :documentId and arv.recipientTypeCd = :recipientTypeCd and arv.principalId = :principalId and arv.currentIndicator = :currentIndicator"), @NamedQuery(name="ActionRequestValue.FindActivatedByGroup", query="select count(arv) from ActionRequestValue arv where arv.groupId = :groupId and arv.currentIndicator = :currentIndicator and arv.status = :status"), @NamedQuery(name="ActionRequestValue.FindAllByDocId", query="select arv from ActionRequestValue arv where arv.documentId = :documentId and arv.currentIndicator = :currentIndicator"), @NamedQuery(name="ActionRequestValue.FindAllPendingByDocId", query="select arv from ActionRequestValue arv where arv.documentId = :documentId and arv.currentIndicator = :currentIndicator and (arv.status = :actionRequestStatus1 or arv.status = :actionRequestStatus2)"), @NamedQuery(name="ActionRequestValue.FindAllRootByDocId", query="select arv from ActionRequestValue arv where arv.documentId = :documentId and arv.currentIndicator = :currentIndicator and arv.parentActionRequest is null"), @NamedQuery(name="ActionRequestValue.FindByStatusAndDocId", query="select arv from ActionRequestValue arv where arv.documentId = :documentId and arv.currentIndicator = :currentIndicator and arv.status = :status"), @NamedQuery(name="ActionRequestValue.FindPendingByActionRequestedAndDocId", query="select arv from ActionRequestValue arv where arv.documentId = :documentId and arv.currentIndicator = :currentIndicator and arv.actionRequested = :actionRequested and (arv.status = :actionRequestStatus1 or arv.status = :actionRequestStatus2)"), @NamedQuery(name="ActionRequestValue.FindPendingByDocIdAtOrBelowRouteLevel", query="select arv from ActionRequestValue arv where arv.documentId = :documentId and arv.currentIndicator = :currentIndicator and arv.status <> :status and arv.routeLevel <= :routeLevel"), @NamedQuery(name="ActionRequestValue.FindPendingRootRequestsByDocIdAtOrBelowRouteLevel", query="select arv from ActionRequestValue arv where arv.documentId = :documentId and arv.currentIndicator = :currentIndicator and arv.parentActionRequest is null and arv.status <> :status and routeLevel <= :routeLevel"), @NamedQuery(name="ActionRequestValue.FindPendingRootRequestsByDocIdAtRouteLevel", query="select arv from ActionRequestValue arv where arv.documentId = :documentId and arv.currentIndicator = :currentIndicator and arv.parentActionRequest is null and arv.status <> :status and routeLevel = :routeLevel"), @NamedQuery(name="ActionRequestValue.FindPendingRootRequestsByDocIdAtRouteNode", query="select arv from ActionRequestValue arv where arv.documentId = :documentId and arv.currentIndicator = :currentIndicator and arv.parentActionRequest is null and arv.nodeInstance.routeNodeInstanceId = :routeNodeInstanceId and (arv.status = :actionRequestStatus1 or arv.status = :actionRequestStatus2)"), @NamedQuery(name="ActionRequestValue.FindPendingRootRequestsByDocumentType", query="select arv from ActionRequestValue arv where arv.documentId in (select drhv.documentId from DocumentRouteHeaderValue drhv where drhv.documentTypeId = :documentTypeId) and arv.currentIndicator = :currentIndicator and arv.parentActionRequest is null and (arv.status = :actionRequestStatus1 or arv.status = :actionRequestStatus2)"), @NamedQuery(name="ActionRequestValue.FindRootRequestsByDocIdAtRouteNode", query="select arv from ActionRequestValue arv where arv.documentId = :documentId and arv.currentIndicator = :currentIndicator and arv.parentActionRequest is null and arv.nodeInstance.routeNodeInstanceId = :routeNodeInstanceId"), @NamedQuery(name="ActionRequestValue.GetRequestGroupIds", query="select arv.groupId from ActionRequestValue arv where arv.documentId = :documentId and arv.currentIndicator = :currentIndicator and arv.recipientTypeCd = :recipientTypeCd"), @NamedQuery(name="ActionRequestValue.FindByStatusAndGroupId", query="select arv from ActionRequestValue arv where arv.groupId = :groupId and arv.currentIndicator = :currentIndicator and arv.status = :status")})
public class ActionRequestValue
implements Serializable {
    private static final long serialVersionUID = 8781414791855848385L;
    private static final Logger LOG = Logger.getLogger(ActionRequestValue.class);
    private static final String ACTION_CODE_RANK = "FKACB";
    private static final String RECIPIENT_TYPE_RANK = "RWU";
    private static final List DELEGATION_TYPE_RANK = Arrays.asList(DelegationType.SECONDARY, DelegationType.PRIMARY, null);
    @Id
    @GeneratedValue(generator="KREW_ACTN_RQST_S")
    @GenericGenerator(name="KREW_ACTN_RQST_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KREW_ACTN_RQST_S"), @Parameter(name="value_column", value="id")})
    @Column(name="ACTN_RQST_ID")
    private String actionRequestId;
    @Column(name="ACTN_RQST_CD")
    private String actionRequested;
    @Column(name="DOC_HDR_ID")
    private String documentId;
    @Column(name="STAT_CD")
    private String status;
    @Column(name="RSP_ID")
    private String responsibilityId;
    @Column(name="GRP_ID")
    private String groupId;
    @Column(name="RECIP_TYP_CD")
    private String recipientTypeCd;
    @Column(name="PRIO_NBR")
    private Integer priority;
    @Column(name="RTE_LVL_NBR")
    private Integer routeLevel;
    @Column(name="ACTN_TKN_ID", insertable=false, updatable=false)
    private String actionTakenId;
    @Column(name="DOC_VER_NBR")
    private Integer docVersion = 1;
    @Column(name="CRTE_DT")
    private Timestamp createDate;
    @Column(name="RSP_DESC_TXT")
    private String responsibilityDesc;
    @Column(name="ACTN_RQST_ANNOTN_TXT")
    private String annotation;
    @Column(name="VER_NBR")
    private Integer jrfVerNbr;
    @Column(name="PRNCPL_ID")
    private String principalId;
    @Column(name="FRC_ACTN")
    private Boolean forceAction;
    @Column(name="PARNT_ID", insertable=false, updatable=false)
    private String parentActionRequestId;
    @Column(name="QUAL_ROLE_NM")
    private String qualifiedRoleName;
    @Column(name="ROLE_NM")
    private String roleName;
    @Column(name="QUAL_ROLE_NM_LBL_TXT")
    private String qualifiedRoleNameLabel;
    @Transient
    private String displayStatus;
    @Column(name="RULE_ID")
    private String ruleBaseValuesId;
    @Column(name="DLGN_TYP")
    private String delegationTypeCode;
    @Column(name="APPR_PLCY")
    private String approvePolicy;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="PARNT_ID")
    private ActionRequestValue parentActionRequest;
    @Fetch(value=FetchMode.SELECT)
    @OneToMany(mappedBy="parentActionRequest", cascade={CascadeType.PERSIST, CascadeType.MERGE}, fetch=FetchType.EAGER)
    private List<ActionRequestValue> childrenRequests = new ArrayList<ActionRequestValue>();
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="ACTN_TKN_ID")
    private ActionTakenValue actionTaken;
    @Column(name="CUR_IND")
    private Boolean currentIndicator = true;
    @Transient
    private String createDateString;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="RTE_NODE_INSTN_ID")
    private RouteNodeInstance nodeInstance;
    @Column(name="RQST_LBL")
    private String requestLabel;
    @Transient
    private boolean resolveResponsibility = true;
    @Transient
    private DocumentRouteHeaderValue routeHeader;
    @Transient
    private List<ActionItem> simulatedActionItems;

    public ActionRequestValue() {
        this.createDate = new Timestamp(System.currentTimeMillis());
    }

    public void beforeInsert() {
        OrmUtils.populateAutoIncValue((Object)this, (EntityManager)KEWServiceLocator.getEntityManagerFactory().createEntityManager());
    }

    public Group getGroup() {
        if (this.getGroupId() == null) {
            LOG.error((Object)"Attempting to get a group with a blank group id");
            return null;
        }
        return KimApiServiceLocator.getGroupService().getGroup(this.getGroupId());
    }

    public String getRouteLevelName() {
        if (CompatUtils.isRouteLevelRequest(this)) {
            int routeLevelInt = this.getRouteLevel();
            if (routeLevelInt == -1) {
                return "Exception";
            }
            List<RouteNode> routeLevelNodes = CompatUtils.getRouteLevelCompatibleNodeList(KEWServiceLocator.getRouteHeaderService().getRouteHeader(this.documentId).getDocumentType());
            if (routeLevelInt >= routeLevelNodes.size()) {
                return "Not Found";
            }
            return routeLevelNodes.get(routeLevelInt).getRouteNodeName();
        }
        return this.nodeInstance == null ? "Exception" : this.nodeInstance.getName();
    }

    public boolean isUserRequest() {
        return this.principalId != null;
    }

    public Principal getPrincipal() {
        if (this.getPrincipalId() == null) {
            return null;
        }
        return KEWServiceLocator.getIdentityHelperService().getPrincipal(this.getPrincipalId());
    }

    public Person getPerson() {
        if (this.getPrincipalId() == null) {
            return null;
        }
        return KimApiServiceLocator.getPersonService().getPerson(this.getPrincipalId());
    }

    public String getDisplayName() {
        if (this.isUserRequest()) {
            Person person = this.getPerson();
            if (person != null) {
                return person.getName();
            }
        } else {
            if (this.isGroupRequest()) {
                Group group = this.getGroup();
                if (group != null) {
                    return group.getName();
                }
                return this.getGroupId();
            }
            if (this.isRoleRequest()) {
                return this.getRoleName();
            }
        }
        return "";
    }

    public Recipient getRecipient() {
        if (this.getPrincipalId() != null) {
            return new KimPrincipalRecipient((PrincipalContract)this.getPrincipal());
        }
        if (this.getGroupId() != null) {
            return new KimGroupRecipient(this.getGroup());
        }
        return new RoleRecipient(this.getRoleName());
    }

    public boolean isPending() {
        return ActionRequestStatus.INITIALIZED.getCode().equals(this.getStatus()) || ActionRequestStatus.ACTIVATED.getCode().equals(this.getStatus());
    }

    public String getStatusLabel() {
        return CodeTranslator.getActionRequestStatusLabel((String)this.getStatus());
    }

    public String getActionRequestedLabel() {
        if (StringUtils.isNotBlank((String)this.getRequestLabel())) {
            return this.getRequestLabel();
        }
        return CodeTranslator.getActionRequestLabel((String)this.getActionRequested());
    }

    public ActionTakenValue getActionTaken() {
        return this.actionTaken;
    }

    public void setActionTaken(ActionTakenValue actionTaken) {
        this.actionTaken = actionTaken;
    }

    public String getActionRequested() {
        return this.actionRequested;
    }

    public void setActionRequested(String actionRequested) {
        this.actionRequested = actionRequested;
    }

    public String getActionRequestId() {
        return this.actionRequestId;
    }

    public void setActionRequestId(String actionRequestId) {
        this.actionRequestId = actionRequestId;
    }

    public String getActionTakenId() {
        return this.actionTakenId;
    }

    public void setActionTakenId(String actionTakenId) {
        this.actionTakenId = actionTakenId;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public Timestamp getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Timestamp createDate) {
        this.createDate = createDate;
    }

    public Integer getDocVersion() {
        return this.docVersion;
    }

    public void setDocVersion(Integer docVersion) {
        this.docVersion = docVersion;
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    public Boolean getForceAction() {
        return this.forceAction;
    }

    public void setForceAction(Boolean forceAction) {
        this.forceAction = forceAction;
    }

    public Integer getJrfVerNbr() {
        return this.jrfVerNbr;
    }

    public void setJrfVerNbr(Integer jrfVerNbr) {
        this.jrfVerNbr = jrfVerNbr;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getRecipientTypeCd() {
        return this.recipientTypeCd;
    }

    public void setRecipientTypeCd(String recipientTypeCd) {
        this.recipientTypeCd = recipientTypeCd;
    }

    public String getResponsibilityDesc() {
        return this.responsibilityDesc;
    }

    public void setResponsibilityDesc(String responsibilityDesc) {
        this.responsibilityDesc = responsibilityDesc;
    }

    public String getResponsibilityId() {
        return this.responsibilityId;
    }

    public void setResponsibilityId(String responsibilityId) {
        this.responsibilityId = responsibilityId;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public Integer getRouteLevel() {
        return this.routeLevel;
    }

    public void setRouteLevel(Integer routeLevel) {
        this.routeLevel = routeLevel;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public boolean isInitialized() {
        return ActionRequestStatus.INITIALIZED.getCode().equals(this.getStatus());
    }

    public boolean isActive() {
        return ActionRequestStatus.ACTIVATED.getCode().equals(this.getStatus());
    }

    public boolean isApproveOrCompleteRequest() {
        return "A".equals(this.getActionRequested()) || "C".equals(this.getActionRequested());
    }

    public boolean isDone() {
        return ActionRequestStatus.DONE.getCode().equals(this.getStatus());
    }

    public boolean isReviewerUser() {
        return RecipientType.PRINCIPAL.getCode().equals(this.getRecipientTypeCd());
    }

    public boolean isRecipientRoutedRequest(String principalId) {
        if (principalId == null || "".equals(principalId)) {
            return false;
        }
        boolean isRecipientInGraph = false;
        if (this.isReviewerUser()) {
            isRecipientInGraph = this.getPrincipalId().equals(principalId);
        } else if (this.isGroupRequest()) {
            Group group = this.getGroup();
            if (group == null) {
                LOG.error((Object)("Was unable to retrieve workgroup " + this.getGroupId()));
            }
            isRecipientInGraph = KimApiServiceLocator.getGroupService().isMemberOfGroup(principalId, group.getId());
        }
        for (ActionRequestValue childRequest : this.getChildrenRequests()) {
            isRecipientInGraph = isRecipientInGraph || childRequest.isRecipientRoutedRequest(principalId);
        }
        return isRecipientInGraph;
    }

    public boolean isRecipientRoutedRequest(Recipient recipient) {
        if (recipient == null) {
            return false;
        }
        boolean isRecipientInGraph = false;
        if (this.isReviewerUser()) {
            if (recipient instanceof KimPrincipalRecipient) {
                isRecipientInGraph = this.getPrincipalId().equals(((KimPrincipalRecipient)recipient).getPrincipalId());
            } else if (recipient instanceof KimGroupRecipient) {
                isRecipientInGraph = KimApiServiceLocator.getGroupService().isMemberOfGroup(this.getPrincipalId(), ((KimGroupRecipient)recipient).getGroup().getId());
            }
        } else if (this.isGroupRequest()) {
            Group group = this.getGroup();
            if (group == null) {
                LOG.error((Object)("Was unable to retrieve workgroup " + this.getGroupId()));
            }
            if (recipient instanceof KimPrincipalRecipient) {
                KimPrincipalRecipient principalRecipient = (KimPrincipalRecipient)recipient;
                isRecipientInGraph = KimApiServiceLocator.getGroupService().isMemberOfGroup(principalRecipient.getPrincipalId(), group.getId());
            } else if (recipient instanceof KimGroupRecipient) {
                isRecipientInGraph = ((KimGroupRecipient)recipient).getGroup().getId().equals(group.getId());
            }
        }
        for (ActionRequestValue childRequest : this.getChildrenRequests()) {
            isRecipientInGraph = isRecipientInGraph || childRequest.isRecipientRoutedRequest(recipient);
        }
        return isRecipientInGraph;
    }

    public boolean isGroupRequest() {
        return RecipientType.GROUP.getCode().equals(this.getRecipientTypeCd());
    }

    public boolean isRoleRequest() {
        return RecipientType.ROLE.getCode().equals(this.getRecipientTypeCd());
    }

    public boolean isAcknowledgeRequest() {
        return "K".equals(this.getActionRequested());
    }

    public boolean isApproveRequest() {
        return "A".equals(this.getActionRequested());
    }

    public boolean isCompleteRequst() {
        return "C".equals(this.getActionRequested());
    }

    public boolean isFYIRequest() {
        return "F".equals(this.getActionRequested());
    }

    public static int compareActionCode(String code1, String code2, boolean completeAndApproveTheSame) {
        int cutoff = Integer.MAX_VALUE;
        if (completeAndApproveTheSame) {
            cutoff = ACTION_CODE_RANK.length() - 3;
        }
        Integer code1Index = Math.min(ACTION_CODE_RANK.indexOf(code1), cutoff);
        Integer code2Index = Math.min(ACTION_CODE_RANK.indexOf(code2), cutoff);
        return code1Index.compareTo(code2Index);
    }

    public static int compareRecipientType(String type1, String type2) {
        Integer type1Index = RECIPIENT_TYPE_RANK.indexOf(type1);
        Integer type2Index = RECIPIENT_TYPE_RANK.indexOf(type2);
        return type1Index.compareTo(type2Index);
    }

    public static int compareDelegationType(DelegationType type1, DelegationType type2) {
        Integer type1Index = DELEGATION_TYPE_RANK.indexOf(type1);
        Integer type2Index = DELEGATION_TYPE_RANK.indexOf(type2);
        return type1Index.compareTo(type2Index);
    }

    public List<ActionItem> getActionItems() {
        if (this.simulatedActionItems == null || this.simulatedActionItems.isEmpty()) {
            return (List)KEWServiceLocator.getActionListService().findByActionRequestId(this.actionRequestId);
        }
        return this.simulatedActionItems;
    }

    public List<ActionItem> getSimulatedActionItems() {
        if (this.simulatedActionItems == null) {
            this.simulatedActionItems = new ArrayList<ActionItem>();
        }
        return this.simulatedActionItems;
    }

    public void setSimulatedActionItems(List<ActionItem> simulatedActionItems) {
        this.simulatedActionItems = simulatedActionItems;
    }

    public Boolean getCurrentIndicator() {
        return this.currentIndicator;
    }

    public void setCurrentIndicator(Boolean currentIndicator) {
        this.currentIndicator = currentIndicator;
    }

    public String getParentActionRequestId() {
        return this.parentActionRequestId;
    }

    public void setParentActionRequestId(String parentActionRequestId) {
        this.parentActionRequestId = parentActionRequestId;
    }

    public ActionRequestValue getParentActionRequest() {
        return this.parentActionRequest;
    }

    public void setParentActionRequest(ActionRequestValue parentActionRequest) {
        this.parentActionRequest = parentActionRequest;
    }

    public List<ActionRequestValue> getChildrenRequests() {
        return this.childrenRequests;
    }

    public void setChildrenRequests(List<ActionRequestValue> childrenRequests) {
        this.childrenRequests = childrenRequests;
    }

    public String getQualifiedRoleName() {
        return this.qualifiedRoleName;
    }

    public void setQualifiedRoleName(String roleName) {
        this.qualifiedRoleName = roleName;
    }

    public DelegationType getDelegationType() {
        return DelegationType.fromCode((String)this.delegationTypeCode);
    }

    public void setDelegationType(DelegationType delegationPolicy) {
        this.delegationTypeCode = delegationPolicy == null ? null : delegationPolicy.getCode();
    }

    public String getDelegationTypeCode() {
        return this.delegationTypeCode;
    }

    public void setDelegationTypeCode(String delegationTypeCode) {
        this.delegationTypeCode = delegationTypeCode;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getApprovePolicy() {
        return this.approvePolicy;
    }

    public void setApprovePolicy(String requestType) {
        this.approvePolicy = requestType;
    }

    public boolean getHasApprovePolicy() {
        return this.getApprovePolicy() != null;
    }

    public boolean isDeactivated() {
        return ActionRequestStatus.DONE.getCode().equals(this.getStatus());
    }

    public boolean hasParent() {
        return this.getParentActionRequest() != null;
    }

    public boolean hasChild(ActionRequestValue actionRequest) {
        if (actionRequest == null) {
            return false;
        }
        String actionRequestId = actionRequest.getActionRequestId();
        for (ActionRequestValue childRequest : this.getChildrenRequests()) {
            if (!childRequest.equals(actionRequest) && (actionRequestId == null || !actionRequestId.equals(childRequest.getActionRequestId()))) continue;
            return true;
        }
        return false;
    }

    public String getDisplayStatus() {
        return this.displayStatus;
    }

    public void setDisplayStatus(String displayStatus) {
        this.displayStatus = displayStatus;
    }

    public String getQualifiedRoleNameLabel() {
        return this.qualifiedRoleNameLabel;
    }

    public void setQualifiedRoleNameLabel(String qualifiedRoleNameLabel) {
        this.qualifiedRoleNameLabel = qualifiedRoleNameLabel;
    }

    public String getCreateDateString() {
        if (this.createDateString == null || this.createDateString.trim().equals("")) {
            return RiceConstants.getDefaultDateFormat().format(this.getCreateDate());
        }
        return this.createDateString;
    }

    public void setCreateDateString(String createDateString) {
        this.createDateString = createDateString;
    }

    public RouteNodeInstance getNodeInstance() {
        return this.nodeInstance;
    }

    public String getPotentialNodeName() {
        return this.getNodeInstance() == null ? "" : this.getNodeInstance().getName();
    }

    public void setNodeInstance(RouteNodeInstance nodeInstance) {
        this.nodeInstance = nodeInstance;
    }

    public String getRecipientTypeLabel() {
        return RecipientType.fromCode((String)this.getRecipientTypeCd()).getLabel();
    }

    public RuleBaseValues getRuleBaseValues() {
        if (this.ruleBaseValuesId != null) {
            return this.getRuleService().findRuleBaseValuesById(this.ruleBaseValuesId);
        }
        return null;
    }

    public String getRuleBaseValuesId() {
        return this.ruleBaseValuesId;
    }

    public void setRuleBaseValuesId(String ruleBaseValuesId) {
        this.ruleBaseValuesId = ruleBaseValuesId;
    }

    private RuleServiceInternal getRuleService() {
        return (RuleServiceInternal)KEWServiceLocator.getService("enRuleServiceInternal");
    }

    public boolean isPrimaryDelegator() {
        boolean primaryDelegator = false;
        for (ActionRequestValue childRequest : this.childrenRequests) {
            primaryDelegator = DelegationType.PRIMARY.equals((Object)childRequest.getDelegationType()) || primaryDelegator;
        }
        return primaryDelegator;
    }

    public List<ActionRequestValue> getPrimaryDelegateRequests() {
        ArrayList<ActionRequestValue> primaryDelegateRequests = new ArrayList<ActionRequestValue>();
        for (ActionRequestValue childRequest : this.childrenRequests) {
            if (!DelegationType.PRIMARY.equals((Object)childRequest.getDelegationType())) continue;
            if (childRequest.isRoleRequest()) {
                for (ActionRequestValue actionRequestValue : childRequest.getChildrenRequests()) {
                    primaryDelegateRequests.add(actionRequestValue);
                }
                continue;
            }
            primaryDelegateRequests.add(childRequest);
        }
        return primaryDelegateRequests;
    }

    public boolean isAdHocRequest() {
        return "-1".equals(this.getResponsibilityId());
    }

    public boolean isGeneratedRequest() {
        return "0".equals(this.getResponsibilityId());
    }

    public boolean isExceptionRequest() {
        return "-2".equals(this.getResponsibilityId());
    }

    public boolean isRouteModuleRequest() {
        return this.getResponsibilityId() != null && !KewApiConstants.SPECIAL_RESPONSIBILITY_ID_SET.contains(this.getResponsibilityId());
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("actionRequestId", (Object)this.actionRequestId).append("actionRequested", (Object)this.actionRequested).append("documentId", (Object)this.documentId).append("status", (Object)this.status).append("responsibilityId", (Object)this.responsibilityId).append("groupId", (Object)this.groupId).append("recipientTypeCd", (Object)this.recipientTypeCd).append("priority", (Object)this.priority).append("routeLevel", (Object)this.routeLevel).append("actionTakenId", (Object)this.actionTakenId).append("docVersion", (Object)this.docVersion).append("createDate", (Object)this.createDate).append("responsibilityDesc", (Object)this.responsibilityDesc).append("annotation", (Object)this.annotation).append("jrfVerNbr", (Object)this.jrfVerNbr).append("principalId", (Object)this.principalId).append("forceAction", (Object)this.forceAction).append("parentActionRequestId", (Object)this.parentActionRequestId).append("qualifiedRoleName", (Object)this.qualifiedRoleName).append("roleName", (Object)this.roleName).append("qualifiedRoleNameLabel", (Object)this.qualifiedRoleNameLabel).append("displayStatus", (Object)this.displayStatus).append("ruleBaseValuesId", (Object)this.ruleBaseValuesId).append("delegationType", (Object)this.delegationTypeCode).append("approvePolicy", (Object)this.approvePolicy).append("actionTaken", (Object)this.actionTaken).append("currentIndicator", (Object)this.currentIndicator).append("createDateString", (Object)this.createDateString).append("nodeInstance", (Object)this.nodeInstance).toString();
    }

    public String getRequestLabel() {
        return this.requestLabel;
    }

    public void setRequestLabel(String requestLabel) {
        this.requestLabel = requestLabel;
    }

    public String getGroupName() {
        return KimApiServiceLocator.getGroupService().getGroup(this.groupId).getName();
    }

    public boolean getResolveResponsibility() {
        return this.resolveResponsibility;
    }

    public void setResolveResponsibility(boolean resolveResponsibility) {
        this.resolveResponsibility = resolveResponsibility;
    }

    public DocumentRouteHeaderValue getRouteHeader() {
        if (this.routeHeader == null && this.documentId != null) {
            this.routeHeader = KEWServiceLocator.getRouteHeaderService().getRouteHeader(this.documentId);
        }
        return this.routeHeader;
    }

    public void setRouteHeader(DocumentRouteHeaderValue routeHeader) {
        this.routeHeader = routeHeader;
    }

    public static ActionRequest to(ActionRequestValue actionRequestBo) {
        if (actionRequestBo == null) {
            return null;
        }
        return ActionRequestValue.createActionRequestBuilder(actionRequestBo).build();
    }

    private static ActionRequest.Builder createActionRequestBuilder(ActionRequestValue actionRequestBo) {
        ActionRequest.Builder builder = ActionRequest.Builder.create((String)actionRequestBo.getActionRequestId(), (ActionRequestType)ActionRequestType.fromCode((String)actionRequestBo.getActionRequested()), (ActionRequestStatus)ActionRequestStatus.fromCode((String)actionRequestBo.getStatus()), (String)actionRequestBo.getResponsibilityId(), (String)actionRequestBo.getDocumentId(), (RecipientType)RecipientType.fromCode((String)actionRequestBo.getRecipientTypeCd()));
        if (actionRequestBo.getActionTaken() != null) {
            builder.setActionTaken(ActionTaken.Builder.create((ActionTakenContract)ActionTakenValue.to(actionRequestBo.getActionTaken())));
        }
        builder.setAnnotation(actionRequestBo.getAnnotation());
        builder.setCurrent(actionRequestBo.getCurrentIndicator().booleanValue());
        builder.setDateCreated(new DateTime(actionRequestBo.getCreateDate().getTime()));
        if (actionRequestBo.getDelegationType() != null) {
            builder.setDelegationType(actionRequestBo.getDelegationType());
        }
        builder.setForceAction(actionRequestBo.getForceAction().booleanValue());
        builder.setGroupId(actionRequestBo.getGroupId());
        builder.setNodeName(actionRequestBo.getPotentialNodeName());
        if (actionRequestBo.getParentActionRequestId() != null) {
            builder.setParentActionRequestId(actionRequestBo.getParentActionRequestId());
        }
        builder.setPrincipalId(actionRequestBo.getPrincipalId());
        if (actionRequestBo.getPriority() == null) {
            builder.setPriority(1);
        } else {
            builder.setPriority(actionRequestBo.getPriority().intValue());
        }
        if (actionRequestBo.getRouteLevel() == null) {
            builder.setRouteLevel(0);
        } else {
            builder.setRouteLevel(actionRequestBo.getRouteLevel().intValue());
        }
        builder.setQualifiedRoleName(actionRequestBo.getQualifiedRoleName());
        builder.setQualifiedRoleNameLabel(actionRequestBo.getQualifiedRoleNameLabel());
        builder.setRequestLabel(actionRequestBo.getRequestLabel());
        if (!StringUtils.isBlank((String)actionRequestBo.getApprovePolicy())) {
            builder.setRequestPolicy(ActionRequestPolicy.fromCode((String)actionRequestBo.getApprovePolicy()));
        }
        builder.setResponsibilityDescription(actionRequestBo.getResponsibilityDesc());
        builder.setRoleName(actionRequestBo.getRoleName());
        if (actionRequestBo.getNodeInstance() != null) {
            builder.setRouteNodeInstanceId(actionRequestBo.getNodeInstance().getRouteNodeInstanceId());
        }
        ArrayList<ActionRequest.Builder> childRequests = new ArrayList<ActionRequest.Builder>();
        if (actionRequestBo.getChildrenRequests() != null) {
            for (ActionRequestValue childActionRequestBo : actionRequestBo.getChildrenRequests()) {
                childRequests.add(ActionRequestValue.createActionRequestBuilder(childActionRequestBo));
            }
        }
        builder.setChildRequests(childRequests);
        return builder;
    }

    public static ActionRequestValue from(ActionRequest actionRequest) {
        return ActionRequestValue.from(actionRequest, null);
    }

    public static ActionRequestValue from(ActionRequest actionRequest, DTOConverter.RouteNodeInstanceLoader routeNodeInstanceLoader) {
        return ActionRequestValue.convertActionRequest(actionRequest, null, routeNodeInstanceLoader);
    }

    private static ActionRequestValue convertActionRequest(ActionRequest actionRequest, ActionRequestValue parentActionRequestBo, DTOConverter.RouteNodeInstanceLoader routeNodeInstanceLoader) {
        if (actionRequest == null) {
            return null;
        }
        ActionRequestValue actionRequestBo = new ActionRequestFactory().createBlankActionRequest();
        ActionRequestValue.populateActionRequest(actionRequestBo, actionRequest, routeNodeInstanceLoader);
        if (parentActionRequestBo != null) {
            actionRequestBo.setParentActionRequest(parentActionRequestBo);
            actionRequestBo.setParentActionRequestId(parentActionRequestBo.getActionRequestId());
        }
        if (actionRequest.getChildRequests() != null) {
            for (ActionRequest childRequest : actionRequest.getChildRequests()) {
                actionRequestBo.getChildrenRequests().add(ActionRequestValue.convertActionRequest(childRequest, actionRequestBo, routeNodeInstanceLoader));
            }
        }
        return actionRequestBo;
    }

    private static void populateActionRequest(ActionRequestValue actionRequestBo, ActionRequest actionRequest, DTOConverter.RouteNodeInstanceLoader routeNodeInstanceLoader) {
        actionRequestBo.setActionRequested(actionRequest.getActionRequested().getCode());
        if (!StringUtils.isBlank((String)actionRequest.getId())) {
            actionRequestBo.setActionRequestId(actionRequest.getId());
        }
        if (actionRequest.getActionTaken() != null && !StringUtils.isBlank((String)actionRequest.getActionTaken().getId())) {
            actionRequestBo.setActionTakenId(actionRequest.getActionTaken().getId());
        }
        actionRequestBo.setAnnotation(actionRequest.getAnnotation());
        if (actionRequest.getRequestPolicy() != null) {
            actionRequestBo.setApprovePolicy(actionRequest.getRequestPolicy().getCode());
        }
        actionRequestBo.setCreateDate(new Timestamp(actionRequest.getDateCreated().getMillis()));
        actionRequestBo.setCurrentIndicator(actionRequest.isCurrent());
        if (actionRequest.getDelegationType() != null) {
            actionRequestBo.setDelegationType(actionRequest.getDelegationType());
        }
        actionRequestBo.setForceAction(actionRequest.isForceAction());
        actionRequestBo.setPriority(actionRequest.getPriority());
        actionRequestBo.setRouteLevel(actionRequest.getRouteLevel());
        actionRequestBo.setQualifiedRoleName(actionRequest.getQualifiedRoleName());
        actionRequestBo.setQualifiedRoleNameLabel(actionRequest.getQualifiedRoleNameLabel());
        actionRequestBo.setRecipientTypeCd(actionRequest.getRecipientType().getCode());
        actionRequestBo.setResponsibilityDesc(actionRequest.getResponsibilityDescription());
        if (!StringUtils.isBlank((String)actionRequest.getResponsibilityId())) {
            actionRequestBo.setResponsibilityId(actionRequest.getResponsibilityId());
        }
        actionRequestBo.setRoleName(actionRequest.getRoleName());
        String documentId = actionRequest.getDocumentId();
        if (documentId != null) {
            actionRequestBo.setDocumentId(documentId);
            actionRequestBo.setRouteHeader(KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId));
        }
        actionRequestBo.setStatus(actionRequest.getStatus().getCode());
        actionRequestBo.setPrincipalId(actionRequest.getPrincipalId());
        actionRequestBo.setGroupId(actionRequest.getGroupId());
        if (routeNodeInstanceLoader != null && !StringUtils.isBlank((String)actionRequest.getRouteNodeInstanceId())) {
            actionRequestBo.setNodeInstance(routeNodeInstanceLoader.load(actionRequest.getRouteNodeInstanceId()));
        }
    }
}

